package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AgreementAcceptanceState;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "agreementFileId", 
    "agreementId", 
    "deviceDisplayName", 
    "deviceId", 
    "deviceOSType", 
    "deviceOSVersion", 
    "expirationDateTime", 
    "recordedDateTime", 
    "state", 
    "userDisplayName", 
    "userEmail", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class AgreementAcceptance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.agreementAcceptance";
    }

    @JsonProperty("agreementFileId")
    protected String agreementFileId;

    @JsonProperty("agreementId")
    protected String agreementId;

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceOSType")
    protected String deviceOSType;

    @JsonProperty("deviceOSVersion")
    protected String deviceOSVersion;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("recordedDateTime")
    protected OffsetDateTime recordedDateTime;

    @JsonProperty("state")
    protected AgreementAcceptanceState state;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userEmail")
    protected String userEmail;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected AgreementAcceptance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAgreementAcceptance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String agreementFileId;
        private String agreementId;
        private String deviceDisplayName;
        private String deviceId;
        private String deviceOSType;
        private String deviceOSVersion;
        private OffsetDateTime expirationDateTime;
        private OffsetDateTime recordedDateTime;
        private AgreementAcceptanceState state;
        private String userDisplayName;
        private String userEmail;
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder agreementFileId(String agreementFileId) {
            this.agreementFileId = agreementFileId;
            this.changedFields = changedFields.add("agreementFileId");
            return this;
        }

        public Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            this.changedFields = changedFields.add("agreementId");
            return this;
        }

        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public Builder deviceOSType(String deviceOSType) {
            this.deviceOSType = deviceOSType;
            this.changedFields = changedFields.add("deviceOSType");
            return this;
        }

        public Builder deviceOSVersion(String deviceOSVersion) {
            this.deviceOSVersion = deviceOSVersion;
            this.changedFields = changedFields.add("deviceOSVersion");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder recordedDateTime(OffsetDateTime recordedDateTime) {
            this.recordedDateTime = recordedDateTime;
            this.changedFields = changedFields.add("recordedDateTime");
            return this;
        }

        public Builder state(AgreementAcceptanceState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userEmail(String userEmail) {
            this.userEmail = userEmail;
            this.changedFields = changedFields.add("userEmail");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public AgreementAcceptance build() {
            AgreementAcceptance _x = new AgreementAcceptance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.agreementAcceptance";
            _x.id = id;
            _x.agreementFileId = agreementFileId;
            _x.agreementId = agreementId;
            _x.deviceDisplayName = deviceDisplayName;
            _x.deviceId = deviceId;
            _x.deviceOSType = deviceOSType;
            _x.deviceOSVersion = deviceOSVersion;
            _x.expirationDateTime = expirationDateTime;
            _x.recordedDateTime = recordedDateTime;
            _x.state = state;
            _x.userDisplayName = userDisplayName;
            _x.userEmail = userEmail;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="agreementFileId")
    @JsonIgnore
    public Optional<String> getAgreementFileId() {
        return Optional.ofNullable(agreementFileId);
    }

    public AgreementAcceptance withAgreementFileId(String agreementFileId) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("agreementFileId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.agreementFileId = agreementFileId;
        return _x;
    }

    @Property(name="agreementId")
    @JsonIgnore
    public Optional<String> getAgreementId() {
        return Optional.ofNullable(agreementId);
    }

    public AgreementAcceptance withAgreementId(String agreementId) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("agreementId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.agreementId = agreementId;
        return _x;
    }

    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    public AgreementAcceptance withDeviceDisplayName(String deviceDisplayName) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    public AgreementAcceptance withDeviceId(String deviceId) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.deviceId = deviceId;
        return _x;
    }

    @Property(name="deviceOSType")
    @JsonIgnore
    public Optional<String> getDeviceOSType() {
        return Optional.ofNullable(deviceOSType);
    }

    public AgreementAcceptance withDeviceOSType(String deviceOSType) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("deviceOSType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.deviceOSType = deviceOSType;
        return _x;
    }

    @Property(name="deviceOSVersion")
    @JsonIgnore
    public Optional<String> getDeviceOSVersion() {
        return Optional.ofNullable(deviceOSVersion);
    }

    public AgreementAcceptance withDeviceOSVersion(String deviceOSVersion) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("deviceOSVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.deviceOSVersion = deviceOSVersion;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public AgreementAcceptance withExpirationDateTime(OffsetDateTime expirationDateTime) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="recordedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRecordedDateTime() {
        return Optional.ofNullable(recordedDateTime);
    }

    public AgreementAcceptance withRecordedDateTime(OffsetDateTime recordedDateTime) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("recordedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.recordedDateTime = recordedDateTime;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<AgreementAcceptanceState> getState() {
        return Optional.ofNullable(state);
    }

    public AgreementAcceptance withState(AgreementAcceptanceState state) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.state = state;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public AgreementAcceptance withUserDisplayName(String userDisplayName) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userEmail")
    @JsonIgnore
    public Optional<String> getUserEmail() {
        return Optional.ofNullable(userEmail);
    }

    public AgreementAcceptance withUserEmail(String userEmail) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("userEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.userEmail = userEmail;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public AgreementAcceptance withUserId(String userId) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public AgreementAcceptance withUserPrincipalName(String userPrincipalName) {
        AgreementAcceptance _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementAcceptance");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public AgreementAcceptance withUnmappedField(String name, Object value) {
        AgreementAcceptance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgreementAcceptance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AgreementAcceptance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgreementAcceptance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AgreementAcceptance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AgreementAcceptance _copy() {
        AgreementAcceptance _x = new AgreementAcceptance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.agreementFileId = agreementFileId;
        _x.agreementId = agreementId;
        _x.deviceDisplayName = deviceDisplayName;
        _x.deviceId = deviceId;
        _x.deviceOSType = deviceOSType;
        _x.deviceOSVersion = deviceOSVersion;
        _x.expirationDateTime = expirationDateTime;
        _x.recordedDateTime = recordedDateTime;
        _x.state = state;
        _x.userDisplayName = userDisplayName;
        _x.userEmail = userEmail;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AgreementAcceptance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("agreementFileId=");
        b.append(this.agreementFileId);
        b.append(", ");
        b.append("agreementId=");
        b.append(this.agreementId);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceOSType=");
        b.append(this.deviceOSType);
        b.append(", ");
        b.append("deviceOSVersion=");
        b.append(this.deviceOSVersion);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("recordedDateTime=");
        b.append(this.recordedDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userEmail=");
        b.append(this.userEmail);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
