package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.TermsExpiration;
import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementFileLocalizationCollectionRequest;
import odata.msgraph.client.beta.entity.request.AgreementFileRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isPerDeviceAcceptanceRequired", 
    "isViewingBeforeAcceptanceRequired", 
    "termsExpiration", 
    "userReacceptRequiredFrequency", 
    "acceptances", 
    "file", 
    "files"})
@JsonInclude(Include.NON_NULL)
public class Agreement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.agreement";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isPerDeviceAcceptanceRequired")
    protected Boolean isPerDeviceAcceptanceRequired;

    @JsonProperty("isViewingBeforeAcceptanceRequired")
    protected Boolean isViewingBeforeAcceptanceRequired;

    @JsonProperty("termsExpiration")
    protected TermsExpiration termsExpiration;

    @JsonProperty("userReacceptRequiredFrequency")
    protected Duration userReacceptRequiredFrequency;

    @JsonProperty("acceptances")
    protected List<AgreementAcceptance> acceptances;

    @JsonProperty("file")
    protected AgreementFile file;

    @JsonProperty("files")
    protected List<AgreementFileLocalization> files;

    protected Agreement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAgreement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean isPerDeviceAcceptanceRequired;
        private Boolean isViewingBeforeAcceptanceRequired;
        private TermsExpiration termsExpiration;
        private Duration userReacceptRequiredFrequency;
        private List<AgreementAcceptance> acceptances;
        private AgreementFile file;
        private List<AgreementFileLocalization> files;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isPerDeviceAcceptanceRequired(Boolean isPerDeviceAcceptanceRequired) {
            this.isPerDeviceAcceptanceRequired = isPerDeviceAcceptanceRequired;
            this.changedFields = changedFields.add("isPerDeviceAcceptanceRequired");
            return this;
        }

        public Builder isViewingBeforeAcceptanceRequired(Boolean isViewingBeforeAcceptanceRequired) {
            this.isViewingBeforeAcceptanceRequired = isViewingBeforeAcceptanceRequired;
            this.changedFields = changedFields.add("isViewingBeforeAcceptanceRequired");
            return this;
        }

        public Builder termsExpiration(TermsExpiration termsExpiration) {
            this.termsExpiration = termsExpiration;
            this.changedFields = changedFields.add("termsExpiration");
            return this;
        }

        public Builder userReacceptRequiredFrequency(Duration userReacceptRequiredFrequency) {
            this.userReacceptRequiredFrequency = userReacceptRequiredFrequency;
            this.changedFields = changedFields.add("userReacceptRequiredFrequency");
            return this;
        }

        public Builder acceptances(List<AgreementAcceptance> acceptances) {
            this.acceptances = acceptances;
            this.changedFields = changedFields.add("acceptances");
            return this;
        }

        public Builder acceptances(AgreementAcceptance... acceptances) {
            return acceptances(Arrays.asList(acceptances));
        }

        public Builder file(AgreementFile file) {
            this.file = file;
            this.changedFields = changedFields.add("file");
            return this;
        }

        public Builder files(List<AgreementFileLocalization> files) {
            this.files = files;
            this.changedFields = changedFields.add("files");
            return this;
        }

        public Builder files(AgreementFileLocalization... files) {
            return files(Arrays.asList(files));
        }

        public Agreement build() {
            Agreement _x = new Agreement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.agreement";
            _x.id = id;
            _x.displayName = displayName;
            _x.isPerDeviceAcceptanceRequired = isPerDeviceAcceptanceRequired;
            _x.isViewingBeforeAcceptanceRequired = isViewingBeforeAcceptanceRequired;
            _x.termsExpiration = termsExpiration;
            _x.userReacceptRequiredFrequency = userReacceptRequiredFrequency;
            _x.acceptances = acceptances;
            _x.file = file;
            _x.files = files;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Agreement withDisplayName(String displayName) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isPerDeviceAcceptanceRequired")
    @JsonIgnore
    public Optional<Boolean> getIsPerDeviceAcceptanceRequired() {
        return Optional.ofNullable(isPerDeviceAcceptanceRequired);
    }

    public Agreement withIsPerDeviceAcceptanceRequired(Boolean isPerDeviceAcceptanceRequired) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("isPerDeviceAcceptanceRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.isPerDeviceAcceptanceRequired = isPerDeviceAcceptanceRequired;
        return _x;
    }

    @Property(name="isViewingBeforeAcceptanceRequired")
    @JsonIgnore
    public Optional<Boolean> getIsViewingBeforeAcceptanceRequired() {
        return Optional.ofNullable(isViewingBeforeAcceptanceRequired);
    }

    public Agreement withIsViewingBeforeAcceptanceRequired(Boolean isViewingBeforeAcceptanceRequired) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("isViewingBeforeAcceptanceRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.isViewingBeforeAcceptanceRequired = isViewingBeforeAcceptanceRequired;
        return _x;
    }

    @Property(name="termsExpiration")
    @JsonIgnore
    public Optional<TermsExpiration> getTermsExpiration() {
        return Optional.ofNullable(termsExpiration);
    }

    public Agreement withTermsExpiration(TermsExpiration termsExpiration) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("termsExpiration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.termsExpiration = termsExpiration;
        return _x;
    }

    @Property(name="userReacceptRequiredFrequency")
    @JsonIgnore
    public Optional<Duration> getUserReacceptRequiredFrequency() {
        return Optional.ofNullable(userReacceptRequiredFrequency);
    }

    public Agreement withUserReacceptRequiredFrequency(Duration userReacceptRequiredFrequency) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("userReacceptRequiredFrequency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.userReacceptRequiredFrequency = userReacceptRequiredFrequency;
        return _x;
    }

    public Agreement withUnmappedField(String name, Object value) {
        Agreement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="acceptances")
    @JsonIgnore
    public AgreementAcceptanceCollectionRequest getAcceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("acceptances"), Optional.ofNullable(acceptances));
    }

    @NavigationProperty(name="file")
    @JsonIgnore
    public AgreementFileRequest getFile() {
        return new AgreementFileRequest(contextPath.addSegment("file"), Optional.ofNullable(file));
    }

    @NavigationProperty(name="files")
    @JsonIgnore
    public AgreementFileLocalizationCollectionRequest getFiles() {
        return new AgreementFileLocalizationCollectionRequest(
                        contextPath.addSegment("files"), Optional.ofNullable(files));
    }

    public Agreement withAcceptances(List<AgreementAcceptance> acceptances) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("acceptances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.acceptances = acceptances;
        return _x;
    }

    public Agreement withFile(AgreementFile file) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("file");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.file = file;
        return _x;
    }

    public Agreement withFiles(List<AgreementFileLocalization> files) {
        Agreement _x = _copy();
        _x.changedFields = changedFields.add("files");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreement");
        _x.files = files;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Agreement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Agreement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Agreement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Agreement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Agreement _copy() {
        Agreement _x = new Agreement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.isPerDeviceAcceptanceRequired = isPerDeviceAcceptanceRequired;
        _x.isViewingBeforeAcceptanceRequired = isViewingBeforeAcceptanceRequired;
        _x.termsExpiration = termsExpiration;
        _x.userReacceptRequiredFrequency = userReacceptRequiredFrequency;
        _x.acceptances = acceptances;
        _x.file = file;
        _x.files = files;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Agreement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isPerDeviceAcceptanceRequired=");
        b.append(this.isPerDeviceAcceptanceRequired);
        b.append(", ");
        b.append("isViewingBeforeAcceptanceRequired=");
        b.append(this.isViewingBeforeAcceptanceRequired);
        b.append(", ");
        b.append("termsExpiration=");
        b.append(this.termsExpiration);
        b.append(", ");
        b.append("userReacceptRequiredFrequency=");
        b.append(this.userReacceptRequiredFrequency);
        b.append(", ");
        b.append("acceptances=");
        b.append(this.acceptances);
        b.append(", ");
        b.append("file=");
        b.append(this.file);
        b.append(", ");
        b.append("files=");
        b.append(this.files);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
