package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "agedAsOfDate", 
    "balanceDue", 
    "currencyCode", 
    "currentAmount", 
    "customerNumber", 
    "name", 
    "period1Amount", 
    "period2Amount", 
    "period3Amount", 
    "periodLengthFilter"})
@JsonInclude(Include.NON_NULL)
public class AgedAccountsReceivable extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.agedAccountsReceivable";
    }

    @JsonProperty("agedAsOfDate")
    protected LocalDate agedAsOfDate;

    @JsonProperty("balanceDue")
    protected BigDecimal balanceDue;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("currentAmount")
    protected BigDecimal currentAmount;

    @JsonProperty("customerNumber")
    protected String customerNumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("period1Amount")
    protected BigDecimal period1Amount;

    @JsonProperty("period2Amount")
    protected BigDecimal period2Amount;

    @JsonProperty("period3Amount")
    protected BigDecimal period3Amount;

    @JsonProperty("periodLengthFilter")
    protected String periodLengthFilter;

    protected AgedAccountsReceivable() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAgedAccountsReceivable() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate agedAsOfDate;
        private BigDecimal balanceDue;
        private String currencyCode;
        private BigDecimal currentAmount;
        private String customerNumber;
        private String name;
        private BigDecimal period1Amount;
        private BigDecimal period2Amount;
        private BigDecimal period3Amount;
        private String periodLengthFilter;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder agedAsOfDate(LocalDate agedAsOfDate) {
            this.agedAsOfDate = agedAsOfDate;
            this.changedFields = changedFields.add("agedAsOfDate");
            return this;
        }

        public Builder balanceDue(BigDecimal balanceDue) {
            this.balanceDue = balanceDue;
            this.changedFields = changedFields.add("balanceDue");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder currentAmount(BigDecimal currentAmount) {
            this.currentAmount = currentAmount;
            this.changedFields = changedFields.add("currentAmount");
            return this;
        }

        public Builder customerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            this.changedFields = changedFields.add("customerNumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder period1Amount(BigDecimal period1Amount) {
            this.period1Amount = period1Amount;
            this.changedFields = changedFields.add("period1Amount");
            return this;
        }

        public Builder period2Amount(BigDecimal period2Amount) {
            this.period2Amount = period2Amount;
            this.changedFields = changedFields.add("period2Amount");
            return this;
        }

        public Builder period3Amount(BigDecimal period3Amount) {
            this.period3Amount = period3Amount;
            this.changedFields = changedFields.add("period3Amount");
            return this;
        }

        public Builder periodLengthFilter(String periodLengthFilter) {
            this.periodLengthFilter = periodLengthFilter;
            this.changedFields = changedFields.add("periodLengthFilter");
            return this;
        }

        public AgedAccountsReceivable build() {
            AgedAccountsReceivable _x = new AgedAccountsReceivable();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.agedAccountsReceivable";
            _x.id = id;
            _x.agedAsOfDate = agedAsOfDate;
            _x.balanceDue = balanceDue;
            _x.currencyCode = currencyCode;
            _x.currentAmount = currentAmount;
            _x.customerNumber = customerNumber;
            _x.name = name;
            _x.period1Amount = period1Amount;
            _x.period2Amount = period2Amount;
            _x.period3Amount = period3Amount;
            _x.periodLengthFilter = periodLengthFilter;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="agedAsOfDate")
    @JsonIgnore
    public Optional<LocalDate> getAgedAsOfDate() {
        return Optional.ofNullable(agedAsOfDate);
    }

    public AgedAccountsReceivable withAgedAsOfDate(LocalDate agedAsOfDate) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("agedAsOfDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.agedAsOfDate = agedAsOfDate;
        return _x;
    }

    @Property(name="balanceDue")
    @JsonIgnore
    public Optional<BigDecimal> getBalanceDue() {
        return Optional.ofNullable(balanceDue);
    }

    public AgedAccountsReceivable withBalanceDue(BigDecimal balanceDue) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("balanceDue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.balanceDue = balanceDue;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public AgedAccountsReceivable withCurrencyCode(String currencyCode) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="currentAmount")
    @JsonIgnore
    public Optional<BigDecimal> getCurrentAmount() {
        return Optional.ofNullable(currentAmount);
    }

    public AgedAccountsReceivable withCurrentAmount(BigDecimal currentAmount) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("currentAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.currentAmount = currentAmount;
        return _x;
    }

    @Property(name="customerNumber")
    @JsonIgnore
    public Optional<String> getCustomerNumber() {
        return Optional.ofNullable(customerNumber);
    }

    public AgedAccountsReceivable withCustomerNumber(String customerNumber) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("customerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.customerNumber = customerNumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AgedAccountsReceivable withName(String name) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.name = name;
        return _x;
    }

    @Property(name="period1Amount")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod1Amount() {
        return Optional.ofNullable(period1Amount);
    }

    public AgedAccountsReceivable withPeriod1Amount(BigDecimal period1Amount) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("period1Amount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.period1Amount = period1Amount;
        return _x;
    }

    @Property(name="period2Amount")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod2Amount() {
        return Optional.ofNullable(period2Amount);
    }

    public AgedAccountsReceivable withPeriod2Amount(BigDecimal period2Amount) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("period2Amount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.period2Amount = period2Amount;
        return _x;
    }

    @Property(name="period3Amount")
    @JsonIgnore
    public Optional<BigDecimal> getPeriod3Amount() {
        return Optional.ofNullable(period3Amount);
    }

    public AgedAccountsReceivable withPeriod3Amount(BigDecimal period3Amount) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("period3Amount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.period3Amount = period3Amount;
        return _x;
    }

    @Property(name="periodLengthFilter")
    @JsonIgnore
    public Optional<String> getPeriodLengthFilter() {
        return Optional.ofNullable(periodLengthFilter);
    }

    public AgedAccountsReceivable withPeriodLengthFilter(String periodLengthFilter) {
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = changedFields.add("periodLengthFilter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agedAccountsReceivable");
        _x.periodLengthFilter = periodLengthFilter;
        return _x;
    }

    public AgedAccountsReceivable withUnmappedField(String name, Object value) {
        AgedAccountsReceivable _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgedAccountsReceivable patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgedAccountsReceivable put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AgedAccountsReceivable _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AgedAccountsReceivable _copy() {
        AgedAccountsReceivable _x = new AgedAccountsReceivable();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.agedAsOfDate = agedAsOfDate;
        _x.balanceDue = balanceDue;
        _x.currencyCode = currencyCode;
        _x.currentAmount = currentAmount;
        _x.customerNumber = customerNumber;
        _x.name = name;
        _x.period1Amount = period1Amount;
        _x.period2Amount = period2Amount;
        _x.period3Amount = period3Amount;
        _x.periodLengthFilter = periodLengthFilter;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AgedAccountsReceivable[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("agedAsOfDate=");
        b.append(this.agedAsOfDate);
        b.append(", ");
        b.append("balanceDue=");
        b.append(this.balanceDue);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("currentAmount=");
        b.append(this.currentAmount);
        b.append(", ");
        b.append("customerNumber=");
        b.append(this.customerNumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("period1Amount=");
        b.append(this.period1Amount);
        b.append(", ");
        b.append("period2Amount=");
        b.append(this.period2Amount);
        b.append(", ");
        b.append("period3Amount=");
        b.append(this.period3Amount);
        b.append(", ");
        b.append("periodLengthFilter=");
        b.append(this.periodLengthFilter);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
