package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.ServiceAnnouncementRequest;
import odata.msgraph.client.beta.windows.updates.entity.Windows;
import odata.msgraph.client.beta.windows.updates.entity.request.WindowsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "serviceAnnouncement", 
    "windows"})
@JsonInclude(Include.NON_NULL)
public class Admin implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.admin";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("serviceAnnouncement")
    protected ServiceAnnouncement serviceAnnouncement;

    @JsonProperty("windows")
    protected Windows windows;

    protected Admin() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ServiceAnnouncement serviceAnnouncement;
        private Windows windows;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder serviceAnnouncement(ServiceAnnouncement serviceAnnouncement) {
            this.serviceAnnouncement = serviceAnnouncement;
            this.changedFields = changedFields.add("serviceAnnouncement");
            return this;
        }

        public Builder windows(Windows windows) {
            this.windows = windows;
            this.changedFields = changedFields.add("windows");
            return this;
        }

        public Admin build() {
            Admin _x = new Admin();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.admin";
            _x.serviceAnnouncement = serviceAnnouncement;
            _x.windows = windows;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public Admin withUnmappedField(String name, Object value) {
        Admin _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="serviceAnnouncement")
    @JsonIgnore
    public ServiceAnnouncementRequest getServiceAnnouncement() {
        return new ServiceAnnouncementRequest(contextPath.addSegment("serviceAnnouncement"), Optional.ofNullable(serviceAnnouncement));
    }

    @NavigationProperty(name="windows")
    @JsonIgnore
    public WindowsRequest getWindows() {
        return new WindowsRequest(contextPath.addSegment("windows"), Optional.ofNullable(windows));
    }

    public Admin withServiceAnnouncement(ServiceAnnouncement serviceAnnouncement) {
        Admin _x = _copy();
        _x.changedFields = changedFields.add("serviceAnnouncement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.admin");
        _x.serviceAnnouncement = serviceAnnouncement;
        return _x;
    }

    public Admin withWindows(Windows windows) {
        Admin _x = _copy();
        _x.changedFields = changedFields.add("windows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.admin");
        _x.windows = windows;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Admin patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Admin _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Admin put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Admin _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Admin _copy() {
        Admin _x = new Admin();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.serviceAnnouncement = serviceAnnouncement;
        _x.windows = windows;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Admin[");
        b.append("serviceAnnouncement=");
        b.append(this.serviceAnnouncement);
        b.append(", ");
        b.append("windows=");
        b.append(this.windows);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
