package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OutOfBoxExperienceSettings;
import odata.msgraph.client.beta.complex.WindowsEnrollmentStatusScreenSettings;
import odata.msgraph.client.beta.entity.request.WindowsDomainJoinConfigurationRequest;
import odata.msgraph.client.beta.enums.WindowsAutopilotDeviceType;


/**
 * <i>“Windows Autopilot Deployment Profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "hybridAzureADJoinSkipConnectivityCheck", 
    "domainJoinConfiguration"})
@JsonInclude(Include.NON_NULL)
public class ActiveDirectoryWindowsAutopilotDeploymentProfile extends WindowsAutopilotDeploymentProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.activeDirectoryWindowsAutopilotDeploymentProfile";
    }

    @JsonProperty("hybridAzureADJoinSkipConnectivityCheck")
    protected Boolean hybridAzureADJoinSkipConnectivityCheck;

    @JsonProperty("domainJoinConfiguration")
    protected WindowsDomainJoinConfiguration domainJoinConfiguration;

    protected ActiveDirectoryWindowsAutopilotDeploymentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderActiveDirectoryWindowsAutopilotDeploymentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String deviceNameTemplate;
        private WindowsAutopilotDeviceType deviceType;
        private String displayName;
        private Boolean enableWhiteGlove;
        private WindowsEnrollmentStatusScreenSettings enrollmentStatusScreenSettings;
        private Boolean extractHardwareHash;
        private String language;
        private OffsetDateTime lastModifiedDateTime;
        private String managementServiceAppId;
        private OutOfBoxExperienceSettings outOfBoxExperienceSettings;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private List<WindowsAutopilotDeviceIdentity> assignedDevices;
        private List<WindowsAutopilotDeploymentProfileAssignment> assignments;
        private Boolean hybridAzureADJoinSkipConnectivityCheck;
        private WindowsDomainJoinConfiguration domainJoinConfiguration;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceNameTemplate(String deviceNameTemplate) {
            this.deviceNameTemplate = deviceNameTemplate;
            this.changedFields = changedFields.add("deviceNameTemplate");
            return this;
        }

        public Builder deviceType(WindowsAutopilotDeviceType deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder enableWhiteGlove(Boolean enableWhiteGlove) {
            this.enableWhiteGlove = enableWhiteGlove;
            this.changedFields = changedFields.add("enableWhiteGlove");
            return this;
        }

        public Builder enrollmentStatusScreenSettings(WindowsEnrollmentStatusScreenSettings enrollmentStatusScreenSettings) {
            this.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
            this.changedFields = changedFields.add("enrollmentStatusScreenSettings");
            return this;
        }

        public Builder extractHardwareHash(Boolean extractHardwareHash) {
            this.extractHardwareHash = extractHardwareHash;
            this.changedFields = changedFields.add("extractHardwareHash");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder managementServiceAppId(String managementServiceAppId) {
            this.managementServiceAppId = managementServiceAppId;
            this.changedFields = changedFields.add("managementServiceAppId");
            return this;
        }

        public Builder outOfBoxExperienceSettings(OutOfBoxExperienceSettings outOfBoxExperienceSettings) {
            this.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
            this.changedFields = changedFields.add("outOfBoxExperienceSettings");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder assignedDevices(List<WindowsAutopilotDeviceIdentity> assignedDevices) {
            this.assignedDevices = assignedDevices;
            this.changedFields = changedFields.add("assignedDevices");
            return this;
        }

        public Builder assignedDevices(WindowsAutopilotDeviceIdentity... assignedDevices) {
            return assignedDevices(Arrays.asList(assignedDevices));
        }

        public Builder assignments(List<WindowsAutopilotDeploymentProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(WindowsAutopilotDeploymentProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“The Autopilot Hybrid Azure AD join flow will continue even if it does not
         * establish domain controller connectivity during OOBE.”</i>
         * 
         * @param hybridAzureADJoinSkipConnectivityCheck
         *            value of {@code hybridAzureADJoinSkipConnectivityCheck} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hybridAzureADJoinSkipConnectivityCheck(Boolean hybridAzureADJoinSkipConnectivityCheck) {
            this.hybridAzureADJoinSkipConnectivityCheck = hybridAzureADJoinSkipConnectivityCheck;
            this.changedFields = changedFields.add("hybridAzureADJoinSkipConnectivityCheck");
            return this;
        }

        /**
         * <i>“Configuration to join Active Directory domain”</i>
         * 
         * @param domainJoinConfiguration
         *            value of {@code domainJoinConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainJoinConfiguration(WindowsDomainJoinConfiguration domainJoinConfiguration) {
            this.domainJoinConfiguration = domainJoinConfiguration;
            this.changedFields = changedFields.add("domainJoinConfiguration");
            return this;
        }

        public ActiveDirectoryWindowsAutopilotDeploymentProfile build() {
            ActiveDirectoryWindowsAutopilotDeploymentProfile _x = new ActiveDirectoryWindowsAutopilotDeploymentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.activeDirectoryWindowsAutopilotDeploymentProfile";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceNameTemplate = deviceNameTemplate;
            _x.deviceType = deviceType;
            _x.displayName = displayName;
            _x.enableWhiteGlove = enableWhiteGlove;
            _x.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
            _x.extractHardwareHash = extractHardwareHash;
            _x.language = language;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.managementServiceAppId = managementServiceAppId;
            _x.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.assignedDevices = assignedDevices;
            _x.assignments = assignments;
            _x.hybridAzureADJoinSkipConnectivityCheck = hybridAzureADJoinSkipConnectivityCheck;
            _x.domainJoinConfiguration = domainJoinConfiguration;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The Autopilot Hybrid Azure AD join flow will continue even if it does not
     * establish domain controller connectivity during OOBE.”</i>
     * 
     * @return property hybridAzureADJoinSkipConnectivityCheck
     */
    @Property(name="hybridAzureADJoinSkipConnectivityCheck")
    @JsonIgnore
    public Optional<Boolean> getHybridAzureADJoinSkipConnectivityCheck() {
        return Optional.ofNullable(hybridAzureADJoinSkipConnectivityCheck);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hybridAzureADJoinSkipConnectivityCheck} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The Autopilot Hybrid Azure AD join flow will continue even if it does not
     * establish domain controller connectivity during OOBE.”</i>
     * 
     * @param hybridAzureADJoinSkipConnectivityCheck
     *            new value of {@code hybridAzureADJoinSkipConnectivityCheck} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hybridAzureADJoinSkipConnectivityCheck} field changed
     */
    public ActiveDirectoryWindowsAutopilotDeploymentProfile withHybridAzureADJoinSkipConnectivityCheck(Boolean hybridAzureADJoinSkipConnectivityCheck) {
        ActiveDirectoryWindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("hybridAzureADJoinSkipConnectivityCheck");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activeDirectoryWindowsAutopilotDeploymentProfile");
        _x.hybridAzureADJoinSkipConnectivityCheck = hybridAzureADJoinSkipConnectivityCheck;
        return _x;
    }

    public ActiveDirectoryWindowsAutopilotDeploymentProfile withUnmappedField(String name, Object value) {
        ActiveDirectoryWindowsAutopilotDeploymentProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Configuration to join Active Directory domain”</i>
     * 
     * @return navigational property domainJoinConfiguration
     */
    @NavigationProperty(name="domainJoinConfiguration")
    @JsonIgnore
    public WindowsDomainJoinConfigurationRequest getDomainJoinConfiguration() {
        return new WindowsDomainJoinConfigurationRequest(contextPath.addSegment("domainJoinConfiguration"), Optional.ofNullable(domainJoinConfiguration));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * domainJoinConfiguration} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configuration to join Active Directory domain”</i>
     * 
     * @param domainJoinConfiguration
     *            new value of {@code domainJoinConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code domainJoinConfiguration} field changed
     */
    public ActiveDirectoryWindowsAutopilotDeploymentProfile withDomainJoinConfiguration(WindowsDomainJoinConfiguration domainJoinConfiguration) {
        ActiveDirectoryWindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("domainJoinConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activeDirectoryWindowsAutopilotDeploymentProfile");
        _x.domainJoinConfiguration = domainJoinConfiguration;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActiveDirectoryWindowsAutopilotDeploymentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ActiveDirectoryWindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActiveDirectoryWindowsAutopilotDeploymentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ActiveDirectoryWindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ActiveDirectoryWindowsAutopilotDeploymentProfile _copy() {
        ActiveDirectoryWindowsAutopilotDeploymentProfile _x = new ActiveDirectoryWindowsAutopilotDeploymentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceNameTemplate = deviceNameTemplate;
        _x.deviceType = deviceType;
        _x.displayName = displayName;
        _x.enableWhiteGlove = enableWhiteGlove;
        _x.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
        _x.extractHardwareHash = extractHardwareHash;
        _x.language = language;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.managementServiceAppId = managementServiceAppId;
        _x.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.assignedDevices = assignedDevices;
        _x.assignments = assignments;
        _x.hybridAzureADJoinSkipConnectivityCheck = hybridAzureADJoinSkipConnectivityCheck;
        _x.domainJoinConfiguration = domainJoinConfiguration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ActiveDirectoryWindowsAutopilotDeploymentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceNameTemplate=");
        b.append(this.deviceNameTemplate);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enableWhiteGlove=");
        b.append(this.enableWhiteGlove);
        b.append(", ");
        b.append("enrollmentStatusScreenSettings=");
        b.append(this.enrollmentStatusScreenSettings);
        b.append(", ");
        b.append("extractHardwareHash=");
        b.append(this.extractHardwareHash);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("managementServiceAppId=");
        b.append(this.managementServiceAppId);
        b.append(", ");
        b.append("outOfBoxExperienceSettings=");
        b.append(this.outOfBoxExperienceSettings);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("assignedDevices=");
        b.append(this.assignedDevices);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("hybridAzureADJoinSkipConnectivityCheck=");
        b.append(this.hybridAzureADJoinSkipConnectivityCheck);
        b.append(", ");
        b.append("domainJoinConfiguration=");
        b.append(this.domainJoinConfiguration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
