package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessReviewHistoryDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceDecisionItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewScheduleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewPolicyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "decisions", 
    "definitions", 
    "historyDefinitions", 
    "policy"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewSet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewSet";
    }

    @JsonProperty("decisions")
    protected List<AccessReviewInstanceDecisionItem> decisions;

    @JsonProperty("definitions")
    protected List<AccessReviewScheduleDefinition> definitions;

    @JsonProperty("historyDefinitions")
    protected List<AccessReviewHistoryDefinition> historyDefinitions;

    @JsonProperty("policy")
    protected AccessReviewPolicy policy;

    protected AccessReviewSet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewSet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AccessReviewInstanceDecisionItem> decisions;
        private List<AccessReviewScheduleDefinition> definitions;
        private List<AccessReviewHistoryDefinition> historyDefinitions;
        private AccessReviewPolicy policy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder decisions(List<AccessReviewInstanceDecisionItem> decisions) {
            this.decisions = decisions;
            this.changedFields = changedFields.add("decisions");
            return this;
        }

        public Builder decisions(AccessReviewInstanceDecisionItem... decisions) {
            return decisions(Arrays.asList(decisions));
        }

        public Builder definitions(List<AccessReviewScheduleDefinition> definitions) {
            this.definitions = definitions;
            this.changedFields = changedFields.add("definitions");
            return this;
        }

        public Builder definitions(AccessReviewScheduleDefinition... definitions) {
            return definitions(Arrays.asList(definitions));
        }

        public Builder historyDefinitions(List<AccessReviewHistoryDefinition> historyDefinitions) {
            this.historyDefinitions = historyDefinitions;
            this.changedFields = changedFields.add("historyDefinitions");
            return this;
        }

        public Builder historyDefinitions(AccessReviewHistoryDefinition... historyDefinitions) {
            return historyDefinitions(Arrays.asList(historyDefinitions));
        }

        public Builder policy(AccessReviewPolicy policy) {
            this.policy = policy;
            this.changedFields = changedFields.add("policy");
            return this;
        }

        public AccessReviewSet build() {
            AccessReviewSet _x = new AccessReviewSet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewSet";
            _x.id = id;
            _x.decisions = decisions;
            _x.definitions = definitions;
            _x.historyDefinitions = historyDefinitions;
            _x.policy = policy;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public AccessReviewSet withUnmappedField(String name, Object value) {
        AccessReviewSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="decisions")
    @JsonIgnore
    public AccessReviewInstanceDecisionItemCollectionRequest getDecisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(
                        contextPath.addSegment("decisions"), Optional.ofNullable(decisions));
    }

    @NavigationProperty(name="definitions")
    @JsonIgnore
    public AccessReviewScheduleDefinitionCollectionRequest getDefinitions() {
        return new AccessReviewScheduleDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"), Optional.ofNullable(definitions));
    }

    @NavigationProperty(name="historyDefinitions")
    @JsonIgnore
    public AccessReviewHistoryDefinitionCollectionRequest getHistoryDefinitions() {
        return new AccessReviewHistoryDefinitionCollectionRequest(
                        contextPath.addSegment("historyDefinitions"), Optional.ofNullable(historyDefinitions));
    }

    @NavigationProperty(name="policy")
    @JsonIgnore
    public AccessReviewPolicyRequest getPolicy() {
        return new AccessReviewPolicyRequest(contextPath.addSegment("policy"), Optional.ofNullable(policy));
    }

    public AccessReviewSet withDecisions(List<AccessReviewInstanceDecisionItem> decisions) {
        AccessReviewSet _x = _copy();
        _x.changedFields = changedFields.add("decisions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSet");
        _x.decisions = decisions;
        return _x;
    }

    public AccessReviewSet withDefinitions(List<AccessReviewScheduleDefinition> definitions) {
        AccessReviewSet _x = _copy();
        _x.changedFields = changedFields.add("definitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSet");
        _x.definitions = definitions;
        return _x;
    }

    public AccessReviewSet withHistoryDefinitions(List<AccessReviewHistoryDefinition> historyDefinitions) {
        AccessReviewSet _x = _copy();
        _x.changedFields = changedFields.add("historyDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSet");
        _x.historyDefinitions = historyDefinitions;
        return _x;
    }

    public AccessReviewSet withPolicy(AccessReviewPolicy policy) {
        AccessReviewSet _x = _copy();
        _x.changedFields = changedFields.add("policy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewSet");
        _x.policy = policy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewSet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewSet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewSet _copy() {
        AccessReviewSet _x = new AccessReviewSet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.decisions = decisions;
        _x.definitions = definitions;
        _x.historyDefinitions = historyDefinitions;
        _x.policy = policy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewSet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("decisions=");
        b.append(this.decisions);
        b.append(", ");
        b.append("definitions=");
        b.append(this.definitions);
        b.append(", ");
        b.append("historyDefinitions=");
        b.append(this.historyDefinitions);
        b.append(", ");
        b.append("policy=");
        b.append(this.policy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
