package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewNotificationRecipientItem;
import odata.msgraph.client.beta.complex.AccessReviewReviewerScope;
import odata.msgraph.client.beta.complex.AccessReviewScheduleSettings;
import odata.msgraph.client.beta.complex.AccessReviewScope;
import odata.msgraph.client.beta.complex.AccessReviewStageSettings;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "additionalNotificationRecipients", 
    "backupReviewers", 
    "createdBy", 
    "createdDateTime", 
    "descriptionForAdmins", 
    "descriptionForReviewers", 
    "displayName", 
    "fallbackReviewers", 
    "instanceEnumerationScope", 
    "lastModifiedDateTime", 
    "reviewers", 
    "scope", 
    "settings", 
    "stageSettings", 
    "status", 
    "instances"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewScheduleDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewScheduleDefinition";
    }

    @JsonProperty("additionalNotificationRecipients")
    protected List<AccessReviewNotificationRecipientItem> additionalNotificationRecipients;

    @JsonProperty("additionalNotificationRecipients@nextLink")
    protected String additionalNotificationRecipientsNextLink;

    @JsonProperty("backupReviewers")
    protected List<AccessReviewReviewerScope> backupReviewers;

    @JsonProperty("backupReviewers@nextLink")
    protected String backupReviewersNextLink;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("descriptionForAdmins")
    protected String descriptionForAdmins;

    @JsonProperty("descriptionForReviewers")
    protected String descriptionForReviewers;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("fallbackReviewers")
    protected List<AccessReviewReviewerScope> fallbackReviewers;

    @JsonProperty("fallbackReviewers@nextLink")
    protected String fallbackReviewersNextLink;

    @JsonProperty("instanceEnumerationScope")
    protected AccessReviewScope instanceEnumerationScope;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("reviewers")
    protected List<AccessReviewReviewerScope> reviewers;

    @JsonProperty("reviewers@nextLink")
    protected String reviewersNextLink;

    @JsonProperty("scope")
    protected AccessReviewScope scope;

    @JsonProperty("settings")
    protected AccessReviewScheduleSettings settings;

    @JsonProperty("stageSettings")
    protected List<AccessReviewStageSettings> stageSettings;

    @JsonProperty("stageSettings@nextLink")
    protected String stageSettingsNextLink;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("instances")
    protected List<AccessReviewInstance> instances;

    protected AccessReviewScheduleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewScheduleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AccessReviewNotificationRecipientItem> additionalNotificationRecipients;
        private String additionalNotificationRecipientsNextLink;
        private List<AccessReviewReviewerScope> backupReviewers;
        private String backupReviewersNextLink;
        private UserIdentity createdBy;
        private OffsetDateTime createdDateTime;
        private String descriptionForAdmins;
        private String descriptionForReviewers;
        private String displayName;
        private List<AccessReviewReviewerScope> fallbackReviewers;
        private String fallbackReviewersNextLink;
        private AccessReviewScope instanceEnumerationScope;
        private OffsetDateTime lastModifiedDateTime;
        private List<AccessReviewReviewerScope> reviewers;
        private String reviewersNextLink;
        private AccessReviewScope scope;
        private AccessReviewScheduleSettings settings;
        private List<AccessReviewStageSettings> stageSettings;
        private String stageSettingsNextLink;
        private String status;
        private List<AccessReviewInstance> instances;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder additionalNotificationRecipients(List<AccessReviewNotificationRecipientItem> additionalNotificationRecipients) {
            this.additionalNotificationRecipients = additionalNotificationRecipients;
            this.changedFields = changedFields.add("additionalNotificationRecipients");
            return this;
        }

        public Builder additionalNotificationRecipients(AccessReviewNotificationRecipientItem... additionalNotificationRecipients) {
            return additionalNotificationRecipients(Arrays.asList(additionalNotificationRecipients));
        }

        public Builder additionalNotificationRecipientsNextLink(String additionalNotificationRecipientsNextLink) {
            this.additionalNotificationRecipientsNextLink = additionalNotificationRecipientsNextLink;
            this.changedFields = changedFields.add("additionalNotificationRecipients");
            return this;
        }

        public Builder backupReviewers(List<AccessReviewReviewerScope> backupReviewers) {
            this.backupReviewers = backupReviewers;
            this.changedFields = changedFields.add("backupReviewers");
            return this;
        }

        public Builder backupReviewers(AccessReviewReviewerScope... backupReviewers) {
            return backupReviewers(Arrays.asList(backupReviewers));
        }

        public Builder backupReviewersNextLink(String backupReviewersNextLink) {
            this.backupReviewersNextLink = backupReviewersNextLink;
            this.changedFields = changedFields.add("backupReviewers");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder descriptionForAdmins(String descriptionForAdmins) {
            this.descriptionForAdmins = descriptionForAdmins;
            this.changedFields = changedFields.add("descriptionForAdmins");
            return this;
        }

        public Builder descriptionForReviewers(String descriptionForReviewers) {
            this.descriptionForReviewers = descriptionForReviewers;
            this.changedFields = changedFields.add("descriptionForReviewers");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder fallbackReviewers(List<AccessReviewReviewerScope> fallbackReviewers) {
            this.fallbackReviewers = fallbackReviewers;
            this.changedFields = changedFields.add("fallbackReviewers");
            return this;
        }

        public Builder fallbackReviewers(AccessReviewReviewerScope... fallbackReviewers) {
            return fallbackReviewers(Arrays.asList(fallbackReviewers));
        }

        public Builder fallbackReviewersNextLink(String fallbackReviewersNextLink) {
            this.fallbackReviewersNextLink = fallbackReviewersNextLink;
            this.changedFields = changedFields.add("fallbackReviewers");
            return this;
        }

        public Builder instanceEnumerationScope(AccessReviewScope instanceEnumerationScope) {
            this.instanceEnumerationScope = instanceEnumerationScope;
            this.changedFields = changedFields.add("instanceEnumerationScope");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder reviewers(List<AccessReviewReviewerScope> reviewers) {
            this.reviewers = reviewers;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewers(AccessReviewReviewerScope... reviewers) {
            return reviewers(Arrays.asList(reviewers));
        }

        public Builder reviewersNextLink(String reviewersNextLink) {
            this.reviewersNextLink = reviewersNextLink;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder scope(AccessReviewScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder settings(AccessReviewScheduleSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder stageSettings(List<AccessReviewStageSettings> stageSettings) {
            this.stageSettings = stageSettings;
            this.changedFields = changedFields.add("stageSettings");
            return this;
        }

        public Builder stageSettings(AccessReviewStageSettings... stageSettings) {
            return stageSettings(Arrays.asList(stageSettings));
        }

        public Builder stageSettingsNextLink(String stageSettingsNextLink) {
            this.stageSettingsNextLink = stageSettingsNextLink;
            this.changedFields = changedFields.add("stageSettings");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder instances(List<AccessReviewInstance> instances) {
            this.instances = instances;
            this.changedFields = changedFields.add("instances");
            return this;
        }

        public Builder instances(AccessReviewInstance... instances) {
            return instances(Arrays.asList(instances));
        }

        public AccessReviewScheduleDefinition build() {
            AccessReviewScheduleDefinition _x = new AccessReviewScheduleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewScheduleDefinition";
            _x.id = id;
            _x.additionalNotificationRecipients = additionalNotificationRecipients;
            _x.additionalNotificationRecipientsNextLink = additionalNotificationRecipientsNextLink;
            _x.backupReviewers = backupReviewers;
            _x.backupReviewersNextLink = backupReviewersNextLink;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.descriptionForAdmins = descriptionForAdmins;
            _x.descriptionForReviewers = descriptionForReviewers;
            _x.displayName = displayName;
            _x.fallbackReviewers = fallbackReviewers;
            _x.fallbackReviewersNextLink = fallbackReviewersNextLink;
            _x.instanceEnumerationScope = instanceEnumerationScope;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.reviewers = reviewers;
            _x.reviewersNextLink = reviewersNextLink;
            _x.scope = scope;
            _x.settings = settings;
            _x.stageSettings = stageSettings;
            _x.stageSettingsNextLink = stageSettingsNextLink;
            _x.status = status;
            _x.instances = instances;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="additionalNotificationRecipients")
    @JsonIgnore
    public CollectionPage<AccessReviewNotificationRecipientItem> getAdditionalNotificationRecipients() {
        return new CollectionPage<AccessReviewNotificationRecipientItem>(contextPath, AccessReviewNotificationRecipientItem.class, this.additionalNotificationRecipients, Optional.ofNullable(additionalNotificationRecipientsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewScheduleDefinition withAdditionalNotificationRecipients(List<AccessReviewNotificationRecipientItem> additionalNotificationRecipients) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("additionalNotificationRecipients");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.additionalNotificationRecipients = additionalNotificationRecipients;
        return _x;
    }

    @Property(name="additionalNotificationRecipients")
    @JsonIgnore
    public CollectionPage<AccessReviewNotificationRecipientItem> getAdditionalNotificationRecipients(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewNotificationRecipientItem>(contextPath, AccessReviewNotificationRecipientItem.class, this.additionalNotificationRecipients, Optional.ofNullable(additionalNotificationRecipientsNextLink), Collections.emptyList(), options);
    }

    @Property(name="backupReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getBackupReviewers() {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.backupReviewers, Optional.ofNullable(backupReviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewScheduleDefinition withBackupReviewers(List<AccessReviewReviewerScope> backupReviewers) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("backupReviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.backupReviewers = backupReviewers;
        return _x;
    }

    @Property(name="backupReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getBackupReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.backupReviewers, Optional.ofNullable(backupReviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessReviewScheduleDefinition withCreatedBy(UserIdentity createdBy) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessReviewScheduleDefinition withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="descriptionForAdmins")
    @JsonIgnore
    public Optional<String> getDescriptionForAdmins() {
        return Optional.ofNullable(descriptionForAdmins);
    }

    public AccessReviewScheduleDefinition withDescriptionForAdmins(String descriptionForAdmins) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("descriptionForAdmins");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.descriptionForAdmins = descriptionForAdmins;
        return _x;
    }

    @Property(name="descriptionForReviewers")
    @JsonIgnore
    public Optional<String> getDescriptionForReviewers() {
        return Optional.ofNullable(descriptionForReviewers);
    }

    public AccessReviewScheduleDefinition withDescriptionForReviewers(String descriptionForReviewers) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("descriptionForReviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.descriptionForReviewers = descriptionForReviewers;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessReviewScheduleDefinition withDisplayName(String displayName) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="fallbackReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getFallbackReviewers() {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.fallbackReviewers, Optional.ofNullable(fallbackReviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewScheduleDefinition withFallbackReviewers(List<AccessReviewReviewerScope> fallbackReviewers) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("fallbackReviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.fallbackReviewers = fallbackReviewers;
        return _x;
    }

    @Property(name="fallbackReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getFallbackReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.fallbackReviewers, Optional.ofNullable(fallbackReviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="instanceEnumerationScope")
    @JsonIgnore
    public Optional<AccessReviewScope> getInstanceEnumerationScope() {
        return Optional.ofNullable(instanceEnumerationScope);
    }

    public AccessReviewScheduleDefinition withInstanceEnumerationScope(AccessReviewScope instanceEnumerationScope) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("instanceEnumerationScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.instanceEnumerationScope = instanceEnumerationScope;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public AccessReviewScheduleDefinition withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getReviewers() {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewScheduleDefinition withReviewers(List<AccessReviewReviewerScope> reviewers) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("reviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.reviewers = reviewers;
        return _x;
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<AccessReviewScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public AccessReviewScheduleDefinition withScope(AccessReviewScope scope) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.scope = scope;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<AccessReviewScheduleSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public AccessReviewScheduleDefinition withSettings(AccessReviewScheduleSettings settings) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.settings = settings;
        return _x;
    }

    @Property(name="stageSettings")
    @JsonIgnore
    public CollectionPage<AccessReviewStageSettings> getStageSettings() {
        return new CollectionPage<AccessReviewStageSettings>(contextPath, AccessReviewStageSettings.class, this.stageSettings, Optional.ofNullable(stageSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewScheduleDefinition withStageSettings(List<AccessReviewStageSettings> stageSettings) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("stageSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.stageSettings = stageSettings;
        return _x;
    }

    @Property(name="stageSettings")
    @JsonIgnore
    public CollectionPage<AccessReviewStageSettings> getStageSettings(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewStageSettings>(contextPath, AccessReviewStageSettings.class, this.stageSettings, Optional.ofNullable(stageSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReviewScheduleDefinition withStatus(String status) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.status = status;
        return _x;
    }

    public AccessReviewScheduleDefinition withUnmappedField(String name, Object value) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="instances")
    @JsonIgnore
    public AccessReviewInstanceCollectionRequest getInstances() {
        return new AccessReviewInstanceCollectionRequest(
                        contextPath.addSegment("instances"), Optional.ofNullable(instances));
    }

    public AccessReviewScheduleDefinition withInstances(List<AccessReviewInstance> instances) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("instances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.instances = instances;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewScheduleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewScheduleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewScheduleDefinition _copy() {
        AccessReviewScheduleDefinition _x = new AccessReviewScheduleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.additionalNotificationRecipients = additionalNotificationRecipients;
        _x.backupReviewers = backupReviewers;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.descriptionForAdmins = descriptionForAdmins;
        _x.descriptionForReviewers = descriptionForReviewers;
        _x.displayName = displayName;
        _x.fallbackReviewers = fallbackReviewers;
        _x.instanceEnumerationScope = instanceEnumerationScope;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.reviewers = reviewers;
        _x.scope = scope;
        _x.settings = settings;
        _x.stageSettings = stageSettings;
        _x.status = status;
        _x.instances = instances;
        return _x;
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewScheduleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("additionalNotificationRecipients=");
        b.append(this.additionalNotificationRecipients);
        b.append(", ");
        b.append("backupReviewers=");
        b.append(this.backupReviewers);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("descriptionForAdmins=");
        b.append(this.descriptionForAdmins);
        b.append(", ");
        b.append("descriptionForReviewers=");
        b.append(this.descriptionForReviewers);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fallbackReviewers=");
        b.append(this.fallbackReviewers);
        b.append(", ");
        b.append("instanceEnumerationScope=");
        b.append(this.instanceEnumerationScope);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("reviewers=");
        b.append(this.reviewers);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("stageSettings=");
        b.append(this.stageSettings);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("instances=");
        b.append(this.instances);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
