package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewInstanceDecisionItemResource;
import odata.msgraph.client.beta.complex.AccessReviewInstanceDecisionItemTarget;
import odata.msgraph.client.beta.complex.DecisionItemPrincipalResourceMembership;
import odata.msgraph.client.beta.complex.Identity;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.GovernanceInsightCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "accessReviewId", 
    "appliedBy", 
    "appliedDateTime", 
    "applyResult", 
    "decision", 
    "justification", 
    "principal", 
    "principalLink", 
    "principalResourceMembership", 
    "recommendation", 
    "resource", 
    "resourceLink", 
    "reviewedBy", 
    "reviewedDateTime", 
    "target", 
    "insights", 
    "instance"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstanceDecisionItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstanceDecisionItem";
    }

    @JsonProperty("accessReviewId")
    protected String accessReviewId;

    @JsonProperty("appliedBy")
    protected UserIdentity appliedBy;

    @JsonProperty("appliedDateTime")
    protected OffsetDateTime appliedDateTime;

    @JsonProperty("applyResult")
    protected String applyResult;

    @JsonProperty("decision")
    protected String decision;

    @JsonProperty("justification")
    protected String justification;

    @JsonProperty("principal")
    protected Identity principal;

    @JsonProperty("principalLink")
    protected String principalLink;

    @JsonProperty("principalResourceMembership")
    protected DecisionItemPrincipalResourceMembership principalResourceMembership;

    @JsonProperty("recommendation")
    protected String recommendation;

    @JsonProperty("resource")
    protected AccessReviewInstanceDecisionItemResource resource;

    @JsonProperty("resourceLink")
    protected String resourceLink;

    @JsonProperty("reviewedBy")
    protected UserIdentity reviewedBy;

    @JsonProperty("reviewedDateTime")
    protected OffsetDateTime reviewedDateTime;

    @JsonProperty("target")
    protected AccessReviewInstanceDecisionItemTarget target;

    @JsonProperty("insights")
    protected List<GovernanceInsight> insights;

    @JsonProperty("instance")
    protected AccessReviewInstance instance;

    protected AccessReviewInstanceDecisionItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstanceDecisionItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String accessReviewId;
        private UserIdentity appliedBy;
        private OffsetDateTime appliedDateTime;
        private String applyResult;
        private String decision;
        private String justification;
        private Identity principal;
        private String principalLink;
        private DecisionItemPrincipalResourceMembership principalResourceMembership;
        private String recommendation;
        private AccessReviewInstanceDecisionItemResource resource;
        private String resourceLink;
        private UserIdentity reviewedBy;
        private OffsetDateTime reviewedDateTime;
        private AccessReviewInstanceDecisionItemTarget target;
        private List<GovernanceInsight> insights;
        private AccessReviewInstance instance;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessReviewId(String accessReviewId) {
            this.accessReviewId = accessReviewId;
            this.changedFields = changedFields.add("accessReviewId");
            return this;
        }

        public Builder appliedBy(UserIdentity appliedBy) {
            this.appliedBy = appliedBy;
            this.changedFields = changedFields.add("appliedBy");
            return this;
        }

        public Builder appliedDateTime(OffsetDateTime appliedDateTime) {
            this.appliedDateTime = appliedDateTime;
            this.changedFields = changedFields.add("appliedDateTime");
            return this;
        }

        public Builder applyResult(String applyResult) {
            this.applyResult = applyResult;
            this.changedFields = changedFields.add("applyResult");
            return this;
        }

        public Builder decision(String decision) {
            this.decision = decision;
            this.changedFields = changedFields.add("decision");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("justification");
            return this;
        }

        public Builder principal(Identity principal) {
            this.principal = principal;
            this.changedFields = changedFields.add("principal");
            return this;
        }

        public Builder principalLink(String principalLink) {
            this.principalLink = principalLink;
            this.changedFields = changedFields.add("principalLink");
            return this;
        }

        public Builder principalResourceMembership(DecisionItemPrincipalResourceMembership principalResourceMembership) {
            this.principalResourceMembership = principalResourceMembership;
            this.changedFields = changedFields.add("principalResourceMembership");
            return this;
        }

        public Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            this.changedFields = changedFields.add("recommendation");
            return this;
        }

        public Builder resource(AccessReviewInstanceDecisionItemResource resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder resourceLink(String resourceLink) {
            this.resourceLink = resourceLink;
            this.changedFields = changedFields.add("resourceLink");
            return this;
        }

        public Builder reviewedBy(UserIdentity reviewedBy) {
            this.reviewedBy = reviewedBy;
            this.changedFields = changedFields.add("reviewedBy");
            return this;
        }

        public Builder reviewedDateTime(OffsetDateTime reviewedDateTime) {
            this.reviewedDateTime = reviewedDateTime;
            this.changedFields = changedFields.add("reviewedDateTime");
            return this;
        }

        public Builder target(AccessReviewInstanceDecisionItemTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder insights(List<GovernanceInsight> insights) {
            this.insights = insights;
            this.changedFields = changedFields.add("insights");
            return this;
        }

        public Builder insights(GovernanceInsight... insights) {
            return insights(Arrays.asList(insights));
        }

        public Builder instance(AccessReviewInstance instance) {
            this.instance = instance;
            this.changedFields = changedFields.add("instance");
            return this;
        }

        public AccessReviewInstanceDecisionItem build() {
            AccessReviewInstanceDecisionItem _x = new AccessReviewInstanceDecisionItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewInstanceDecisionItem";
            _x.id = id;
            _x.accessReviewId = accessReviewId;
            _x.appliedBy = appliedBy;
            _x.appliedDateTime = appliedDateTime;
            _x.applyResult = applyResult;
            _x.decision = decision;
            _x.justification = justification;
            _x.principal = principal;
            _x.principalLink = principalLink;
            _x.principalResourceMembership = principalResourceMembership;
            _x.recommendation = recommendation;
            _x.resource = resource;
            _x.resourceLink = resourceLink;
            _x.reviewedBy = reviewedBy;
            _x.reviewedDateTime = reviewedDateTime;
            _x.target = target;
            _x.insights = insights;
            _x.instance = instance;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accessReviewId")
    @JsonIgnore
    public Optional<String> getAccessReviewId() {
        return Optional.ofNullable(accessReviewId);
    }

    public AccessReviewInstanceDecisionItem withAccessReviewId(String accessReviewId) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("accessReviewId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.accessReviewId = accessReviewId;
        return _x;
    }

    @Property(name="appliedBy")
    @JsonIgnore
    public Optional<UserIdentity> getAppliedBy() {
        return Optional.ofNullable(appliedBy);
    }

    public AccessReviewInstanceDecisionItem withAppliedBy(UserIdentity appliedBy) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("appliedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.appliedBy = appliedBy;
        return _x;
    }

    @Property(name="appliedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAppliedDateTime() {
        return Optional.ofNullable(appliedDateTime);
    }

    public AccessReviewInstanceDecisionItem withAppliedDateTime(OffsetDateTime appliedDateTime) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("appliedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.appliedDateTime = appliedDateTime;
        return _x;
    }

    @Property(name="applyResult")
    @JsonIgnore
    public Optional<String> getApplyResult() {
        return Optional.ofNullable(applyResult);
    }

    public AccessReviewInstanceDecisionItem withApplyResult(String applyResult) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("applyResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.applyResult = applyResult;
        return _x;
    }

    @Property(name="decision")
    @JsonIgnore
    public Optional<String> getDecision() {
        return Optional.ofNullable(decision);
    }

    public AccessReviewInstanceDecisionItem withDecision(String decision) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("decision");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.decision = decision;
        return _x;
    }

    @Property(name="justification")
    @JsonIgnore
    public Optional<String> getJustification() {
        return Optional.ofNullable(justification);
    }

    public AccessReviewInstanceDecisionItem withJustification(String justification) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("justification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.justification = justification;
        return _x;
    }

    @Property(name="principal")
    @JsonIgnore
    public Optional<Identity> getPrincipal() {
        return Optional.ofNullable(principal);
    }

    public AccessReviewInstanceDecisionItem withPrincipal(Identity principal) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("principal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.principal = principal;
        return _x;
    }

    @Property(name="principalLink")
    @JsonIgnore
    public Optional<String> getPrincipalLink() {
        return Optional.ofNullable(principalLink);
    }

    public AccessReviewInstanceDecisionItem withPrincipalLink(String principalLink) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("principalLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.principalLink = principalLink;
        return _x;
    }

    @Property(name="principalResourceMembership")
    @JsonIgnore
    public Optional<DecisionItemPrincipalResourceMembership> getPrincipalResourceMembership() {
        return Optional.ofNullable(principalResourceMembership);
    }

    public AccessReviewInstanceDecisionItem withPrincipalResourceMembership(DecisionItemPrincipalResourceMembership principalResourceMembership) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("principalResourceMembership");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.principalResourceMembership = principalResourceMembership;
        return _x;
    }

    @Property(name="recommendation")
    @JsonIgnore
    public Optional<String> getRecommendation() {
        return Optional.ofNullable(recommendation);
    }

    public AccessReviewInstanceDecisionItem withRecommendation(String recommendation) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("recommendation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.recommendation = recommendation;
        return _x;
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<AccessReviewInstanceDecisionItemResource> getResource() {
        return Optional.ofNullable(resource);
    }

    public AccessReviewInstanceDecisionItem withResource(AccessReviewInstanceDecisionItemResource resource) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.resource = resource;
        return _x;
    }

    @Property(name="resourceLink")
    @JsonIgnore
    public Optional<String> getResourceLink() {
        return Optional.ofNullable(resourceLink);
    }

    public AccessReviewInstanceDecisionItem withResourceLink(String resourceLink) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("resourceLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.resourceLink = resourceLink;
        return _x;
    }

    @Property(name="reviewedBy")
    @JsonIgnore
    public Optional<UserIdentity> getReviewedBy() {
        return Optional.ofNullable(reviewedBy);
    }

    public AccessReviewInstanceDecisionItem withReviewedBy(UserIdentity reviewedBy) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("reviewedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.reviewedBy = reviewedBy;
        return _x;
    }

    @Property(name="reviewedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewedDateTime() {
        return Optional.ofNullable(reviewedDateTime);
    }

    public AccessReviewInstanceDecisionItem withReviewedDateTime(OffsetDateTime reviewedDateTime) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("reviewedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.reviewedDateTime = reviewedDateTime;
        return _x;
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<AccessReviewInstanceDecisionItemTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    public AccessReviewInstanceDecisionItem withTarget(AccessReviewInstanceDecisionItemTarget target) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.target = target;
        return _x;
    }

    public AccessReviewInstanceDecisionItem withUnmappedField(String name, Object value) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="insights")
    @JsonIgnore
    public GovernanceInsightCollectionRequest getInsights() {
        return new GovernanceInsightCollectionRequest(
                        contextPath.addSegment("insights"), Optional.ofNullable(insights));
    }

    @NavigationProperty(name="instance")
    @JsonIgnore
    public AccessReviewInstanceRequest getInstance() {
        return new AccessReviewInstanceRequest(contextPath.addSegment("instance"), Optional.ofNullable(instance));
    }

    public AccessReviewInstanceDecisionItem withInsights(List<GovernanceInsight> insights) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("insights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.insights = insights;
        return _x;
    }

    public AccessReviewInstanceDecisionItem withInstance(AccessReviewInstance instance) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("instance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.instance = instance;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstanceDecisionItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstanceDecisionItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewInstanceDecisionItem _copy() {
        AccessReviewInstanceDecisionItem _x = new AccessReviewInstanceDecisionItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessReviewId = accessReviewId;
        _x.appliedBy = appliedBy;
        _x.appliedDateTime = appliedDateTime;
        _x.applyResult = applyResult;
        _x.decision = decision;
        _x.justification = justification;
        _x.principal = principal;
        _x.principalLink = principalLink;
        _x.principalResourceMembership = principalResourceMembership;
        _x.recommendation = recommendation;
        _x.resource = resource;
        _x.resourceLink = resourceLink;
        _x.reviewedBy = reviewedBy;
        _x.reviewedDateTime = reviewedDateTime;
        _x.target = target;
        _x.insights = insights;
        _x.instance = instance;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstanceDecisionItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessReviewId=");
        b.append(this.accessReviewId);
        b.append(", ");
        b.append("appliedBy=");
        b.append(this.appliedBy);
        b.append(", ");
        b.append("appliedDateTime=");
        b.append(this.appliedDateTime);
        b.append(", ");
        b.append("applyResult=");
        b.append(this.applyResult);
        b.append(", ");
        b.append("decision=");
        b.append(this.decision);
        b.append(", ");
        b.append("justification=");
        b.append(this.justification);
        b.append(", ");
        b.append("principal=");
        b.append(this.principal);
        b.append(", ");
        b.append("principalLink=");
        b.append(this.principalLink);
        b.append(", ");
        b.append("principalResourceMembership=");
        b.append(this.principalResourceMembership);
        b.append(", ");
        b.append("recommendation=");
        b.append(this.recommendation);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("resourceLink=");
        b.append(this.resourceLink);
        b.append(", ");
        b.append("reviewedBy=");
        b.append(this.reviewedBy);
        b.append(", ");
        b.append("reviewedDateTime=");
        b.append(this.reviewedDateTime);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("insights=");
        b.append(this.insights);
        b.append(", ");
        b.append("instance=");
        b.append(this.instance);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
