package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewError;
import odata.msgraph.client.beta.complex.AccessReviewReviewerScope;
import odata.msgraph.client.beta.complex.AccessReviewScope;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceDecisionItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewReviewerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewStageCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewScheduleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "endDateTime", 
    "errors", 
    "fallbackReviewers", 
    "reviewers", 
    "scope", 
    "startDateTime", 
    "status", 
    "contactedReviewers", 
    "decisions", 
    "stages"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstance";
    }

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("errors")
    protected List<AccessReviewError> errors;

    @JsonProperty("errors@nextLink")
    protected String errorsNextLink;

    @JsonProperty("fallbackReviewers")
    protected List<AccessReviewReviewerScope> fallbackReviewers;

    @JsonProperty("fallbackReviewers@nextLink")
    protected String fallbackReviewersNextLink;

    @JsonProperty("reviewers")
    protected List<AccessReviewReviewerScope> reviewers;

    @JsonProperty("reviewers@nextLink")
    protected String reviewersNextLink;

    @JsonProperty("scope")
    protected AccessReviewScope scope;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("contactedReviewers")
    protected List<AccessReviewReviewer> contactedReviewers;

    @JsonProperty("decisions")
    protected List<AccessReviewInstanceDecisionItem> decisions;

    @JsonProperty("stages")
    protected List<AccessReviewStage> stages;

    protected AccessReviewInstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime endDateTime;
        private List<AccessReviewError> errors;
        private String errorsNextLink;
        private List<AccessReviewReviewerScope> fallbackReviewers;
        private String fallbackReviewersNextLink;
        private List<AccessReviewReviewerScope> reviewers;
        private String reviewersNextLink;
        private AccessReviewScope scope;
        private OffsetDateTime startDateTime;
        private String status;
        private List<AccessReviewReviewer> contactedReviewers;
        private List<AccessReviewInstanceDecisionItem> decisions;
        private List<AccessReviewStage> stages;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder errors(List<AccessReviewError> errors) {
            this.errors = errors;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public Builder errors(AccessReviewError... errors) {
            return errors(Arrays.asList(errors));
        }

        public Builder errorsNextLink(String errorsNextLink) {
            this.errorsNextLink = errorsNextLink;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public Builder fallbackReviewers(List<AccessReviewReviewerScope> fallbackReviewers) {
            this.fallbackReviewers = fallbackReviewers;
            this.changedFields = changedFields.add("fallbackReviewers");
            return this;
        }

        public Builder fallbackReviewers(AccessReviewReviewerScope... fallbackReviewers) {
            return fallbackReviewers(Arrays.asList(fallbackReviewers));
        }

        public Builder fallbackReviewersNextLink(String fallbackReviewersNextLink) {
            this.fallbackReviewersNextLink = fallbackReviewersNextLink;
            this.changedFields = changedFields.add("fallbackReviewers");
            return this;
        }

        public Builder reviewers(List<AccessReviewReviewerScope> reviewers) {
            this.reviewers = reviewers;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewers(AccessReviewReviewerScope... reviewers) {
            return reviewers(Arrays.asList(reviewers));
        }

        public Builder reviewersNextLink(String reviewersNextLink) {
            this.reviewersNextLink = reviewersNextLink;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder scope(AccessReviewScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder contactedReviewers(List<AccessReviewReviewer> contactedReviewers) {
            this.contactedReviewers = contactedReviewers;
            this.changedFields = changedFields.add("contactedReviewers");
            return this;
        }

        public Builder contactedReviewers(AccessReviewReviewer... contactedReviewers) {
            return contactedReviewers(Arrays.asList(contactedReviewers));
        }

        public Builder decisions(List<AccessReviewInstanceDecisionItem> decisions) {
            this.decisions = decisions;
            this.changedFields = changedFields.add("decisions");
            return this;
        }

        public Builder decisions(AccessReviewInstanceDecisionItem... decisions) {
            return decisions(Arrays.asList(decisions));
        }

        public Builder stages(List<AccessReviewStage> stages) {
            this.stages = stages;
            this.changedFields = changedFields.add("stages");
            return this;
        }

        public Builder stages(AccessReviewStage... stages) {
            return stages(Arrays.asList(stages));
        }

        public AccessReviewInstance build() {
            AccessReviewInstance _x = new AccessReviewInstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewInstance";
            _x.id = id;
            _x.endDateTime = endDateTime;
            _x.errors = errors;
            _x.errorsNextLink = errorsNextLink;
            _x.fallbackReviewers = fallbackReviewers;
            _x.fallbackReviewersNextLink = fallbackReviewersNextLink;
            _x.reviewers = reviewers;
            _x.reviewersNextLink = reviewersNextLink;
            _x.scope = scope;
            _x.startDateTime = startDateTime;
            _x.status = status;
            _x.contactedReviewers = contactedReviewers;
            _x.decisions = decisions;
            _x.stages = stages;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public AccessReviewInstance withEndDateTime(OffsetDateTime endDateTime) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<AccessReviewError> getErrors() {
        return new CollectionPage<AccessReviewError>(contextPath, AccessReviewError.class, this.errors, Optional.ofNullable(errorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewInstance withErrors(List<AccessReviewError> errors) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("errors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.errors = errors;
        return _x;
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<AccessReviewError> getErrors(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewError>(contextPath, AccessReviewError.class, this.errors, Optional.ofNullable(errorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="fallbackReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getFallbackReviewers() {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.fallbackReviewers, Optional.ofNullable(fallbackReviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewInstance withFallbackReviewers(List<AccessReviewReviewerScope> fallbackReviewers) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("fallbackReviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.fallbackReviewers = fallbackReviewers;
        return _x;
    }

    @Property(name="fallbackReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getFallbackReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.fallbackReviewers, Optional.ofNullable(fallbackReviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getReviewers() {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessReviewInstance withReviewers(List<AccessReviewReviewerScope> reviewers) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("reviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.reviewers = reviewers;
        return _x;
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<AccessReviewScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public AccessReviewInstance withScope(AccessReviewScope scope) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.scope = scope;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public AccessReviewInstance withStartDateTime(OffsetDateTime startDateTime) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReviewInstance withStatus(String status) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.status = status;
        return _x;
    }

    public AccessReviewInstance withUnmappedField(String name, Object value) {
        AccessReviewInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="contactedReviewers")
    @JsonIgnore
    public AccessReviewReviewerCollectionRequest getContactedReviewers() {
        return new AccessReviewReviewerCollectionRequest(
                        contextPath.addSegment("contactedReviewers"), Optional.ofNullable(contactedReviewers));
    }

    @NavigationProperty(name="decisions")
    @JsonIgnore
    public AccessReviewInstanceDecisionItemCollectionRequest getDecisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(
                        contextPath.addSegment("decisions"), Optional.ofNullable(decisions));
    }

    @NavigationProperty(name="definition")
    @JsonIgnore
    public AccessReviewScheduleDefinitionRequest getDefinition() {
        return new AccessReviewScheduleDefinitionRequest(contextPath.addSegment("definition"), RequestHelper.getValue(unmappedFields, "definition"));
    }

    @NavigationProperty(name="stages")
    @JsonIgnore
    public AccessReviewStageCollectionRequest getStages() {
        return new AccessReviewStageCollectionRequest(
                        contextPath.addSegment("stages"), Optional.ofNullable(stages));
    }

    public AccessReviewInstance withContactedReviewers(List<AccessReviewReviewer> contactedReviewers) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("contactedReviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.contactedReviewers = contactedReviewers;
        return _x;
    }

    public AccessReviewInstance withDecisions(List<AccessReviewInstanceDecisionItem> decisions) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("decisions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.decisions = decisions;
        return _x;
    }

    public AccessReviewInstance withStages(List<AccessReviewStage> stages) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("stages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.stages = stages;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewInstance _copy() {
        AccessReviewInstance _x = new AccessReviewInstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.endDateTime = endDateTime;
        _x.errors = errors;
        _x.fallbackReviewers = fallbackReviewers;
        _x.reviewers = reviewers;
        _x.scope = scope;
        _x.startDateTime = startDateTime;
        _x.status = status;
        _x.contactedReviewers = contactedReviewers;
        _x.decisions = decisions;
        _x.stages = stages;
        return _x;
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "acceptRecommendations")
    @JsonIgnore
    public ActionRequestNoReturn acceptRecommendations() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acceptRecommendations"), _parameters);
    }

    @Action(name = "applyDecisions")
    @JsonIgnore
    public ActionRequestNoReturn applyDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDecisions"), _parameters);
    }

    @Action(name = "batchRecordDecisions")
    @JsonIgnore
    public ActionRequestNoReturn batchRecordDecisions(String decision, String justification, String principalId, String resourceId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("decision", "Edm.String", Checks.checkIsAscii(decision))
            .put("justification", "Edm.String", Checks.checkIsAscii(justification))
            .put("principalId", "Edm.String", Checks.checkIsAscii(principalId))
            .put("resourceId", "Edm.String", Checks.checkIsAscii(resourceId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.batchRecordDecisions"), _parameters);
    }

    @Action(name = "resetDecisions")
    @JsonIgnore
    public ActionRequestNoReturn resetDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDecisions"), _parameters);
    }

    @Action(name = "sendReminder")
    @JsonIgnore
    public ActionRequestNoReturn sendReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendReminder"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("errors=");
        b.append(this.errors);
        b.append(", ");
        b.append("fallbackReviewers=");
        b.append(this.fallbackReviewers);
        b.append(", ");
        b.append("reviewers=");
        b.append(this.reviewers);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("contactedReviewers=");
        b.append(this.contactedReviewers);
        b.append(", ");
        b.append("decisions=");
        b.append(this.decisions);
        b.append(", ");
        b.append("stages=");
        b.append(this.stages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
