package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AccessReviewHistoryStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "downloadUri", 
    "expirationDateTime", 
    "fulfilledDateTime", 
    "reviewHistoryPeriodEndDateTime", 
    "reviewHistoryPeriodStartDateTime", 
    "runDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewHistoryInstance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewHistoryInstance";
    }

    @JsonProperty("downloadUri")
    protected String downloadUri;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("fulfilledDateTime")
    protected OffsetDateTime fulfilledDateTime;

    @JsonProperty("reviewHistoryPeriodEndDateTime")
    protected OffsetDateTime reviewHistoryPeriodEndDateTime;

    @JsonProperty("reviewHistoryPeriodStartDateTime")
    protected OffsetDateTime reviewHistoryPeriodStartDateTime;

    @JsonProperty("runDateTime")
    protected OffsetDateTime runDateTime;

    @JsonProperty("status")
    protected AccessReviewHistoryStatus status;

    protected AccessReviewHistoryInstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewHistoryInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String downloadUri;
        private OffsetDateTime expirationDateTime;
        private OffsetDateTime fulfilledDateTime;
        private OffsetDateTime reviewHistoryPeriodEndDateTime;
        private OffsetDateTime reviewHistoryPeriodStartDateTime;
        private OffsetDateTime runDateTime;
        private AccessReviewHistoryStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder downloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
            this.changedFields = changedFields.add("downloadUri");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder fulfilledDateTime(OffsetDateTime fulfilledDateTime) {
            this.fulfilledDateTime = fulfilledDateTime;
            this.changedFields = changedFields.add("fulfilledDateTime");
            return this;
        }

        public Builder reviewHistoryPeriodEndDateTime(OffsetDateTime reviewHistoryPeriodEndDateTime) {
            this.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
            this.changedFields = changedFields.add("reviewHistoryPeriodEndDateTime");
            return this;
        }

        public Builder reviewHistoryPeriodStartDateTime(OffsetDateTime reviewHistoryPeriodStartDateTime) {
            this.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
            this.changedFields = changedFields.add("reviewHistoryPeriodStartDateTime");
            return this;
        }

        public Builder runDateTime(OffsetDateTime runDateTime) {
            this.runDateTime = runDateTime;
            this.changedFields = changedFields.add("runDateTime");
            return this;
        }

        public Builder status(AccessReviewHistoryStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public AccessReviewHistoryInstance build() {
            AccessReviewHistoryInstance _x = new AccessReviewHistoryInstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewHistoryInstance";
            _x.id = id;
            _x.downloadUri = downloadUri;
            _x.expirationDateTime = expirationDateTime;
            _x.fulfilledDateTime = fulfilledDateTime;
            _x.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
            _x.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
            _x.runDateTime = runDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="downloadUri")
    @JsonIgnore
    public Optional<String> getDownloadUri() {
        return Optional.ofNullable(downloadUri);
    }

    public AccessReviewHistoryInstance withDownloadUri(String downloadUri) {
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = changedFields.add("downloadUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryInstance");
        _x.downloadUri = downloadUri;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public AccessReviewHistoryInstance withExpirationDateTime(OffsetDateTime expirationDateTime) {
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryInstance");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="fulfilledDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFulfilledDateTime() {
        return Optional.ofNullable(fulfilledDateTime);
    }

    public AccessReviewHistoryInstance withFulfilledDateTime(OffsetDateTime fulfilledDateTime) {
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = changedFields.add("fulfilledDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryInstance");
        _x.fulfilledDateTime = fulfilledDateTime;
        return _x;
    }

    @Property(name="reviewHistoryPeriodEndDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewHistoryPeriodEndDateTime() {
        return Optional.ofNullable(reviewHistoryPeriodEndDateTime);
    }

    public AccessReviewHistoryInstance withReviewHistoryPeriodEndDateTime(OffsetDateTime reviewHistoryPeriodEndDateTime) {
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = changedFields.add("reviewHistoryPeriodEndDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryInstance");
        _x.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
        return _x;
    }

    @Property(name="reviewHistoryPeriodStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewHistoryPeriodStartDateTime() {
        return Optional.ofNullable(reviewHistoryPeriodStartDateTime);
    }

    public AccessReviewHistoryInstance withReviewHistoryPeriodStartDateTime(OffsetDateTime reviewHistoryPeriodStartDateTime) {
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = changedFields.add("reviewHistoryPeriodStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryInstance");
        _x.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
        return _x;
    }

    @Property(name="runDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRunDateTime() {
        return Optional.ofNullable(runDateTime);
    }

    public AccessReviewHistoryInstance withRunDateTime(OffsetDateTime runDateTime) {
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = changedFields.add("runDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryInstance");
        _x.runDateTime = runDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AccessReviewHistoryStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReviewHistoryInstance withStatus(AccessReviewHistoryStatus status) {
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewHistoryInstance");
        _x.status = status;
        return _x;
    }

    public AccessReviewHistoryInstance withUnmappedField(String name, Object value) {
        AccessReviewHistoryInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewHistoryInstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewHistoryInstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewHistoryInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewHistoryInstance _copy() {
        AccessReviewHistoryInstance _x = new AccessReviewHistoryInstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.downloadUri = downloadUri;
        _x.expirationDateTime = expirationDateTime;
        _x.fulfilledDateTime = fulfilledDateTime;
        _x.reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime;
        _x.reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime;
        _x.runDateTime = runDateTime;
        _x.status = status;
        return _x;
    }

    @Action(name = "generateDownloadUri")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AccessReviewHistoryInstance> generateDownloadUri() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<AccessReviewHistoryInstance>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateDownloadUri"), AccessReviewHistoryInstance.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewHistoryInstance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("downloadUri=");
        b.append(this.downloadUri);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("fulfilledDateTime=");
        b.append(this.fulfilledDateTime);
        b.append(", ");
        b.append("reviewHistoryPeriodEndDateTime=");
        b.append(this.reviewHistoryPeriodEndDateTime);
        b.append(", ");
        b.append("reviewHistoryPeriodStartDateTime=");
        b.append(this.reviewHistoryPeriodStartDateTime);
        b.append(", ");
        b.append("runDateTime=");
        b.append(this.runDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
