package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceScopeRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "createdDateTime", 
    "modifiedBy", 
    "modifiedDateTime", 
    "accessPackageResourceRole", 
    "accessPackageResourceScope"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResourceRoleScope extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResourceRoleScope";
    }

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("modifiedBy")
    protected String modifiedBy;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("accessPackageResourceRole")
    protected AccessPackageResourceRole accessPackageResourceRole;

    @JsonProperty("accessPackageResourceScope")
    protected AccessPackageResourceScope accessPackageResourceScope;

    protected AccessPackageResourceRoleScope() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageResourceRoleScope() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String createdBy;
        private OffsetDateTime createdDateTime;
        private String modifiedBy;
        private OffsetDateTime modifiedDateTime;
        private AccessPackageResourceRole accessPackageResourceRole;
        private AccessPackageResourceScope accessPackageResourceScope;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = changedFields.add("modifiedBy");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder accessPackageResourceRole(AccessPackageResourceRole accessPackageResourceRole) {
            this.accessPackageResourceRole = accessPackageResourceRole;
            this.changedFields = changedFields.add("accessPackageResourceRole");
            return this;
        }

        public Builder accessPackageResourceScope(AccessPackageResourceScope accessPackageResourceScope) {
            this.accessPackageResourceScope = accessPackageResourceScope;
            this.changedFields = changedFields.add("accessPackageResourceScope");
            return this;
        }

        public AccessPackageResourceRoleScope build() {
            AccessPackageResourceRoleScope _x = new AccessPackageResourceRoleScope();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageResourceRoleScope";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.modifiedBy = modifiedBy;
            _x.modifiedDateTime = modifiedDateTime;
            _x.accessPackageResourceRole = accessPackageResourceRole;
            _x.accessPackageResourceScope = accessPackageResourceScope;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessPackageResourceRoleScope withCreatedBy(String createdBy) {
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRoleScope");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessPackageResourceRoleScope withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRoleScope");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="modifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    public AccessPackageResourceRoleScope withModifiedBy(String modifiedBy) {
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = changedFields.add("modifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRoleScope");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public AccessPackageResourceRoleScope withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRoleScope");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    public AccessPackageResourceRoleScope withUnmappedField(String name, Object value) {
        AccessPackageResourceRoleScope _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageResourceRole")
    @JsonIgnore
    public AccessPackageResourceRoleRequest getAccessPackageResourceRole() {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRole"), Optional.ofNullable(accessPackageResourceRole));
    }

    @NavigationProperty(name="accessPackageResourceScope")
    @JsonIgnore
    public AccessPackageResourceScopeRequest getAccessPackageResourceScope() {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScope"), Optional.ofNullable(accessPackageResourceScope));
    }

    public AccessPackageResourceRoleScope withAccessPackageResourceRole(AccessPackageResourceRole accessPackageResourceRole) {
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceRole");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRoleScope");
        _x.accessPackageResourceRole = accessPackageResourceRole;
        return _x;
    }

    public AccessPackageResourceRoleScope withAccessPackageResourceScope(AccessPackageResourceScope accessPackageResourceScope) {
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRoleScope");
        _x.accessPackageResourceScope = accessPackageResourceScope;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceRoleScope patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceRoleScope put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceRoleScope _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageResourceRoleScope _copy() {
        AccessPackageResourceRoleScope _x = new AccessPackageResourceRoleScope();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.modifiedBy = modifiedBy;
        _x.modifiedDateTime = modifiedDateTime;
        _x.accessPackageResourceRole = accessPackageResourceRole;
        _x.accessPackageResourceScope = accessPackageResourceScope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResourceRoleScope[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("modifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("accessPackageResourceRole=");
        b.append(this.accessPackageResourceRole);
        b.append(", ");
        b.append("accessPackageResourceScope=");
        b.append(this.accessPackageResourceScope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
