package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ConnectionInfo;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "connectionInfo", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "isDefaultEnvironment", 
    "modifiedBy", 
    "modifiedDateTime", 
    "originId", 
    "originSystem"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResourceEnvironment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResourceEnvironment";
    }

    @JsonProperty("connectionInfo")
    protected ConnectionInfo connectionInfo;

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isDefaultEnvironment")
    protected Boolean isDefaultEnvironment;

    @JsonProperty("modifiedBy")
    protected String modifiedBy;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("originId")
    protected String originId;

    @JsonProperty("originSystem")
    protected String originSystem;

    protected AccessPackageResourceEnvironment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageResourceEnvironment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ConnectionInfo connectionInfo;
        private String createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Boolean isDefaultEnvironment;
        private String modifiedBy;
        private OffsetDateTime modifiedDateTime;
        private String originId;
        private String originSystem;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder connectionInfo(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            this.changedFields = changedFields.add("connectionInfo");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isDefaultEnvironment(Boolean isDefaultEnvironment) {
            this.isDefaultEnvironment = isDefaultEnvironment;
            this.changedFields = changedFields.add("isDefaultEnvironment");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = changedFields.add("modifiedBy");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder originId(String originId) {
            this.originId = originId;
            this.changedFields = changedFields.add("originId");
            return this;
        }

        public Builder originSystem(String originSystem) {
            this.originSystem = originSystem;
            this.changedFields = changedFields.add("originSystem");
            return this;
        }

        public AccessPackageResourceEnvironment build() {
            AccessPackageResourceEnvironment _x = new AccessPackageResourceEnvironment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageResourceEnvironment";
            _x.id = id;
            _x.connectionInfo = connectionInfo;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.isDefaultEnvironment = isDefaultEnvironment;
            _x.modifiedBy = modifiedBy;
            _x.modifiedDateTime = modifiedDateTime;
            _x.originId = originId;
            _x.originSystem = originSystem;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="connectionInfo")
    @JsonIgnore
    public Optional<ConnectionInfo> getConnectionInfo() {
        return Optional.ofNullable(connectionInfo);
    }

    public AccessPackageResourceEnvironment withConnectionInfo(ConnectionInfo connectionInfo) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("connectionInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.connectionInfo = connectionInfo;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessPackageResourceEnvironment withCreatedBy(String createdBy) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessPackageResourceEnvironment withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackageResourceEnvironment withDescription(String description) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackageResourceEnvironment withDisplayName(String displayName) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isDefaultEnvironment")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultEnvironment() {
        return Optional.ofNullable(isDefaultEnvironment);
    }

    public AccessPackageResourceEnvironment withIsDefaultEnvironment(Boolean isDefaultEnvironment) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("isDefaultEnvironment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.isDefaultEnvironment = isDefaultEnvironment;
        return _x;
    }

    @Property(name="modifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    public AccessPackageResourceEnvironment withModifiedBy(String modifiedBy) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("modifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public AccessPackageResourceEnvironment withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @Property(name="originId")
    @JsonIgnore
    public Optional<String> getOriginId() {
        return Optional.ofNullable(originId);
    }

    public AccessPackageResourceEnvironment withOriginId(String originId) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("originId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.originId = originId;
        return _x;
    }

    @Property(name="originSystem")
    @JsonIgnore
    public Optional<String> getOriginSystem() {
        return Optional.ofNullable(originSystem);
    }

    public AccessPackageResourceEnvironment withOriginSystem(String originSystem) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = changedFields.add("originSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceEnvironment");
        _x.originSystem = originSystem;
        return _x;
    }

    public AccessPackageResourceEnvironment withUnmappedField(String name, Object value) {
        AccessPackageResourceEnvironment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageResources")
    @JsonIgnore
    public AccessPackageResourceCollectionRequest getAccessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"), RequestHelper.getValue(unmappedFields, "accessPackageResources"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceEnvironment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceEnvironment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceEnvironment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageResourceEnvironment _copy() {
        AccessPackageResourceEnvironment _x = new AccessPackageResourceEnvironment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.connectionInfo = connectionInfo;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.isDefaultEnvironment = isDefaultEnvironment;
        _x.modifiedBy = modifiedBy;
        _x.modifiedDateTime = modifiedDateTime;
        _x.originId = originId;
        _x.originSystem = originSystem;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResourceEnvironment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("connectionInfo=");
        b.append(this.connectionInfo);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isDefaultEnvironment=");
        b.append(this.isDefaultEnvironment);
        b.append(", ");
        b.append("modifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("originId=");
        b.append(this.originId);
        b.append(", ");
        b.append("originSystem=");
        b.append(this.originSystem);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
