package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessPackageResourceAttribute;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceScopeCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceEnvironmentRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "addedBy", 
    "addedOn", 
    "attributes", 
    "description", 
    "displayName", 
    "isPendingOnboarding", 
    "originId", 
    "originSystem", 
    "resourceType", 
    "url", 
    "accessPackageResourceRoles", 
    "accessPackageResourceScopes"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResource extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResource";
    }

    @JsonProperty("addedBy")
    protected String addedBy;

    @JsonProperty("addedOn")
    protected OffsetDateTime addedOn;

    @JsonProperty("attributes")
    protected List<AccessPackageResourceAttribute> attributes;

    @JsonProperty("attributes@nextLink")
    protected String attributesNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isPendingOnboarding")
    protected Boolean isPendingOnboarding;

    @JsonProperty("originId")
    protected String originId;

    @JsonProperty("originSystem")
    protected String originSystem;

    @JsonProperty("resourceType")
    protected String resourceType;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("accessPackageResourceRoles")
    protected List<AccessPackageResourceRole> accessPackageResourceRoles;

    @JsonProperty("accessPackageResourceScopes")
    protected List<AccessPackageResourceScope> accessPackageResourceScopes;

    protected AccessPackageResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String addedBy;
        private OffsetDateTime addedOn;
        private List<AccessPackageResourceAttribute> attributes;
        private String attributesNextLink;
        private String description;
        private String displayName;
        private Boolean isPendingOnboarding;
        private String originId;
        private String originSystem;
        private String resourceType;
        private String url;
        private List<AccessPackageResourceRole> accessPackageResourceRoles;
        private List<AccessPackageResourceScope> accessPackageResourceScopes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder addedBy(String addedBy) {
            this.addedBy = addedBy;
            this.changedFields = changedFields.add("addedBy");
            return this;
        }

        public Builder addedOn(OffsetDateTime addedOn) {
            this.addedOn = addedOn;
            this.changedFields = changedFields.add("addedOn");
            return this;
        }

        public Builder attributes(List<AccessPackageResourceAttribute> attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("attributes");
            return this;
        }

        public Builder attributes(AccessPackageResourceAttribute... attributes) {
            return attributes(Arrays.asList(attributes));
        }

        public Builder attributesNextLink(String attributesNextLink) {
            this.attributesNextLink = attributesNextLink;
            this.changedFields = changedFields.add("attributes");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isPendingOnboarding(Boolean isPendingOnboarding) {
            this.isPendingOnboarding = isPendingOnboarding;
            this.changedFields = changedFields.add("isPendingOnboarding");
            return this;
        }

        public Builder originId(String originId) {
            this.originId = originId;
            this.changedFields = changedFields.add("originId");
            return this;
        }

        public Builder originSystem(String originSystem) {
            this.originSystem = originSystem;
            this.changedFields = changedFields.add("originSystem");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.changedFields = changedFields.add("resourceType");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder accessPackageResourceRoles(List<AccessPackageResourceRole> accessPackageResourceRoles) {
            this.accessPackageResourceRoles = accessPackageResourceRoles;
            this.changedFields = changedFields.add("accessPackageResourceRoles");
            return this;
        }

        public Builder accessPackageResourceRoles(AccessPackageResourceRole... accessPackageResourceRoles) {
            return accessPackageResourceRoles(Arrays.asList(accessPackageResourceRoles));
        }

        public Builder accessPackageResourceScopes(List<AccessPackageResourceScope> accessPackageResourceScopes) {
            this.accessPackageResourceScopes = accessPackageResourceScopes;
            this.changedFields = changedFields.add("accessPackageResourceScopes");
            return this;
        }

        public Builder accessPackageResourceScopes(AccessPackageResourceScope... accessPackageResourceScopes) {
            return accessPackageResourceScopes(Arrays.asList(accessPackageResourceScopes));
        }

        public AccessPackageResource build() {
            AccessPackageResource _x = new AccessPackageResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageResource";
            _x.id = id;
            _x.addedBy = addedBy;
            _x.addedOn = addedOn;
            _x.attributes = attributes;
            _x.attributesNextLink = attributesNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.isPendingOnboarding = isPendingOnboarding;
            _x.originId = originId;
            _x.originSystem = originSystem;
            _x.resourceType = resourceType;
            _x.url = url;
            _x.accessPackageResourceRoles = accessPackageResourceRoles;
            _x.accessPackageResourceScopes = accessPackageResourceScopes;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="addedBy")
    @JsonIgnore
    public Optional<String> getAddedBy() {
        return Optional.ofNullable(addedBy);
    }

    public AccessPackageResource withAddedBy(String addedBy) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("addedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.addedBy = addedBy;
        return _x;
    }

    @Property(name="addedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getAddedOn() {
        return Optional.ofNullable(addedOn);
    }

    public AccessPackageResource withAddedOn(OffsetDateTime addedOn) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("addedOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.addedOn = addedOn;
        return _x;
    }

    @Property(name="attributes")
    @JsonIgnore
    public CollectionPage<AccessPackageResourceAttribute> getAttributes() {
        return new CollectionPage<AccessPackageResourceAttribute>(contextPath, AccessPackageResourceAttribute.class, this.attributes, Optional.ofNullable(attributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AccessPackageResource withAttributes(List<AccessPackageResourceAttribute> attributes) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("attributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.attributes = attributes;
        return _x;
    }

    @Property(name="attributes")
    @JsonIgnore
    public CollectionPage<AccessPackageResourceAttribute> getAttributes(HttpRequestOptions options) {
        return new CollectionPage<AccessPackageResourceAttribute>(contextPath, AccessPackageResourceAttribute.class, this.attributes, Optional.ofNullable(attributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackageResource withDescription(String description) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackageResource withDisplayName(String displayName) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isPendingOnboarding")
    @JsonIgnore
    public Optional<Boolean> getIsPendingOnboarding() {
        return Optional.ofNullable(isPendingOnboarding);
    }

    public AccessPackageResource withIsPendingOnboarding(Boolean isPendingOnboarding) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("isPendingOnboarding");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.isPendingOnboarding = isPendingOnboarding;
        return _x;
    }

    @Property(name="originId")
    @JsonIgnore
    public Optional<String> getOriginId() {
        return Optional.ofNullable(originId);
    }

    public AccessPackageResource withOriginId(String originId) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("originId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.originId = originId;
        return _x;
    }

    @Property(name="originSystem")
    @JsonIgnore
    public Optional<String> getOriginSystem() {
        return Optional.ofNullable(originSystem);
    }

    public AccessPackageResource withOriginSystem(String originSystem) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("originSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.originSystem = originSystem;
        return _x;
    }

    @Property(name="resourceType")
    @JsonIgnore
    public Optional<String> getResourceType() {
        return Optional.ofNullable(resourceType);
    }

    public AccessPackageResource withResourceType(String resourceType) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("resourceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.resourceType = resourceType;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public AccessPackageResource withUrl(String url) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.url = url;
        return _x;
    }

    public AccessPackageResource withUnmappedField(String name, Object value) {
        AccessPackageResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageResourceEnvironment")
    @JsonIgnore
    public AccessPackageResourceEnvironmentRequest getAccessPackageResourceEnvironment() {
        return new AccessPackageResourceEnvironmentRequest(contextPath.addSegment("accessPackageResourceEnvironment"), RequestHelper.getValue(unmappedFields, "accessPackageResourceEnvironment"));
    }

    @NavigationProperty(name="accessPackageResourceRoles")
    @JsonIgnore
    public AccessPackageResourceRoleCollectionRequest getAccessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoles"), Optional.ofNullable(accessPackageResourceRoles));
    }

    @NavigationProperty(name="accessPackageResourceScopes")
    @JsonIgnore
    public AccessPackageResourceScopeCollectionRequest getAccessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceScopes"), Optional.ofNullable(accessPackageResourceScopes));
    }

    public AccessPackageResource withAccessPackageResourceRoles(List<AccessPackageResourceRole> accessPackageResourceRoles) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceRoles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.accessPackageResourceRoles = accessPackageResourceRoles;
        return _x;
    }

    public AccessPackageResource withAccessPackageResourceScopes(List<AccessPackageResourceScope> accessPackageResourceScopes) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.accessPackageResourceScopes = accessPackageResourceScopes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageResource _copy() {
        AccessPackageResource _x = new AccessPackageResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.addedBy = addedBy;
        _x.addedOn = addedOn;
        _x.attributes = attributes;
        _x.description = description;
        _x.displayName = displayName;
        _x.isPendingOnboarding = isPendingOnboarding;
        _x.originId = originId;
        _x.originSystem = originSystem;
        _x.resourceType = resourceType;
        _x.url = url;
        _x.accessPackageResourceRoles = accessPackageResourceRoles;
        _x.accessPackageResourceScopes = accessPackageResourceScopes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("addedBy=");
        b.append(this.addedBy);
        b.append(", ");
        b.append("addedOn=");
        b.append(this.addedOn);
        b.append(", ");
        b.append("attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isPendingOnboarding=");
        b.append(this.isPendingOnboarding);
        b.append(", ");
        b.append("originId=");
        b.append(this.originId);
        b.append(", ");
        b.append("originSystem=");
        b.append(this.originSystem);
        b.append(", ");
        b.append("resourceType=");
        b.append(this.resourceType);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("accessPackageResourceRoles=");
        b.append(this.accessPackageResourceRoles);
        b.append(", ");
        b.append("accessPackageResourceScopes=");
        b.append(this.accessPackageResourceScopes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
