package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomAccessPackageWorkflowExtensionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "catalogStatus", 
    "catalogType", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "isExternallyVisible", 
    "modifiedBy", 
    "modifiedDateTime", 
    "accessPackageResourceRoles", 
    "accessPackageResources", 
    "accessPackageResourceScopes", 
    "accessPackages", 
    "customAccessPackageWorkflowExtensions"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageCatalog extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageCatalog";
    }

    @JsonProperty("catalogStatus")
    protected String catalogStatus;

    @JsonProperty("catalogType")
    protected String catalogType;

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isExternallyVisible")
    protected Boolean isExternallyVisible;

    @JsonProperty("modifiedBy")
    protected String modifiedBy;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("accessPackageResourceRoles")
    protected List<AccessPackageResourceRole> accessPackageResourceRoles;

    @JsonProperty("accessPackageResources")
    protected List<AccessPackageResource> accessPackageResources;

    @JsonProperty("accessPackageResourceScopes")
    protected List<AccessPackageResourceScope> accessPackageResourceScopes;

    @JsonProperty("accessPackages")
    protected List<AccessPackage> accessPackages;

    @JsonProperty("customAccessPackageWorkflowExtensions")
    protected List<CustomAccessPackageWorkflowExtension> customAccessPackageWorkflowExtensions;

    protected AccessPackageCatalog() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageCatalog() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String catalogStatus;
        private String catalogType;
        private String createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Boolean isExternallyVisible;
        private String modifiedBy;
        private OffsetDateTime modifiedDateTime;
        private List<AccessPackageResourceRole> accessPackageResourceRoles;
        private List<AccessPackageResource> accessPackageResources;
        private List<AccessPackageResourceScope> accessPackageResourceScopes;
        private List<AccessPackage> accessPackages;
        private List<CustomAccessPackageWorkflowExtension> customAccessPackageWorkflowExtensions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder catalogStatus(String catalogStatus) {
            this.catalogStatus = catalogStatus;
            this.changedFields = changedFields.add("catalogStatus");
            return this;
        }

        public Builder catalogType(String catalogType) {
            this.catalogType = catalogType;
            this.changedFields = changedFields.add("catalogType");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isExternallyVisible(Boolean isExternallyVisible) {
            this.isExternallyVisible = isExternallyVisible;
            this.changedFields = changedFields.add("isExternallyVisible");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = changedFields.add("modifiedBy");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder accessPackageResourceRoles(List<AccessPackageResourceRole> accessPackageResourceRoles) {
            this.accessPackageResourceRoles = accessPackageResourceRoles;
            this.changedFields = changedFields.add("accessPackageResourceRoles");
            return this;
        }

        public Builder accessPackageResourceRoles(AccessPackageResourceRole... accessPackageResourceRoles) {
            return accessPackageResourceRoles(Arrays.asList(accessPackageResourceRoles));
        }

        public Builder accessPackageResources(List<AccessPackageResource> accessPackageResources) {
            this.accessPackageResources = accessPackageResources;
            this.changedFields = changedFields.add("accessPackageResources");
            return this;
        }

        public Builder accessPackageResources(AccessPackageResource... accessPackageResources) {
            return accessPackageResources(Arrays.asList(accessPackageResources));
        }

        public Builder accessPackageResourceScopes(List<AccessPackageResourceScope> accessPackageResourceScopes) {
            this.accessPackageResourceScopes = accessPackageResourceScopes;
            this.changedFields = changedFields.add("accessPackageResourceScopes");
            return this;
        }

        public Builder accessPackageResourceScopes(AccessPackageResourceScope... accessPackageResourceScopes) {
            return accessPackageResourceScopes(Arrays.asList(accessPackageResourceScopes));
        }

        public Builder accessPackages(List<AccessPackage> accessPackages) {
            this.accessPackages = accessPackages;
            this.changedFields = changedFields.add("accessPackages");
            return this;
        }

        public Builder accessPackages(AccessPackage... accessPackages) {
            return accessPackages(Arrays.asList(accessPackages));
        }

        public Builder customAccessPackageWorkflowExtensions(List<CustomAccessPackageWorkflowExtension> customAccessPackageWorkflowExtensions) {
            this.customAccessPackageWorkflowExtensions = customAccessPackageWorkflowExtensions;
            this.changedFields = changedFields.add("customAccessPackageWorkflowExtensions");
            return this;
        }

        public Builder customAccessPackageWorkflowExtensions(CustomAccessPackageWorkflowExtension... customAccessPackageWorkflowExtensions) {
            return customAccessPackageWorkflowExtensions(Arrays.asList(customAccessPackageWorkflowExtensions));
        }

        public AccessPackageCatalog build() {
            AccessPackageCatalog _x = new AccessPackageCatalog();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageCatalog";
            _x.id = id;
            _x.catalogStatus = catalogStatus;
            _x.catalogType = catalogType;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.isExternallyVisible = isExternallyVisible;
            _x.modifiedBy = modifiedBy;
            _x.modifiedDateTime = modifiedDateTime;
            _x.accessPackageResourceRoles = accessPackageResourceRoles;
            _x.accessPackageResources = accessPackageResources;
            _x.accessPackageResourceScopes = accessPackageResourceScopes;
            _x.accessPackages = accessPackages;
            _x.customAccessPackageWorkflowExtensions = customAccessPackageWorkflowExtensions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="catalogStatus")
    @JsonIgnore
    public Optional<String> getCatalogStatus() {
        return Optional.ofNullable(catalogStatus);
    }

    public AccessPackageCatalog withCatalogStatus(String catalogStatus) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("catalogStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.catalogStatus = catalogStatus;
        return _x;
    }

    @Property(name="catalogType")
    @JsonIgnore
    public Optional<String> getCatalogType() {
        return Optional.ofNullable(catalogType);
    }

    public AccessPackageCatalog withCatalogType(String catalogType) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("catalogType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.catalogType = catalogType;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessPackageCatalog withCreatedBy(String createdBy) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessPackageCatalog withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackageCatalog withDescription(String description) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackageCatalog withDisplayName(String displayName) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isExternallyVisible")
    @JsonIgnore
    public Optional<Boolean> getIsExternallyVisible() {
        return Optional.ofNullable(isExternallyVisible);
    }

    public AccessPackageCatalog withIsExternallyVisible(Boolean isExternallyVisible) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("isExternallyVisible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.isExternallyVisible = isExternallyVisible;
        return _x;
    }

    @Property(name="modifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    public AccessPackageCatalog withModifiedBy(String modifiedBy) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("modifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public AccessPackageCatalog withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    public AccessPackageCatalog withUnmappedField(String name, Object value) {
        AccessPackageCatalog _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageResourceRoles")
    @JsonIgnore
    public AccessPackageResourceRoleCollectionRequest getAccessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoles"), Optional.ofNullable(accessPackageResourceRoles));
    }

    @NavigationProperty(name="accessPackageResources")
    @JsonIgnore
    public AccessPackageResourceCollectionRequest getAccessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"), Optional.ofNullable(accessPackageResources));
    }

    @NavigationProperty(name="accessPackageResourceScopes")
    @JsonIgnore
    public AccessPackageResourceScopeCollectionRequest getAccessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceScopes"), Optional.ofNullable(accessPackageResourceScopes));
    }

    @NavigationProperty(name="accessPackages")
    @JsonIgnore
    public AccessPackageCollectionRequest getAccessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackages"), Optional.ofNullable(accessPackages));
    }

    @NavigationProperty(name="customAccessPackageWorkflowExtensions")
    @JsonIgnore
    public CustomAccessPackageWorkflowExtensionCollectionRequest getCustomAccessPackageWorkflowExtensions() {
        return new CustomAccessPackageWorkflowExtensionCollectionRequest(
                        contextPath.addSegment("customAccessPackageWorkflowExtensions"), Optional.ofNullable(customAccessPackageWorkflowExtensions));
    }

    public AccessPackageCatalog withAccessPackageResourceRoles(List<AccessPackageResourceRole> accessPackageResourceRoles) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceRoles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.accessPackageResourceRoles = accessPackageResourceRoles;
        return _x;
    }

    public AccessPackageCatalog withAccessPackageResources(List<AccessPackageResource> accessPackageResources) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.accessPackageResources = accessPackageResources;
        return _x;
    }

    public AccessPackageCatalog withAccessPackageResourceScopes(List<AccessPackageResourceScope> accessPackageResourceScopes) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.accessPackageResourceScopes = accessPackageResourceScopes;
        return _x;
    }

    public AccessPackageCatalog withAccessPackages(List<AccessPackage> accessPackages) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("accessPackages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.accessPackages = accessPackages;
        return _x;
    }

    public AccessPackageCatalog withCustomAccessPackageWorkflowExtensions(List<CustomAccessPackageWorkflowExtension> customAccessPackageWorkflowExtensions) {
        AccessPackageCatalog _x = _copy();
        _x.changedFields = changedFields.add("customAccessPackageWorkflowExtensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageCatalog");
        _x.customAccessPackageWorkflowExtensions = customAccessPackageWorkflowExtensions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageCatalog patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageCatalog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageCatalog put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageCatalog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageCatalog _copy() {
        AccessPackageCatalog _x = new AccessPackageCatalog();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.catalogStatus = catalogStatus;
        _x.catalogType = catalogType;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.isExternallyVisible = isExternallyVisible;
        _x.modifiedBy = modifiedBy;
        _x.modifiedDateTime = modifiedDateTime;
        _x.accessPackageResourceRoles = accessPackageResourceRoles;
        _x.accessPackageResources = accessPackageResources;
        _x.accessPackageResourceScopes = accessPackageResourceScopes;
        _x.accessPackages = accessPackages;
        _x.customAccessPackageWorkflowExtensions = customAccessPackageWorkflowExtensions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageCatalog[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("catalogStatus=");
        b.append(this.catalogStatus);
        b.append(", ");
        b.append("catalogType=");
        b.append(this.catalogType);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isExternallyVisible=");
        b.append(this.isExternallyVisible);
        b.append(", ");
        b.append("modifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("accessPackageResourceRoles=");
        b.append(this.accessPackageResourceRoles);
        b.append(", ");
        b.append("accessPackageResources=");
        b.append(this.accessPackageResources);
        b.append(", ");
        b.append("accessPackageResourceScopes=");
        b.append(this.accessPackageResourceScopes);
        b.append(", ");
        b.append("accessPackages=");
        b.append(this.accessPackages);
        b.append(", ");
        b.append("customAccessPackageWorkflowExtensions=");
        b.append(this.customAccessPackageWorkflowExtensions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
