package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessPackageAssignmentRequestRequirements;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageCatalogRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "catalogId", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "isHidden", 
    "isRoleScopesVisible", 
    "modifiedBy", 
    "modifiedDateTime", 
    "accessPackageAssignmentPolicies", 
    "accessPackageResourceRoleScopes", 
    "incompatibleGroups"})
@JsonInclude(Include.NON_NULL)
public class AccessPackage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackage";
    }

    @JsonProperty("catalogId")
    protected String catalogId;

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isHidden")
    protected Boolean isHidden;

    @JsonProperty("isRoleScopesVisible")
    protected Boolean isRoleScopesVisible;

    @JsonProperty("modifiedBy")
    protected String modifiedBy;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("accessPackageAssignmentPolicies")
    protected List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies;

    @JsonProperty("accessPackageResourceRoleScopes")
    protected List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes;

    @JsonProperty("incompatibleGroups")
    protected List<Group> incompatibleGroups;

    protected AccessPackage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String catalogId;
        private String createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Boolean isHidden;
        private Boolean isRoleScopesVisible;
        private String modifiedBy;
        private OffsetDateTime modifiedDateTime;
        private List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies;
        private List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes;
        private List<Group> incompatibleGroups;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            this.changedFields = changedFields.add("catalogId");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.changedFields = changedFields.add("isHidden");
            return this;
        }

        public Builder isRoleScopesVisible(Boolean isRoleScopesVisible) {
            this.isRoleScopesVisible = isRoleScopesVisible;
            this.changedFields = changedFields.add("isRoleScopesVisible");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = changedFields.add("modifiedBy");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder accessPackageAssignmentPolicies(List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies) {
            this.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
            this.changedFields = changedFields.add("accessPackageAssignmentPolicies");
            return this;
        }

        public Builder accessPackageAssignmentPolicies(AccessPackageAssignmentPolicy... accessPackageAssignmentPolicies) {
            return accessPackageAssignmentPolicies(Arrays.asList(accessPackageAssignmentPolicies));
        }

        public Builder accessPackageResourceRoleScopes(List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes) {
            this.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
            this.changedFields = changedFields.add("accessPackageResourceRoleScopes");
            return this;
        }

        public Builder accessPackageResourceRoleScopes(AccessPackageResourceRoleScope... accessPackageResourceRoleScopes) {
            return accessPackageResourceRoleScopes(Arrays.asList(accessPackageResourceRoleScopes));
        }

        public Builder incompatibleGroups(List<Group> incompatibleGroups) {
            this.incompatibleGroups = incompatibleGroups;
            this.changedFields = changedFields.add("incompatibleGroups");
            return this;
        }

        public Builder incompatibleGroups(Group... incompatibleGroups) {
            return incompatibleGroups(Arrays.asList(incompatibleGroups));
        }

        public AccessPackage build() {
            AccessPackage _x = new AccessPackage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackage";
            _x.id = id;
            _x.catalogId = catalogId;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.isHidden = isHidden;
            _x.isRoleScopesVisible = isRoleScopesVisible;
            _x.modifiedBy = modifiedBy;
            _x.modifiedDateTime = modifiedDateTime;
            _x.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
            _x.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
            _x.incompatibleGroups = incompatibleGroups;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="catalogId")
    @JsonIgnore
    public Optional<String> getCatalogId() {
        return Optional.ofNullable(catalogId);
    }

    public AccessPackage withCatalogId(String catalogId) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("catalogId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.catalogId = catalogId;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessPackage withCreatedBy(String createdBy) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessPackage withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackage withDescription(String description) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackage withDisplayName(String displayName) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isHidden")
    @JsonIgnore
    public Optional<Boolean> getIsHidden() {
        return Optional.ofNullable(isHidden);
    }

    public AccessPackage withIsHidden(Boolean isHidden) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("isHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.isHidden = isHidden;
        return _x;
    }

    @Property(name="isRoleScopesVisible")
    @JsonIgnore
    public Optional<Boolean> getIsRoleScopesVisible() {
        return Optional.ofNullable(isRoleScopesVisible);
    }

    public AccessPackage withIsRoleScopesVisible(Boolean isRoleScopesVisible) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("isRoleScopesVisible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.isRoleScopesVisible = isRoleScopesVisible;
        return _x;
    }

    @Property(name="modifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    public AccessPackage withModifiedBy(String modifiedBy) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("modifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public AccessPackage withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    public AccessPackage withUnmappedField(String name, Object value) {
        AccessPackage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageAssignmentPolicies")
    @JsonIgnore
    public AccessPackageAssignmentPolicyCollectionRequest getAccessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentPolicies"), Optional.ofNullable(accessPackageAssignmentPolicies));
    }

    @NavigationProperty(name="accessPackageCatalog")
    @JsonIgnore
    public AccessPackageCatalogRequest getAccessPackageCatalog() {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalog"), RequestHelper.getValue(unmappedFields, "accessPackageCatalog"));
    }

    @NavigationProperty(name="accessPackageResourceRoleScopes")
    @JsonIgnore
    public AccessPackageResourceRoleScopeCollectionRequest getAccessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoleScopes"), Optional.ofNullable(accessPackageResourceRoleScopes));
    }

    @NavigationProperty(name="accessPackagesIncompatibleWith")
    @JsonIgnore
    public AccessPackageCollectionRequest getAccessPackagesIncompatibleWith() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackagesIncompatibleWith"), RequestHelper.getValue(unmappedFields, "accessPackagesIncompatibleWith"));
    }

    @NavigationProperty(name="incompatibleAccessPackages")
    @JsonIgnore
    public AccessPackageCollectionRequest getIncompatibleAccessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("incompatibleAccessPackages"), RequestHelper.getValue(unmappedFields, "incompatibleAccessPackages"));
    }

    @NavigationProperty(name="incompatibleGroups")
    @JsonIgnore
    public GroupCollectionRequest getIncompatibleGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("incompatibleGroups"), Optional.ofNullable(incompatibleGroups));
    }

    public AccessPackage withAccessPackageAssignmentPolicies(List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("accessPackageAssignmentPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
        return _x;
    }

    public AccessPackage withAccessPackageResourceRoleScopes(List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceRoleScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
        return _x;
    }

    public AccessPackage withIncompatibleGroups(List<Group> incompatibleGroups) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("incompatibleGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.incompatibleGroups = incompatibleGroups;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackage _copy() {
        AccessPackage _x = new AccessPackage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.catalogId = catalogId;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.isHidden = isHidden;
        _x.isRoleScopesVisible = isRoleScopesVisible;
        _x.modifiedBy = modifiedBy;
        _x.modifiedDateTime = modifiedDateTime;
        _x.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
        _x.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
        _x.incompatibleGroups = incompatibleGroups;
        return _x;
    }

    @Action(name = "getApplicablePolicyRequirements")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageAssignmentRequestRequirements> getApplicablePolicyRequirements() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getApplicablePolicyRequirements"), AccessPackageAssignmentRequestRequirements.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("catalogId=");
        b.append(this.catalogId);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isHidden=");
        b.append(this.isHidden);
        b.append(", ");
        b.append("isRoleScopesVisible=");
        b.append(this.isRoleScopesVisible);
        b.append(", ");
        b.append("modifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("accessPackageAssignmentPolicies=");
        b.append(this.accessPackageAssignmentPolicies);
        b.append(", ");
        b.append("accessPackageResourceRoleScopes=");
        b.append(this.accessPackageResourceRoleScopes);
        b.append(", ");
        b.append("incompatibleGroups=");
        b.append(this.incompatibleGroups);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
