package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SourceType implements Enum {

    @JsonProperty("mailbox")
    MAILBOX("mailbox", "1"),

    @JsonProperty("site")
    SITE("site", "2");

    private final String name;
    private final String value;

    private SourceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
