package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CaseOperationStatus implements Enum {

    @JsonProperty("notStarted")
    NOT_STARTED("notStarted", "0"),

    @JsonProperty("submissionFailed")
    SUBMISSION_FAILED("submissionFailed", "1"),

    @JsonProperty("running")
    RUNNING("running", "2"),

    @JsonProperty("succeeded")
    SUCCEEDED("succeeded", "3"),

    @JsonProperty("partiallySucceeded")
    PARTIALLY_SUCCEEDED("partiallySucceeded", "4"),

    @JsonProperty("failed")
    FAILED("failed", "5");

    private final String name;
    private final String value;

    private CaseOperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
