package odata.msgraph.client.beta.ediscovery.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CaseAction implements Enum {

    @JsonProperty("contentExport")
    CONTENT_EXPORT("contentExport", "0"),

    @JsonProperty("applyTags")
    APPLY_TAGS("applyTags", "1"),

    @JsonProperty("convertToPdf")
    CONVERT_TO_PDF("convertToPdf", "2"),

    @JsonProperty("index")
    INDEX("index", "3"),

    @JsonProperty("estimateStatistics")
    ESTIMATE_STATISTICS("estimateStatistics", "4"),

    @JsonProperty("addToReviewSet")
    ADD_TO_REVIEW_SET("addToReviewSet", "5"),

    @JsonProperty("holdUpdate")
    HOLD_UPDATE("holdUpdate", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7"),

    @JsonProperty("purgeData")
    PURGE_DATA("purgeData", "8");

    private final String name;
    private final String value;

    private CaseAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
