package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.SourceCollection;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.DataSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.NoncustodialDataSourceCollectionRequest;

@JsonIgnoreType
public class SourceCollectionRequest extends EntityRequest<SourceCollection> {

    public SourceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(SourceCollection.class, contextPath, value, false);
    }

    public DataSourceRequest additionalSources(String id) {
        return new DataSourceRequest(contextPath.addSegment("additionalSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DataSourceCollectionRequest additionalSources() {
        return new DataSourceCollectionRequest(
                        contextPath.addSegment("additionalSources"), Optional.empty());
    }

    public AddToReviewSetOperationRequest addToReviewSetOperation() {
        return new AddToReviewSetOperationRequest(contextPath.addSegment("addToReviewSetOperation"), Optional.empty());
    }

    public DataSourceRequest custodianSources(String id) {
        return new DataSourceRequest(contextPath.addSegment("custodianSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DataSourceCollectionRequest custodianSources() {
        return new DataSourceCollectionRequest(
                        contextPath.addSegment("custodianSources"), Optional.empty());
    }

    public EstimateStatisticsOperationRequest lastEstimateStatisticsOperation() {
        return new EstimateStatisticsOperationRequest(contextPath.addSegment("lastEstimateStatisticsOperation"), Optional.empty());
    }

    public NoncustodialDataSourceRequest noncustodialSources(String id) {
        return new NoncustodialDataSourceRequest(contextPath.addSegment("noncustodialSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NoncustodialDataSourceCollectionRequest noncustodialSources() {
        return new NoncustodialDataSourceCollectionRequest(
                        contextPath.addSegment("noncustodialSources"), Optional.empty());
    }

    @Action(name = "estimateStatistics")
    @JsonIgnore
    public ActionRequestNoReturn estimateStatistics() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.estimateStatistics"), _parameters);
    }

    @Action(name = "purgeData")
    @JsonIgnore
    public ActionRequestNoReturn purgeData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.purgeData"), _parameters);
    }

}
