package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.SiteSource;
import odata.msgraph.client.beta.entity.request.SiteRequest;

@JsonIgnoreType
public class SiteSourceRequest extends EntityRequest<SiteSource> {

    public SiteSourceRequest(ContextPath contextPath, Optional<Object> value) {
        super(SiteSource.class, contextPath, value, false);
    }

    public SiteRequest site() {
        return new SiteRequest(contextPath.addSegment("site"), Optional.empty());
    }

}
