package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.ReviewSetQuery;
import odata.msgraph.client.beta.ediscovery.entity.Tag;

@JsonIgnoreType
public class ReviewSetQueryRequest extends EntityRequest<ReviewSetQuery> {

    public ReviewSetQueryRequest(ContextPath contextPath, Optional<Object> value) {
        super(ReviewSetQuery.class, contextPath, value, false);
    }

    @Action(name = "applyTags")
    @JsonIgnore
    public ActionRequestNoReturn applyTags(List<Tag> tagsToAdd, List<Tag> tagsToRemove) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tagsToAdd", "Collection(microsoft.graph.ediscovery.tag)", tagsToAdd)
            .put("tagsToRemove", "Collection(microsoft.graph.ediscovery.tag)", tagsToRemove)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.applyTags"), _parameters);
    }

}
