package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.NoncustodialDataSource;

@JsonIgnoreType
public class NoncustodialDataSourceRequest extends EntityRequest<NoncustodialDataSource> {

    public NoncustodialDataSourceRequest(ContextPath contextPath, Optional<Object> value) {
        super(NoncustodialDataSource.class, contextPath, value, false);
    }

    public DataSourceRequest dataSource() {
        return new DataSourceRequest(contextPath.addSegment("dataSource"), Optional.empty());
    }

    @Action(name = "applyHold")
    @JsonIgnore
    public ActionRequestNoReturn applyHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.applyHold"), _parameters);
    }

    @Action(name = "release")
    @JsonIgnore
    public ActionRequestNoReturn release() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.release"), _parameters);
    }

    @Action(name = "removeHold")
    @JsonIgnore
    public ActionRequestNoReturn removeHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.removeHold"), _parameters);
    }

    @Action(name = "updateIndex")
    @JsonIgnore
    public ActionRequestNoReturn updateIndex() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.updateIndex"), _parameters);
    }

}
