package odata.msgraph.client.beta.ediscovery.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.CaseExportOperation;

@JsonIgnoreType
public class CaseExportOperationRequest extends EntityRequest<CaseExportOperation> {

    public CaseExportOperationRequest(ContextPath contextPath, Optional<Object> value) {
        super(CaseExportOperation.class, contextPath, value, false);
    }

    public ReviewSetRequest reviewSet() {
        return new ReviewSetRequest(contextPath.addSegment("reviewSet"), Optional.empty());
    }

    @Function(name = "getDownloadUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getDownloadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.getDownloadUrl"), String.class, _parameters);
    }

}
