package odata.msgraph.client.beta.ediscovery.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.SourceCollection;
import odata.msgraph.client.beta.ediscovery.entity.request.DataSourceRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.NoncustodialDataSourceRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.SourceCollectionRequest;

public class SourceCollectionCollectionRequest extends CollectionPageEntityRequest<SourceCollection, SourceCollectionRequest>{

    protected ContextPath contextPath;

    public SourceCollectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SourceCollection.class, cp -> new SourceCollectionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DataSourceRequest additionalSources(String id) {
        return new DataSourceRequest(contextPath.addSegment("additionalSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DataSourceCollectionRequest additionalSources() {
        return new DataSourceCollectionRequest(contextPath.addSegment("additionalSources"), Optional.empty());
    }

    public DataSourceRequest custodianSources(String id) {
        return new DataSourceRequest(contextPath.addSegment("custodianSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DataSourceCollectionRequest custodianSources() {
        return new DataSourceCollectionRequest(contextPath.addSegment("custodianSources"), Optional.empty());
    }

    public NoncustodialDataSourceRequest noncustodialSources(String id) {
        return new NoncustodialDataSourceRequest(contextPath.addSegment("noncustodialSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NoncustodialDataSourceCollectionRequest noncustodialSources() {
        return new NoncustodialDataSourceCollectionRequest(contextPath.addSegment("noncustodialSources"), Optional.empty());
    }

}
