package odata.msgraph.client.beta.ediscovery.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.NoncustodialDataSource;
import odata.msgraph.client.beta.ediscovery.entity.request.NoncustodialDataSourceRequest;

public class NoncustodialDataSourceCollectionRequest extends CollectionPageEntityRequest<NoncustodialDataSource, NoncustodialDataSourceRequest>{

    protected ContextPath contextPath;

    public NoncustodialDataSourceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, NoncustodialDataSource.class, cp -> new NoncustodialDataSourceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "applyHold")
    @JsonIgnore
    public ActionRequestNoReturn applyHold(List<String> ids) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.applyHold"), _parameters);
    }

    @Action(name = "removeHold")
    @JsonIgnore
    public ActionRequestNoReturn removeHold(List<String> ids) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.removeHold"), _parameters);
    }

}
