package odata.msgraph.client.beta.ediscovery.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.Case;
import odata.msgraph.client.beta.ediscovery.entity.request.CaseOperationRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.CaseRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.CustodianRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.LegalHoldRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.NoncustodialDataSourceRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.ReviewSetRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.SourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.request.TagRequest;

public class CaseCollectionRequest extends CollectionPageEntityRequest<Case, CaseRequest>{

    protected ContextPath contextPath;

    public CaseCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Case.class, cp -> new CaseRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CustodianRequest custodians(String id) {
        return new CustodianRequest(contextPath.addSegment("custodians").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustodianCollectionRequest custodians() {
        return new CustodianCollectionRequest(contextPath.addSegment("custodians"), Optional.empty());
    }

    public LegalHoldRequest legalHolds(String id) {
        return new LegalHoldRequest(contextPath.addSegment("legalHolds").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LegalHoldCollectionRequest legalHolds() {
        return new LegalHoldCollectionRequest(contextPath.addSegment("legalHolds"), Optional.empty());
    }

    public NoncustodialDataSourceRequest noncustodialDataSources(String id) {
        return new NoncustodialDataSourceRequest(contextPath.addSegment("noncustodialDataSources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NoncustodialDataSourceCollectionRequest noncustodialDataSources() {
        return new NoncustodialDataSourceCollectionRequest(contextPath.addSegment("noncustodialDataSources"), Optional.empty());
    }

    public CaseOperationRequest operations(String id) {
        return new CaseOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CaseOperationCollectionRequest operations() {
        return new CaseOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    public ReviewSetRequest reviewSets(String id) {
        return new ReviewSetRequest(contextPath.addSegment("reviewSets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ReviewSetCollectionRequest reviewSets() {
        return new ReviewSetCollectionRequest(contextPath.addSegment("reviewSets"), Optional.empty());
    }

    public SourceCollectionRequest sourceCollections(String id) {
        return new SourceCollectionRequest(contextPath.addSegment("sourceCollections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SourceCollectionCollectionRequest sourceCollections() {
        return new SourceCollectionCollectionRequest(contextPath.addSegment("sourceCollections"), Optional.empty());
    }

    public TagRequest tags(String id) {
        return new TagRequest(contextPath.addSegment("tags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TagCollectionRequest tags() {
        return new TagCollectionRequest(contextPath.addSegment("tags"), Optional.empty());
    }

}
