package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.request.DataSourceRequest;
import odata.msgraph.client.beta.ediscovery.enums.DataSourceContainerStatus;
import odata.msgraph.client.beta.ediscovery.enums.DataSourceHoldStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "applyHoldToSource", 
    "dataSource"})
@JsonInclude(Include.NON_NULL)
public class NoncustodialDataSource extends DataSourceContainer implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.noncustodialDataSource";
    }

    @JsonProperty("applyHoldToSource")
    protected Boolean applyHoldToSource;

    @JsonProperty("dataSource")
    protected DataSource dataSource;

    protected NoncustodialDataSource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNoncustodialDataSource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private DataSourceHoldStatus holdStatus;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime releasedDateTime;
        private DataSourceContainerStatus status;
        private Boolean applyHoldToSource;
        private DataSource dataSource;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder holdStatus(DataSourceHoldStatus holdStatus) {
            this.holdStatus = holdStatus;
            this.changedFields = changedFields.add("holdStatus");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder releasedDateTime(OffsetDateTime releasedDateTime) {
            this.releasedDateTime = releasedDateTime;
            this.changedFields = changedFields.add("releasedDateTime");
            return this;
        }

        public Builder status(DataSourceContainerStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder applyHoldToSource(Boolean applyHoldToSource) {
            this.applyHoldToSource = applyHoldToSource;
            this.changedFields = changedFields.add("applyHoldToSource");
            return this;
        }

        public Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            this.changedFields = changedFields.add("dataSource");
            return this;
        }

        public NoncustodialDataSource build() {
            NoncustodialDataSource _x = new NoncustodialDataSource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.noncustodialDataSource";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.holdStatus = holdStatus;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.releasedDateTime = releasedDateTime;
            _x.status = status;
            _x.applyHoldToSource = applyHoldToSource;
            _x.dataSource = dataSource;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="applyHoldToSource")
    @JsonIgnore
    public Optional<Boolean> getApplyHoldToSource() {
        return Optional.ofNullable(applyHoldToSource);
    }

    public NoncustodialDataSource withApplyHoldToSource(Boolean applyHoldToSource) {
        NoncustodialDataSource _x = _copy();
        _x.changedFields = changedFields.add("applyHoldToSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.noncustodialDataSource");
        _x.applyHoldToSource = applyHoldToSource;
        return _x;
    }

    public NoncustodialDataSource withUnmappedField(String name, Object value) {
        NoncustodialDataSource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="dataSource")
    @JsonIgnore
    public DataSourceRequest getDataSource() {
        return new DataSourceRequest(contextPath.addSegment("dataSource"), Optional.ofNullable(dataSource));
    }

    public NoncustodialDataSource withDataSource(DataSource dataSource) {
        NoncustodialDataSource _x = _copy();
        _x.changedFields = changedFields.add("dataSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.noncustodialDataSource");
        _x.dataSource = dataSource;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NoncustodialDataSource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        NoncustodialDataSource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NoncustodialDataSource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        NoncustodialDataSource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private NoncustodialDataSource _copy() {
        NoncustodialDataSource _x = new NoncustodialDataSource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.holdStatus = holdStatus;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.releasedDateTime = releasedDateTime;
        _x.status = status;
        _x.applyHoldToSource = applyHoldToSource;
        _x.dataSource = dataSource;
        return _x;
    }

    @Action(name = "applyHold")
    @JsonIgnore
    public ActionRequestNoReturn applyHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.applyHold"), _parameters);
    }

    @Action(name = "release")
    @JsonIgnore
    public ActionRequestNoReturn release() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.release"), _parameters);
    }

    @Action(name = "removeHold")
    @JsonIgnore
    public ActionRequestNoReturn removeHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.removeHold"), _parameters);
    }

    @Action(name = "updateIndex")
    @JsonIgnore
    public ActionRequestNoReturn updateIndex() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.updateIndex"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NoncustodialDataSource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("holdStatus=");
        b.append(this.holdStatus);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("releasedDateTime=");
        b.append(this.releasedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("applyHoldToSource=");
        b.append(this.applyHoldToSource);
        b.append(", ");
        b.append("dataSource=");
        b.append(this.dataSource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
