package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.request.CaseIndexOperationRequest;
import odata.msgraph.client.beta.ediscovery.enums.DataSourceContainerStatus;
import odata.msgraph.client.beta.ediscovery.enums.DataSourceHoldStatus;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "displayName", 
    "holdStatus", 
    "lastModifiedDateTime", 
    "releasedDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class DataSourceContainer extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.dataSourceContainer";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("holdStatus")
    protected DataSourceHoldStatus holdStatus;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("releasedDateTime")
    protected OffsetDateTime releasedDateTime;

    @JsonProperty("status")
    protected DataSourceContainerStatus status;

    protected DataSourceContainer() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public DataSourceContainer withCreatedDateTime(OffsetDateTime createdDateTime) {
        DataSourceContainer _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.dataSourceContainer");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DataSourceContainer withDisplayName(String displayName) {
        DataSourceContainer _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.dataSourceContainer");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="holdStatus")
    @JsonIgnore
    public Optional<DataSourceHoldStatus> getHoldStatus() {
        return Optional.ofNullable(holdStatus);
    }

    public DataSourceContainer withHoldStatus(DataSourceHoldStatus holdStatus) {
        DataSourceContainer _x = _copy();
        _x.changedFields = changedFields.add("holdStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.dataSourceContainer");
        _x.holdStatus = holdStatus;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public DataSourceContainer withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DataSourceContainer _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.dataSourceContainer");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="releasedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReleasedDateTime() {
        return Optional.ofNullable(releasedDateTime);
    }

    public DataSourceContainer withReleasedDateTime(OffsetDateTime releasedDateTime) {
        DataSourceContainer _x = _copy();
        _x.changedFields = changedFields.add("releasedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.dataSourceContainer");
        _x.releasedDateTime = releasedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<DataSourceContainerStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public DataSourceContainer withStatus(DataSourceContainerStatus status) {
        DataSourceContainer _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.dataSourceContainer");
        _x.status = status;
        return _x;
    }

    public DataSourceContainer withUnmappedField(String name, Object value) {
        DataSourceContainer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="lastIndexOperation")
    @JsonIgnore
    public CaseIndexOperationRequest getLastIndexOperation() {
        return new CaseIndexOperationRequest(contextPath.addSegment("lastIndexOperation"), RequestHelper.getValue(unmappedFields, "lastIndexOperation"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataSourceContainer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DataSourceContainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataSourceContainer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DataSourceContainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DataSourceContainer _copy() {
        DataSourceContainer _x = new DataSourceContainer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.holdStatus = holdStatus;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.releasedDateTime = releasedDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataSourceContainer[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("holdStatus=");
        b.append(this.holdStatus);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("releasedDateTime=");
        b.append(this.releasedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
