package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.entity.collection.request.SiteSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UnifiedGroupSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.entity.collection.request.UserSourceCollectionRequest;
import odata.msgraph.client.beta.ediscovery.enums.DataSourceContainerStatus;
import odata.msgraph.client.beta.ediscovery.enums.DataSourceHoldStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "acknowledgedDateTime", 
    "applyHoldToSources", 
    "email", 
    "siteSources", 
    "unifiedGroupSources", 
    "userSources"})
@JsonInclude(Include.NON_NULL)
public class Custodian extends DataSourceContainer implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.custodian";
    }

    @JsonProperty("acknowledgedDateTime")
    protected OffsetDateTime acknowledgedDateTime;

    @JsonProperty("applyHoldToSources")
    protected Boolean applyHoldToSources;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("siteSources")
    protected List<SiteSource> siteSources;

    @JsonProperty("unifiedGroupSources")
    protected List<UnifiedGroupSource> unifiedGroupSources;

    @JsonProperty("userSources")
    protected List<UserSource> userSources;

    protected Custodian() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustodian() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private DataSourceHoldStatus holdStatus;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime releasedDateTime;
        private DataSourceContainerStatus status;
        private OffsetDateTime acknowledgedDateTime;
        private Boolean applyHoldToSources;
        private String email;
        private List<SiteSource> siteSources;
        private List<UnifiedGroupSource> unifiedGroupSources;
        private List<UserSource> userSources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder holdStatus(DataSourceHoldStatus holdStatus) {
            this.holdStatus = holdStatus;
            this.changedFields = changedFields.add("holdStatus");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder releasedDateTime(OffsetDateTime releasedDateTime) {
            this.releasedDateTime = releasedDateTime;
            this.changedFields = changedFields.add("releasedDateTime");
            return this;
        }

        public Builder status(DataSourceContainerStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder acknowledgedDateTime(OffsetDateTime acknowledgedDateTime) {
            this.acknowledgedDateTime = acknowledgedDateTime;
            this.changedFields = changedFields.add("acknowledgedDateTime");
            return this;
        }

        public Builder applyHoldToSources(Boolean applyHoldToSources) {
            this.applyHoldToSources = applyHoldToSources;
            this.changedFields = changedFields.add("applyHoldToSources");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder siteSources(List<SiteSource> siteSources) {
            this.siteSources = siteSources;
            this.changedFields = changedFields.add("siteSources");
            return this;
        }

        public Builder siteSources(SiteSource... siteSources) {
            return siteSources(Arrays.asList(siteSources));
        }

        public Builder unifiedGroupSources(List<UnifiedGroupSource> unifiedGroupSources) {
            this.unifiedGroupSources = unifiedGroupSources;
            this.changedFields = changedFields.add("unifiedGroupSources");
            return this;
        }

        public Builder unifiedGroupSources(UnifiedGroupSource... unifiedGroupSources) {
            return unifiedGroupSources(Arrays.asList(unifiedGroupSources));
        }

        public Builder userSources(List<UserSource> userSources) {
            this.userSources = userSources;
            this.changedFields = changedFields.add("userSources");
            return this;
        }

        public Builder userSources(UserSource... userSources) {
            return userSources(Arrays.asList(userSources));
        }

        public Custodian build() {
            Custodian _x = new Custodian();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.custodian";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.holdStatus = holdStatus;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.releasedDateTime = releasedDateTime;
            _x.status = status;
            _x.acknowledgedDateTime = acknowledgedDateTime;
            _x.applyHoldToSources = applyHoldToSources;
            _x.email = email;
            _x.siteSources = siteSources;
            _x.unifiedGroupSources = unifiedGroupSources;
            _x.userSources = userSources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="acknowledgedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAcknowledgedDateTime() {
        return Optional.ofNullable(acknowledgedDateTime);
    }

    public Custodian withAcknowledgedDateTime(OffsetDateTime acknowledgedDateTime) {
        Custodian _x = _copy();
        _x.changedFields = changedFields.add("acknowledgedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.custodian");
        _x.acknowledgedDateTime = acknowledgedDateTime;
        return _x;
    }

    @Property(name="applyHoldToSources")
    @JsonIgnore
    public Optional<Boolean> getApplyHoldToSources() {
        return Optional.ofNullable(applyHoldToSources);
    }

    public Custodian withApplyHoldToSources(Boolean applyHoldToSources) {
        Custodian _x = _copy();
        _x.changedFields = changedFields.add("applyHoldToSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.custodian");
        _x.applyHoldToSources = applyHoldToSources;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public Custodian withEmail(String email) {
        Custodian _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.custodian");
        _x.email = email;
        return _x;
    }

    public Custodian withUnmappedField(String name, Object value) {
        Custodian _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="siteSources")
    @JsonIgnore
    public SiteSourceCollectionRequest getSiteSources() {
        return new SiteSourceCollectionRequest(
                        contextPath.addSegment("siteSources"), Optional.ofNullable(siteSources));
    }

    @NavigationProperty(name="unifiedGroupSources")
    @JsonIgnore
    public UnifiedGroupSourceCollectionRequest getUnifiedGroupSources() {
        return new UnifiedGroupSourceCollectionRequest(
                        contextPath.addSegment("unifiedGroupSources"), Optional.ofNullable(unifiedGroupSources));
    }

    @NavigationProperty(name="userSources")
    @JsonIgnore
    public UserSourceCollectionRequest getUserSources() {
        return new UserSourceCollectionRequest(
                        contextPath.addSegment("userSources"), Optional.ofNullable(userSources));
    }

    public Custodian withSiteSources(List<SiteSource> siteSources) {
        Custodian _x = _copy();
        _x.changedFields = changedFields.add("siteSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.custodian");
        _x.siteSources = siteSources;
        return _x;
    }

    public Custodian withUnifiedGroupSources(List<UnifiedGroupSource> unifiedGroupSources) {
        Custodian _x = _copy();
        _x.changedFields = changedFields.add("unifiedGroupSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.custodian");
        _x.unifiedGroupSources = unifiedGroupSources;
        return _x;
    }

    public Custodian withUserSources(List<UserSource> userSources) {
        Custodian _x = _copy();
        _x.changedFields = changedFields.add("userSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.custodian");
        _x.userSources = userSources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Custodian patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Custodian _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Custodian put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Custodian _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Custodian _copy() {
        Custodian _x = new Custodian();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.holdStatus = holdStatus;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.releasedDateTime = releasedDateTime;
        _x.status = status;
        _x.acknowledgedDateTime = acknowledgedDateTime;
        _x.applyHoldToSources = applyHoldToSources;
        _x.email = email;
        _x.siteSources = siteSources;
        _x.unifiedGroupSources = unifiedGroupSources;
        _x.userSources = userSources;
        return _x;
    }

    @Action(name = "activate")
    @JsonIgnore
    public ActionRequestNoReturn activate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.activate"), _parameters);
    }

    @Action(name = "applyHold")
    @JsonIgnore
    public ActionRequestNoReturn applyHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.applyHold"), _parameters);
    }

    @Action(name = "release")
    @JsonIgnore
    public ActionRequestNoReturn release() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.release"), _parameters);
    }

    @Action(name = "removeHold")
    @JsonIgnore
    public ActionRequestNoReturn removeHold() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.removeHold"), _parameters);
    }

    @Action(name = "updateIndex")
    @JsonIgnore
    public ActionRequestNoReturn updateIndex() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.updateIndex"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Custodian[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("holdStatus=");
        b.append(this.holdStatus);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("releasedDateTime=");
        b.append(this.releasedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("acknowledgedDateTime=");
        b.append(this.acknowledgedDateTime);
        b.append(", ");
        b.append("applyHoldToSources=");
        b.append(this.applyHoldToSources);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("siteSources=");
        b.append(this.siteSources);
        b.append(", ");
        b.append("unifiedGroupSources=");
        b.append(this.unifiedGroupSources);
        b.append(", ");
        b.append("userSources=");
        b.append(this.userSources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
