package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.ediscovery.complex.OcrSettings;
import odata.msgraph.client.beta.ediscovery.complex.RedundancyDetectionSettings;
import odata.msgraph.client.beta.ediscovery.complex.TopicModelingSettings;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "ocr", 
    "redundancyDetection", 
    "topicModeling"})
@JsonInclude(Include.NON_NULL)
public class CaseSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.caseSettings";
    }

    @JsonProperty("ocr")
    protected OcrSettings ocr;

    @JsonProperty("redundancyDetection")
    protected RedundancyDetectionSettings redundancyDetection;

    @JsonProperty("topicModeling")
    protected TopicModelingSettings topicModeling;

    protected CaseSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCaseSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OcrSettings ocr;
        private RedundancyDetectionSettings redundancyDetection;
        private TopicModelingSettings topicModeling;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder ocr(OcrSettings ocr) {
            this.ocr = ocr;
            this.changedFields = changedFields.add("ocr");
            return this;
        }

        public Builder redundancyDetection(RedundancyDetectionSettings redundancyDetection) {
            this.redundancyDetection = redundancyDetection;
            this.changedFields = changedFields.add("redundancyDetection");
            return this;
        }

        public Builder topicModeling(TopicModelingSettings topicModeling) {
            this.topicModeling = topicModeling;
            this.changedFields = changedFields.add("topicModeling");
            return this;
        }

        public CaseSettings build() {
            CaseSettings _x = new CaseSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.caseSettings";
            _x.id = id;
            _x.ocr = ocr;
            _x.redundancyDetection = redundancyDetection;
            _x.topicModeling = topicModeling;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="ocr")
    @JsonIgnore
    public Optional<OcrSettings> getOcr() {
        return Optional.ofNullable(ocr);
    }

    public CaseSettings withOcr(OcrSettings ocr) {
        CaseSettings _x = _copy();
        _x.changedFields = changedFields.add("ocr");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseSettings");
        _x.ocr = ocr;
        return _x;
    }

    @Property(name="redundancyDetection")
    @JsonIgnore
    public Optional<RedundancyDetectionSettings> getRedundancyDetection() {
        return Optional.ofNullable(redundancyDetection);
    }

    public CaseSettings withRedundancyDetection(RedundancyDetectionSettings redundancyDetection) {
        CaseSettings _x = _copy();
        _x.changedFields = changedFields.add("redundancyDetection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseSettings");
        _x.redundancyDetection = redundancyDetection;
        return _x;
    }

    @Property(name="topicModeling")
    @JsonIgnore
    public Optional<TopicModelingSettings> getTopicModeling() {
        return Optional.ofNullable(topicModeling);
    }

    public CaseSettings withTopicModeling(TopicModelingSettings topicModeling) {
        CaseSettings _x = _copy();
        _x.changedFields = changedFields.add("topicModeling");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseSettings");
        _x.topicModeling = topicModeling;
        return _x;
    }

    public CaseSettings withUnmappedField(String name, Object value) {
        CaseSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CaseSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CaseSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CaseSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CaseSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CaseSettings _copy() {
        CaseSettings _x = new CaseSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.ocr = ocr;
        _x.redundancyDetection = redundancyDetection;
        _x.topicModeling = topicModeling;
        return _x;
    }

    @Action(name = "resetToDefault")
    @JsonIgnore
    public ActionRequestNoReturn resetToDefault() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.ediscovery.resetToDefault"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CaseSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("ocr=");
        b.append(this.ocr);
        b.append(", ");
        b.append("redundancyDetection=");
        b.append(this.redundancyDetection);
        b.append(", ");
        b.append("topicModeling=");
        b.append(this.topicModeling);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
