package odata.msgraph.client.beta.ediscovery.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.ediscovery.enums.CaseAction;
import odata.msgraph.client.beta.ediscovery.enums.CaseOperationStatus;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "completedDateTime", 
    "createdBy", 
    "createdDateTime", 
    "percentProgress", 
    "resultInfo", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class CaseOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.caseOperation";
    }

    @JsonProperty("action")
    protected CaseAction action;

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("percentProgress")
    protected Integer percentProgress;

    @JsonProperty("resultInfo")
    protected ResultInfo resultInfo;

    @JsonProperty("status")
    protected CaseOperationStatus status;

    protected CaseOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCaseOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private CaseAction action;
        private OffsetDateTime completedDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private Integer percentProgress;
        private ResultInfo resultInfo;
        private CaseOperationStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder action(CaseAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            this.changedFields = changedFields.add("percentProgress");
            return this;
        }

        public Builder resultInfo(ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
            this.changedFields = changedFields.add("resultInfo");
            return this;
        }

        public Builder status(CaseOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public CaseOperation build() {
            CaseOperation _x = new CaseOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.caseOperation";
            _x.id = id;
            _x.action = action;
            _x.completedDateTime = completedDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.percentProgress = percentProgress;
            _x.resultInfo = resultInfo;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="action")
    @JsonIgnore
    public Optional<CaseAction> getAction() {
        return Optional.ofNullable(action);
    }

    public CaseOperation withAction(CaseAction action) {
        CaseOperation _x = _copy();
        _x.changedFields = changedFields.add("action");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseOperation");
        _x.action = action;
        return _x;
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public CaseOperation withCompletedDateTime(OffsetDateTime completedDateTime) {
        CaseOperation _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseOperation");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public CaseOperation withCreatedBy(IdentitySet createdBy) {
        CaseOperation _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseOperation");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public CaseOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        CaseOperation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseOperation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="percentProgress")
    @JsonIgnore
    public Optional<Integer> getPercentProgress() {
        return Optional.ofNullable(percentProgress);
    }

    public CaseOperation withPercentProgress(Integer percentProgress) {
        CaseOperation _x = _copy();
        _x.changedFields = changedFields.add("percentProgress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseOperation");
        _x.percentProgress = percentProgress;
        return _x;
    }

    @Property(name="resultInfo")
    @JsonIgnore
    public Optional<ResultInfo> getResultInfo() {
        return Optional.ofNullable(resultInfo);
    }

    public CaseOperation withResultInfo(ResultInfo resultInfo) {
        CaseOperation _x = _copy();
        _x.changedFields = changedFields.add("resultInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseOperation");
        _x.resultInfo = resultInfo;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CaseOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public CaseOperation withStatus(CaseOperationStatus status) {
        CaseOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.caseOperation");
        _x.status = status;
        return _x;
    }

    public CaseOperation withUnmappedField(String name, Object value) {
        CaseOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CaseOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CaseOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CaseOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CaseOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CaseOperation _copy() {
        CaseOperation _x = new CaseOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.action = action;
        _x.completedDateTime = completedDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.percentProgress = percentProgress;
        _x.resultInfo = resultInfo;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CaseOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("percentProgress=");
        b.append(this.percentProgress);
        b.append(", ");
        b.append("resultInfo=");
        b.append(this.resultInfo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
