package odata.msgraph.client.beta.ediscovery.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isEnabled", 
    "maxWords", 
    "minWords", 
    "similarityThreshold"})
@JsonInclude(Include.NON_NULL)
public class RedundancyDetectionSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("maxWords")
    protected Integer maxWords;

    @JsonProperty("minWords")
    protected Integer minWords;

    @JsonProperty("similarityThreshold")
    protected Integer similarityThreshold;

    protected RedundancyDetectionSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.redundancyDetectionSettings";
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public RedundancyDetectionSettings withIsEnabled(Boolean isEnabled) {
        RedundancyDetectionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.redundancyDetectionSettings");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="maxWords")
    @JsonIgnore
    public Optional<Integer> getMaxWords() {
        return Optional.ofNullable(maxWords);
    }

    public RedundancyDetectionSettings withMaxWords(Integer maxWords) {
        RedundancyDetectionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.redundancyDetectionSettings");
        _x.maxWords = maxWords;
        return _x;
    }

    @Property(name="minWords")
    @JsonIgnore
    public Optional<Integer> getMinWords() {
        return Optional.ofNullable(minWords);
    }

    public RedundancyDetectionSettings withMinWords(Integer minWords) {
        RedundancyDetectionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.redundancyDetectionSettings");
        _x.minWords = minWords;
        return _x;
    }

    @Property(name="similarityThreshold")
    @JsonIgnore
    public Optional<Integer> getSimilarityThreshold() {
        return Optional.ofNullable(similarityThreshold);
    }

    public RedundancyDetectionSettings withSimilarityThreshold(Integer similarityThreshold) {
        RedundancyDetectionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.redundancyDetectionSettings");
        _x.similarityThreshold = similarityThreshold;
        return _x;
    }

    public RedundancyDetectionSettings withUnmappedField(String name, Object value) {
        RedundancyDetectionSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isEnabled;
        private Integer maxWords;
        private Integer minWords;
        private Integer similarityThreshold;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder maxWords(Integer maxWords) {
            this.maxWords = maxWords;
            this.changedFields = changedFields.add("maxWords");
            return this;
        }

        public Builder minWords(Integer minWords) {
            this.minWords = minWords;
            this.changedFields = changedFields.add("minWords");
            return this;
        }

        public Builder similarityThreshold(Integer similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            this.changedFields = changedFields.add("similarityThreshold");
            return this;
        }

        public RedundancyDetectionSettings build() {
            RedundancyDetectionSettings _x = new RedundancyDetectionSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.redundancyDetectionSettings";
            _x.isEnabled = isEnabled;
            _x.maxWords = maxWords;
            _x.minWords = minWords;
            _x.similarityThreshold = similarityThreshold;
            return _x;
        }
    }

    private RedundancyDetectionSettings _copy() {
        RedundancyDetectionSettings _x = new RedundancyDetectionSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isEnabled = isEnabled;
        _x.maxWords = maxWords;
        _x.minWords = minWords;
        _x.similarityThreshold = similarityThreshold;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RedundancyDetectionSettings[");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("maxWords=");
        b.append(this.maxWords);
        b.append(", ");
        b.append("minWords=");
        b.append(this.minWords);
        b.append(", ");
        b.append("similarityThreshold=");
        b.append(this.similarityThreshold);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
