package odata.msgraph.client.beta.ediscovery.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isEnabled", 
    "maxImageSize", 
    "timeout"})
@JsonInclude(Include.NON_NULL)
public class OcrSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("maxImageSize")
    protected Integer maxImageSize;

    @JsonProperty("timeout")
    protected Duration timeout;

    protected OcrSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscovery.ocrSettings";
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public OcrSettings withIsEnabled(Boolean isEnabled) {
        OcrSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.ocrSettings");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="maxImageSize")
    @JsonIgnore
    public Optional<Integer> getMaxImageSize() {
        return Optional.ofNullable(maxImageSize);
    }

    public OcrSettings withMaxImageSize(Integer maxImageSize) {
        OcrSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.ocrSettings");
        _x.maxImageSize = maxImageSize;
        return _x;
    }

    @Property(name="timeout")
    @JsonIgnore
    public Optional<Duration> getTimeout() {
        return Optional.ofNullable(timeout);
    }

    public OcrSettings withTimeout(Duration timeout) {
        OcrSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscovery.ocrSettings");
        _x.timeout = timeout;
        return _x;
    }

    public OcrSettings withUnmappedField(String name, Object value) {
        OcrSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isEnabled;
        private Integer maxImageSize;
        private Duration timeout;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder maxImageSize(Integer maxImageSize) {
            this.maxImageSize = maxImageSize;
            this.changedFields = changedFields.add("maxImageSize");
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            this.changedFields = changedFields.add("timeout");
            return this;
        }

        public OcrSettings build() {
            OcrSettings _x = new OcrSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ediscovery.ocrSettings";
            _x.isEnabled = isEnabled;
            _x.maxImageSize = maxImageSize;
            _x.timeout = timeout;
            return _x;
        }
    }

    private OcrSettings _copy() {
        OcrSettings _x = new OcrSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isEnabled = isEnabled;
        _x.maxImageSize = maxImageSize;
        _x.timeout = timeout;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OcrSettings[");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("maxImageSize=");
        b.append(this.maxImageSize);
        b.append(", ");
        b.append("timeout=");
        b.append(this.timeout);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
