package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.X509CertificateAuthenticationMode;
import odata.msgraph.client.beta.enums.X509CertificateRuleType;

@JsonPropertyOrder({
    "@odata.type", 
    "identifier", 
    "x509CertificateAuthenticationMode", 
    "x509CertificateRuleType"})
@JsonInclude(Include.NON_NULL)
public class X509CertificateRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("identifier")
    protected String identifier;

    @JsonProperty("x509CertificateAuthenticationMode")
    protected X509CertificateAuthenticationMode x509CertificateAuthenticationMode;

    @JsonProperty("x509CertificateRuleType")
    protected X509CertificateRuleType x509CertificateRuleType;

    protected X509CertificateRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.x509CertificateRule";
    }

    @Property(name="identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public X509CertificateRule withIdentifier(String identifier) {
        X509CertificateRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateRule");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="x509CertificateAuthenticationMode")
    @JsonIgnore
    public Optional<X509CertificateAuthenticationMode> getX509CertificateAuthenticationMode() {
        return Optional.ofNullable(x509CertificateAuthenticationMode);
    }

    public X509CertificateRule withX509CertificateAuthenticationMode(X509CertificateAuthenticationMode x509CertificateAuthenticationMode) {
        X509CertificateRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateRule");
        _x.x509CertificateAuthenticationMode = x509CertificateAuthenticationMode;
        return _x;
    }

    @Property(name="x509CertificateRuleType")
    @JsonIgnore
    public Optional<X509CertificateRuleType> getX509CertificateRuleType() {
        return Optional.ofNullable(x509CertificateRuleType);
    }

    public X509CertificateRule withX509CertificateRuleType(X509CertificateRuleType x509CertificateRuleType) {
        X509CertificateRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.x509CertificateRule");
        _x.x509CertificateRuleType = x509CertificateRuleType;
        return _x;
    }

    public X509CertificateRule withUnmappedField(String name, Object value) {
        X509CertificateRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String identifier;
        private X509CertificateAuthenticationMode x509CertificateAuthenticationMode;
        private X509CertificateRuleType x509CertificateRuleType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("identifier");
            return this;
        }

        public Builder x509CertificateAuthenticationMode(X509CertificateAuthenticationMode x509CertificateAuthenticationMode) {
            this.x509CertificateAuthenticationMode = x509CertificateAuthenticationMode;
            this.changedFields = changedFields.add("x509CertificateAuthenticationMode");
            return this;
        }

        public Builder x509CertificateRuleType(X509CertificateRuleType x509CertificateRuleType) {
            this.x509CertificateRuleType = x509CertificateRuleType;
            this.changedFields = changedFields.add("x509CertificateRuleType");
            return this;
        }

        public X509CertificateRule build() {
            X509CertificateRule _x = new X509CertificateRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.x509CertificateRule";
            _x.identifier = identifier;
            _x.x509CertificateAuthenticationMode = x509CertificateAuthenticationMode;
            _x.x509CertificateRuleType = x509CertificateRuleType;
            return _x;
        }
    }

    private X509CertificateRule _copy() {
        X509CertificateRule _x = new X509CertificateRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.identifier = identifier;
        _x.x509CertificateAuthenticationMode = x509CertificateAuthenticationMode;
        _x.x509CertificateRuleType = x509CertificateRuleType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("X509CertificateRule[");
        b.append("identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("x509CertificateAuthenticationMode=");
        b.append(this.x509CertificateAuthenticationMode);
        b.append(", ");
        b.append("x509CertificateRuleType=");
        b.append(this.x509CertificateRuleType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
