package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ascending", 
    "color", 
    "dataOption", 
    "icon", 
    "key", 
    "sortOn"})
@JsonInclude(Include.NON_NULL)
public class WorkbookSortField implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ascending")
    protected Boolean ascending;

    @JsonProperty("color")
    protected String color;

    @JsonProperty("dataOption")
    protected String dataOption;

    @JsonProperty("icon")
    protected WorkbookIcon icon;

    @JsonProperty("key")
    protected Integer key;

    @JsonProperty("sortOn")
    protected String sortOn;

    protected WorkbookSortField() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookSortField";
    }

    @Property(name="ascending")
    @JsonIgnore
    public Optional<Boolean> getAscending() {
        return Optional.ofNullable(ascending);
    }

    public WorkbookSortField withAscending(Boolean ascending) {
        WorkbookSortField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSortField");
        _x.ascending = ascending;
        return _x;
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public WorkbookSortField withColor(String color) {
        WorkbookSortField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSortField");
        _x.color = color;
        return _x;
    }

    @Property(name="dataOption")
    @JsonIgnore
    public Optional<String> getDataOption() {
        return Optional.ofNullable(dataOption);
    }

    public WorkbookSortField withDataOption(String dataOption) {
        WorkbookSortField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSortField");
        _x.dataOption = dataOption;
        return _x;
    }

    @Property(name="icon")
    @JsonIgnore
    public Optional<WorkbookIcon> getIcon() {
        return Optional.ofNullable(icon);
    }

    public WorkbookSortField withIcon(WorkbookIcon icon) {
        WorkbookSortField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSortField");
        _x.icon = icon;
        return _x;
    }

    @Property(name="key")
    @JsonIgnore
    public Optional<Integer> getKey() {
        return Optional.ofNullable(key);
    }

    public WorkbookSortField withKey(Integer key) {
        WorkbookSortField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSortField");
        _x.key = key;
        return _x;
    }

    @Property(name="sortOn")
    @JsonIgnore
    public Optional<String> getSortOn() {
        return Optional.ofNullable(sortOn);
    }

    public WorkbookSortField withSortOn(String sortOn) {
        WorkbookSortField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSortField");
        _x.sortOn = sortOn;
        return _x;
    }

    public WorkbookSortField withUnmappedField(String name, Object value) {
        WorkbookSortField _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean ascending;
        private String color;
        private String dataOption;
        private WorkbookIcon icon;
        private Integer key;
        private String sortOn;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ascending(Boolean ascending) {
            this.ascending = ascending;
            this.changedFields = changedFields.add("ascending");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder dataOption(String dataOption) {
            this.dataOption = dataOption;
            this.changedFields = changedFields.add("dataOption");
            return this;
        }

        public Builder icon(WorkbookIcon icon) {
            this.icon = icon;
            this.changedFields = changedFields.add("icon");
            return this;
        }

        public Builder key(Integer key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        public Builder sortOn(String sortOn) {
            this.sortOn = sortOn;
            this.changedFields = changedFields.add("sortOn");
            return this;
        }

        public WorkbookSortField build() {
            WorkbookSortField _x = new WorkbookSortField();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookSortField";
            _x.ascending = ascending;
            _x.color = color;
            _x.dataOption = dataOption;
            _x.icon = icon;
            _x.key = key;
            _x.sortOn = sortOn;
            return _x;
        }
    }

    private WorkbookSortField _copy() {
        WorkbookSortField _x = new WorkbookSortField();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ascending = ascending;
        _x.color = color;
        _x.dataOption = dataOption;
        _x.icon = icon;
        _x.key = key;
        _x.sortOn = sortOn;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookSortField[");
        b.append("ascending=");
        b.append(this.ascending);
        b.append(", ");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("dataOption=");
        b.append(this.dataOption);
        b.append(", ");
        b.append("icon=");
        b.append(this.icon);
        b.append(", ");
        b.append("key=");
        b.append(this.key);
        b.append(", ");
        b.append("sortOn=");
        b.append(this.sortOn);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
