package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "persistChanges"})
@JsonInclude(Include.NON_NULL)
public class WorkbookSessionInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("persistChanges")
    protected Boolean persistChanges;

    protected WorkbookSessionInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookSessionInfo";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public WorkbookSessionInfo withId(String id) {
        WorkbookSessionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSessionInfo");
        _x.id = id;
        return _x;
    }

    @Property(name="persistChanges")
    @JsonIgnore
    public Optional<Boolean> getPersistChanges() {
        return Optional.ofNullable(persistChanges);
    }

    public WorkbookSessionInfo withPersistChanges(Boolean persistChanges) {
        WorkbookSessionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookSessionInfo");
        _x.persistChanges = persistChanges;
        return _x;
    }

    public WorkbookSessionInfo withUnmappedField(String name, Object value) {
        WorkbookSessionInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean persistChanges;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder persistChanges(Boolean persistChanges) {
            this.persistChanges = persistChanges;
            this.changedFields = changedFields.add("persistChanges");
            return this;
        }

        public WorkbookSessionInfo build() {
            WorkbookSessionInfo _x = new WorkbookSessionInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookSessionInfo";
            _x.id = id;
            _x.persistChanges = persistChanges;
            return _x;
        }
    }

    private WorkbookSessionInfo _copy() {
        WorkbookSessionInfo _x = new WorkbookSessionInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.persistChanges = persistChanges;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookSessionInfo[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("persistChanges=");
        b.append(this.persistChanges);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
