package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsMalwareSeverity;


/**
 * <i>“Windows Malware Severity Count Summary”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "distinctMalwareCount", 
    "lastUpdateDateTime", 
    "malwareDetectionCount", 
    "severity"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareSeverityCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("distinctMalwareCount")
    protected Integer distinctMalwareCount;

    @JsonProperty("lastUpdateDateTime")
    protected OffsetDateTime lastUpdateDateTime;

    @JsonProperty("malwareDetectionCount")
    protected Integer malwareDetectionCount;

    @JsonProperty("severity")
    protected WindowsMalwareSeverity severity;

    protected WindowsMalwareSeverityCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareSeverityCount";
    }

    /**
     * <i>“Count of distinct malwares for this malware State. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property distinctMalwareCount
     */
    @Property(name="distinctMalwareCount")
    @JsonIgnore
    public Optional<Integer> getDistinctMalwareCount() {
        return Optional.ofNullable(distinctMalwareCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * distinctMalwareCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Count of distinct malwares for this malware State. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param distinctMalwareCount
     *            new value of {@code distinctMalwareCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code distinctMalwareCount} field changed
     */
    public WindowsMalwareSeverityCount withDistinctMalwareCount(Integer distinctMalwareCount) {
        WindowsMalwareSeverityCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareSeverityCount");
        _x.distinctMalwareCount = distinctMalwareCount;
        return _x;
    }

    /**
     * <i>“The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public WindowsMalwareSeverityCount withLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        WindowsMalwareSeverityCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareSeverityCount");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    /**
     * <i>“Count of threats detections for this malware severity. Valid values -2147483648
     * to 2147483647”</i>
     * 
     * @return property malwareDetectionCount
     */
    @Property(name="malwareDetectionCount")
    @JsonIgnore
    public Optional<Integer> getMalwareDetectionCount() {
        return Optional.ofNullable(malwareDetectionCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * malwareDetectionCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Count of threats detections for this malware severity. Valid values -2147483648
     * to 2147483647”</i>
     * 
     * @param malwareDetectionCount
     *            new value of {@code malwareDetectionCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code malwareDetectionCount} field changed
     */
    public WindowsMalwareSeverityCount withMalwareDetectionCount(Integer malwareDetectionCount) {
        WindowsMalwareSeverityCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareSeverityCount");
        _x.malwareDetectionCount = malwareDetectionCount;
        return _x;
    }

    /**
     * <i>“Malware Threat Severity”</i>
     * 
     * @return property severity
     */
    @Property(name="severity")
    @JsonIgnore
    public Optional<WindowsMalwareSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code severity} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Malware Threat Severity”</i>
     * 
     * @param severity
     *            new value of {@code severity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code severity} field changed
     */
    public WindowsMalwareSeverityCount withSeverity(WindowsMalwareSeverity severity) {
        WindowsMalwareSeverityCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareSeverityCount");
        _x.severity = severity;
        return _x;
    }

    public WindowsMalwareSeverityCount withUnmappedField(String name, Object value) {
        WindowsMalwareSeverityCount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer distinctMalwareCount;
        private OffsetDateTime lastUpdateDateTime;
        private Integer malwareDetectionCount;
        private WindowsMalwareSeverity severity;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Count of distinct malwares for this malware State. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param distinctMalwareCount
         *            value of {@code distinctMalwareCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder distinctMalwareCount(Integer distinctMalwareCount) {
            this.distinctMalwareCount = distinctMalwareCount;
            this.changedFields = changedFields.add("distinctMalwareCount");
            return this;
        }

        /**
         * <i>“The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        /**
         * <i>“Count of threats detections for this malware severity. Valid values -2147483648
         * to 2147483647”</i>
         * 
         * @param malwareDetectionCount
         *            value of {@code malwareDetectionCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder malwareDetectionCount(Integer malwareDetectionCount) {
            this.malwareDetectionCount = malwareDetectionCount;
            this.changedFields = changedFields.add("malwareDetectionCount");
            return this;
        }

        /**
         * <i>“Malware Threat Severity”</i>
         * 
         * @param severity
         *            value of {@code severity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder severity(WindowsMalwareSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        public WindowsMalwareSeverityCount build() {
            WindowsMalwareSeverityCount _x = new WindowsMalwareSeverityCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsMalwareSeverityCount";
            _x.distinctMalwareCount = distinctMalwareCount;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            _x.malwareDetectionCount = malwareDetectionCount;
            _x.severity = severity;
            return _x;
        }
    }

    private WindowsMalwareSeverityCount _copy() {
        WindowsMalwareSeverityCount _x = new WindowsMalwareSeverityCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.distinctMalwareCount = distinctMalwareCount;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        _x.malwareDetectionCount = malwareDetectionCount;
        _x.severity = severity;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareSeverityCount[");
        b.append("distinctMalwareCount=");
        b.append(this.distinctMalwareCount);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append(", ");
        b.append("malwareDetectionCount=");
        b.append(this.malwareDetectionCount);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
