package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsAppStartLayoutTileSize;
import odata.msgraph.client.beta.enums.WindowsEdgeKioskType;
import odata.msgraph.client.beta.enums.WindowsKioskAppType;


/**
 * <i>“KioskModeApp v4 for Win32 app support”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "classicAppPath", 
    "edgeKiosk", 
    "edgeKioskIdleTimeoutMinutes", 
    "edgeKioskType", 
    "edgeNoFirstRun"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskWin32App extends WindowsKioskAppBase implements ODataType {

    @JsonProperty("classicAppPath")
    protected String classicAppPath;

    @JsonProperty("edgeKiosk")
    protected String edgeKiosk;

    @JsonProperty("edgeKioskIdleTimeoutMinutes")
    protected Integer edgeKioskIdleTimeoutMinutes;

    @JsonProperty("edgeKioskType")
    protected WindowsEdgeKioskType edgeKioskType;

    @JsonProperty("edgeNoFirstRun")
    protected Boolean edgeNoFirstRun;

    protected WindowsKioskWin32App() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskWin32App";
    }

    /**
     * <i>“This is the classicapppath to be used by v4 Win32 app while in Kiosk Mode”</i>
     * 
     * @return property classicAppPath
     */
    @Property(name="classicAppPath")
    @JsonIgnore
    public Optional<String> getClassicAppPath() {
        return Optional.ofNullable(classicAppPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code classicAppPath}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This is the classicapppath to be used by v4 Win32 app while in Kiosk Mode”</i>
     * 
     * @param classicAppPath
     *            new value of {@code classicAppPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classicAppPath} field changed
     */
    public WindowsKioskWin32App withClassicAppPath(String classicAppPath) {
        WindowsKioskWin32App _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskWin32App");
        _x.classicAppPath = classicAppPath;
        return _x;
    }

    /**
     * <i>“Edge kiosk (url) for Edge kiosk mode”</i>
     * 
     * @return property edgeKiosk
     */
    @Property(name="edgeKiosk")
    @JsonIgnore
    public Optional<String> getEdgeKiosk() {
        return Optional.ofNullable(edgeKiosk);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeKiosk} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Edge kiosk (url) for Edge kiosk mode”</i>
     * 
     * @param edgeKiosk
     *            new value of {@code edgeKiosk} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeKiosk} field changed
     */
    public WindowsKioskWin32App withEdgeKiosk(String edgeKiosk) {
        WindowsKioskWin32App _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskWin32App");
        _x.edgeKiosk = edgeKiosk;
        return _x;
    }

    /**
     * <i>“Edge kiosk idle timeout in minutes for Edge kiosk mode. Valid values 0 to 1440”</i>
     * 
     * @return property edgeKioskIdleTimeoutMinutes
     */
    @Property(name="edgeKioskIdleTimeoutMinutes")
    @JsonIgnore
    public Optional<Integer> getEdgeKioskIdleTimeoutMinutes() {
        return Optional.ofNullable(edgeKioskIdleTimeoutMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeKioskIdleTimeoutMinutes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Edge kiosk idle timeout in minutes for Edge kiosk mode. Valid values 0 to 1440”</i>
     * 
     * @param edgeKioskIdleTimeoutMinutes
     *            new value of {@code edgeKioskIdleTimeoutMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeKioskIdleTimeoutMinutes} field changed
     */
    public WindowsKioskWin32App withEdgeKioskIdleTimeoutMinutes(Integer edgeKioskIdleTimeoutMinutes) {
        WindowsKioskWin32App _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskWin32App");
        _x.edgeKioskIdleTimeoutMinutes = edgeKioskIdleTimeoutMinutes;
        return _x;
    }

    /**
     * <i>“Edge kiosk type for Edge kiosk mode”</i>
     * 
     * @return property edgeKioskType
     */
    @Property(name="edgeKioskType")
    @JsonIgnore
    public Optional<WindowsEdgeKioskType> getEdgeKioskType() {
        return Optional.ofNullable(edgeKioskType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeKioskType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Edge kiosk type for Edge kiosk mode”</i>
     * 
     * @param edgeKioskType
     *            new value of {@code edgeKioskType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeKioskType} field changed
     */
    public WindowsKioskWin32App withEdgeKioskType(WindowsEdgeKioskType edgeKioskType) {
        WindowsKioskWin32App _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskWin32App");
        _x.edgeKioskType = edgeKioskType;
        return _x;
    }

    /**
     * <i>“Edge first run flag for Edge kiosk mode”</i>
     * 
     * @return property edgeNoFirstRun
     */
    @Property(name="edgeNoFirstRun")
    @JsonIgnore
    public Optional<Boolean> getEdgeNoFirstRun() {
        return Optional.ofNullable(edgeNoFirstRun);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeNoFirstRun}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Edge first run flag for Edge kiosk mode”</i>
     * 
     * @param edgeNoFirstRun
     *            new value of {@code edgeNoFirstRun} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeNoFirstRun} field changed
     */
    public WindowsKioskWin32App withEdgeNoFirstRun(Boolean edgeNoFirstRun) {
        WindowsKioskWin32App _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskWin32App");
        _x.edgeNoFirstRun = edgeNoFirstRun;
        return _x;
    }

    public WindowsKioskWin32App withUnmappedField(String name, Object value) {
        WindowsKioskWin32App _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskWin32App() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsKioskAppType appType;
        private Boolean autoLaunch;
        private String name;
        private WindowsAppStartLayoutTileSize startLayoutTileSize;
        private String classicAppPath;
        private String edgeKiosk;
        private Integer edgeKioskIdleTimeoutMinutes;
        private WindowsEdgeKioskType edgeKioskType;
        private Boolean edgeNoFirstRun;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appType(WindowsKioskAppType appType) {
            this.appType = appType;
            this.changedFields = changedFields.add("appType");
            return this;
        }

        public Builder autoLaunch(Boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
            this.changedFields = changedFields.add("autoLaunch");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder startLayoutTileSize(WindowsAppStartLayoutTileSize startLayoutTileSize) {
            this.startLayoutTileSize = startLayoutTileSize;
            this.changedFields = changedFields.add("startLayoutTileSize");
            return this;
        }

        /**
         * <i>“This is the classicapppath to be used by v4 Win32 app while in Kiosk Mode”</i>
         * 
         * @param classicAppPath
         *            value of {@code classicAppPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classicAppPath(String classicAppPath) {
            this.classicAppPath = classicAppPath;
            this.changedFields = changedFields.add("classicAppPath");
            return this;
        }

        /**
         * <i>“Edge kiosk (url) for Edge kiosk mode”</i>
         * 
         * @param edgeKiosk
         *            value of {@code edgeKiosk} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeKiosk(String edgeKiosk) {
            this.edgeKiosk = edgeKiosk;
            this.changedFields = changedFields.add("edgeKiosk");
            return this;
        }

        /**
         * <i>“Edge kiosk idle timeout in minutes for Edge kiosk mode. Valid values 0 to 1440”</i>
         * 
         * @param edgeKioskIdleTimeoutMinutes
         *            value of {@code edgeKioskIdleTimeoutMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeKioskIdleTimeoutMinutes(Integer edgeKioskIdleTimeoutMinutes) {
            this.edgeKioskIdleTimeoutMinutes = edgeKioskIdleTimeoutMinutes;
            this.changedFields = changedFields.add("edgeKioskIdleTimeoutMinutes");
            return this;
        }

        /**
         * <i>“Edge kiosk type for Edge kiosk mode”</i>
         * 
         * @param edgeKioskType
         *            value of {@code edgeKioskType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeKioskType(WindowsEdgeKioskType edgeKioskType) {
            this.edgeKioskType = edgeKioskType;
            this.changedFields = changedFields.add("edgeKioskType");
            return this;
        }

        /**
         * <i>“Edge first run flag for Edge kiosk mode”</i>
         * 
         * @param edgeNoFirstRun
         *            value of {@code edgeNoFirstRun} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeNoFirstRun(Boolean edgeNoFirstRun) {
            this.edgeNoFirstRun = edgeNoFirstRun;
            this.changedFields = changedFields.add("edgeNoFirstRun");
            return this;
        }

        public WindowsKioskWin32App build() {
            WindowsKioskWin32App _x = new WindowsKioskWin32App();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsKioskWin32App";
            _x.appType = appType;
            _x.autoLaunch = autoLaunch;
            _x.name = name;
            _x.startLayoutTileSize = startLayoutTileSize;
            _x.classicAppPath = classicAppPath;
            _x.edgeKiosk = edgeKiosk;
            _x.edgeKioskIdleTimeoutMinutes = edgeKioskIdleTimeoutMinutes;
            _x.edgeKioskType = edgeKioskType;
            _x.edgeNoFirstRun = edgeNoFirstRun;
            return _x;
        }
    }

    private WindowsKioskWin32App _copy() {
        WindowsKioskWin32App _x = new WindowsKioskWin32App();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appType = appType;
        _x.autoLaunch = autoLaunch;
        _x.name = name;
        _x.startLayoutTileSize = startLayoutTileSize;
        _x.classicAppPath = classicAppPath;
        _x.edgeKiosk = edgeKiosk;
        _x.edgeKioskIdleTimeoutMinutes = edgeKioskIdleTimeoutMinutes;
        _x.edgeKioskType = edgeKioskType;
        _x.edgeNoFirstRun = edgeNoFirstRun;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskWin32App[");
        b.append("appType=");
        b.append(this.appType);
        b.append(", ");
        b.append("autoLaunch=");
        b.append(this.autoLaunch);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("startLayoutTileSize=");
        b.append(this.startLayoutTileSize);
        b.append(", ");
        b.append("classicAppPath=");
        b.append(this.classicAppPath);
        b.append(", ");
        b.append("edgeKiosk=");
        b.append(this.edgeKiosk);
        b.append(", ");
        b.append("edgeKioskIdleTimeoutMinutes=");
        b.append(this.edgeKioskIdleTimeoutMinutes);
        b.append(", ");
        b.append("edgeKioskType=");
        b.append(this.edgeKioskType);
        b.append(", ");
        b.append("edgeNoFirstRun=");
        b.append(this.edgeNoFirstRun);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
