package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appConfiguration", 
    "profileId", 
    "profileName", 
    "userAccountsConfiguration"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskProfile implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appConfiguration")
    protected WindowsKioskAppConfiguration appConfiguration;

    @JsonProperty("profileId")
    protected String profileId;

    @JsonProperty("profileName")
    protected String profileName;

    @JsonProperty("userAccountsConfiguration")
    protected List<WindowsKioskUser> userAccountsConfiguration;

    @JsonProperty("userAccountsConfiguration@nextLink")
    protected String userAccountsConfigurationNextLink;

    protected WindowsKioskProfile() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskProfile";
    }

    /**
     * <i>“The App configuration that will be used for this kiosk configuration.”</i>
     * 
     * @return property appConfiguration
     */
    @Property(name="appConfiguration")
    @JsonIgnore
    public Optional<WindowsKioskAppConfiguration> getAppConfiguration() {
        return Optional.ofNullable(appConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appConfiguration}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The App configuration that will be used for this kiosk configuration.”</i>
     * 
     * @param appConfiguration
     *            new value of {@code appConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appConfiguration} field changed
     */
    public WindowsKioskProfile withAppConfiguration(WindowsKioskAppConfiguration appConfiguration) {
        WindowsKioskProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskProfile");
        _x.appConfiguration = appConfiguration;
        return _x;
    }

    /**
     * <i>“Key of the entity.”</i>
     * 
     * @return property profileId
     */
    @Property(name="profileId")
    @JsonIgnore
    public Optional<String> getProfileId() {
        return Optional.ofNullable(profileId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code profileId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Key of the entity.”</i>
     * 
     * @param profileId
     *            new value of {@code profileId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileId} field changed
     */
    public WindowsKioskProfile withProfileId(String profileId) {
        WindowsKioskProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskProfile");
        _x.profileId = profileId;
        return _x;
    }

    /**
     * <i>“This is a friendly name used to identify a group of applications, the layout of
     * these apps on the start menu and the users to whom this kiosk configuration is
     * assigned.”</i>
     * 
     * @return property profileName
     */
    @Property(name="profileName")
    @JsonIgnore
    public Optional<String> getProfileName() {
        return Optional.ofNullable(profileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code profileName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This is a friendly name used to identify a group of applications, the layout of
     * these apps on the start menu and the users to whom this kiosk configuration is
     * assigned.”</i>
     * 
     * @param profileName
     *            new value of {@code profileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileName} field changed
     */
    public WindowsKioskProfile withProfileName(String profileName) {
        WindowsKioskProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskProfile");
        _x.profileName = profileName;
        return _x;
    }

    /**
     * <i>“The user accounts that will be locked to this kiosk configuration. This
     * collection can contain a maximum of 100 elements.”</i>
     * 
     * @return property userAccountsConfiguration
     */
    @Property(name="userAccountsConfiguration")
    @JsonIgnore
    public CollectionPage<WindowsKioskUser> getUserAccountsConfiguration() {
        return new CollectionPage<WindowsKioskUser>(contextPath, WindowsKioskUser.class, this.userAccountsConfiguration, Optional.ofNullable(userAccountsConfigurationNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The user accounts that will be locked to this kiosk configuration. This
     * collection can contain a maximum of 100 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property userAccountsConfiguration
     */
    @Property(name="userAccountsConfiguration")
    @JsonIgnore
    public CollectionPage<WindowsKioskUser> getUserAccountsConfiguration(HttpRequestOptions options) {
        return new CollectionPage<WindowsKioskUser>(contextPath, WindowsKioskUser.class, this.userAccountsConfiguration, Optional.ofNullable(userAccountsConfigurationNextLink), Collections.emptyList(), options);
    }

    public WindowsKioskProfile withUnmappedField(String name, Object value) {
        WindowsKioskProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsKioskAppConfiguration appConfiguration;
        private String profileId;
        private String profileName;
        private List<WindowsKioskUser> userAccountsConfiguration;
        private String userAccountsConfigurationNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The App configuration that will be used for this kiosk configuration.”</i>
         * 
         * @param appConfiguration
         *            value of {@code appConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appConfiguration(WindowsKioskAppConfiguration appConfiguration) {
            this.appConfiguration = appConfiguration;
            this.changedFields = changedFields.add("appConfiguration");
            return this;
        }

        /**
         * <i>“Key of the entity.”</i>
         * 
         * @param profileId
         *            value of {@code profileId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileId(String profileId) {
            this.profileId = profileId;
            this.changedFields = changedFields.add("profileId");
            return this;
        }

        /**
         * <i>“This is a friendly name used to identify a group of applications, the layout of
         * these apps on the start menu and the users to whom this kiosk configuration is
         * assigned.”</i>
         * 
         * @param profileName
         *            value of {@code profileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileName(String profileName) {
            this.profileName = profileName;
            this.changedFields = changedFields.add("profileName");
            return this;
        }

        /**
         * <i>“The user accounts that will be locked to this kiosk configuration. This
         * collection can contain a maximum of 100 elements.”</i>
         * 
         * @param userAccountsConfiguration
         *            value of {@code userAccountsConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userAccountsConfiguration(List<WindowsKioskUser> userAccountsConfiguration) {
            this.userAccountsConfiguration = userAccountsConfiguration;
            this.changedFields = changedFields.add("userAccountsConfiguration");
            return this;
        }

        /**
         * <i>“The user accounts that will be locked to this kiosk configuration. This
         * collection can contain a maximum of 100 elements.”</i>
         * 
         * @param userAccountsConfiguration
         *            value of {@code userAccountsConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userAccountsConfiguration(WindowsKioskUser... userAccountsConfiguration) {
            return userAccountsConfiguration(Arrays.asList(userAccountsConfiguration));
        }

        /**
         * <i>“The user accounts that will be locked to this kiosk configuration. This
         * collection can contain a maximum of 100 elements.”</i>
         * 
         * @param userAccountsConfigurationNextLink
         *            value of {@code userAccountsConfiguration@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userAccountsConfigurationNextLink(String userAccountsConfigurationNextLink) {
            this.userAccountsConfigurationNextLink = userAccountsConfigurationNextLink;
            this.changedFields = changedFields.add("userAccountsConfiguration");
            return this;
        }

        public WindowsKioskProfile build() {
            WindowsKioskProfile _x = new WindowsKioskProfile();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsKioskProfile";
            _x.appConfiguration = appConfiguration;
            _x.profileId = profileId;
            _x.profileName = profileName;
            _x.userAccountsConfiguration = userAccountsConfiguration;
            _x.userAccountsConfigurationNextLink = userAccountsConfigurationNextLink;
            return _x;
        }
    }

    private WindowsKioskProfile _copy() {
        WindowsKioskProfile _x = new WindowsKioskProfile();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appConfiguration = appConfiguration;
        _x.profileId = profileId;
        _x.profileName = profileName;
        _x.userAccountsConfiguration = userAccountsConfiguration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskProfile[");
        b.append("appConfiguration=");
        b.append(this.appConfiguration);
        b.append(", ");
        b.append("profileId=");
        b.append(this.profileId);
        b.append(", ");
        b.append("profileName=");
        b.append(this.profileName);
        b.append(", ");
        b.append("userAccountsConfiguration=");
        b.append(this.userAccountsConfiguration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
