package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsAppStartLayoutTileSize;
import odata.msgraph.client.beta.enums.WindowsKioskAppType;


/**
 * <i>“The base class for a type of apps”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "desktopApplicationId", 
    "desktopApplicationLinkPath", 
    "path"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskDesktopApp extends WindowsKioskAppBase implements ODataType {

    @JsonProperty("desktopApplicationId")
    protected String desktopApplicationId;

    @JsonProperty("desktopApplicationLinkPath")
    protected String desktopApplicationLinkPath;

    @JsonProperty("path")
    protected String path;

    protected WindowsKioskDesktopApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskDesktopApp";
    }

    /**
     * <i>“Define the DesktopApplicationID of the app”</i>
     * 
     * @return property desktopApplicationId
     */
    @Property(name="desktopApplicationId")
    @JsonIgnore
    public Optional<String> getDesktopApplicationId() {
        return Optional.ofNullable(desktopApplicationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * desktopApplicationId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Define the DesktopApplicationID of the app”</i>
     * 
     * @param desktopApplicationId
     *            new value of {@code desktopApplicationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code desktopApplicationId} field changed
     */
    public WindowsKioskDesktopApp withDesktopApplicationId(String desktopApplicationId) {
        WindowsKioskDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskDesktopApp");
        _x.desktopApplicationId = desktopApplicationId;
        return _x;
    }

    /**
     * <i>“Define the DesktopApplicationLinkPath of the app”</i>
     * 
     * @return property desktopApplicationLinkPath
     */
    @Property(name="desktopApplicationLinkPath")
    @JsonIgnore
    public Optional<String> getDesktopApplicationLinkPath() {
        return Optional.ofNullable(desktopApplicationLinkPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * desktopApplicationLinkPath} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Define the DesktopApplicationLinkPath of the app”</i>
     * 
     * @param desktopApplicationLinkPath
     *            new value of {@code desktopApplicationLinkPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code desktopApplicationLinkPath} field changed
     */
    public WindowsKioskDesktopApp withDesktopApplicationLinkPath(String desktopApplicationLinkPath) {
        WindowsKioskDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskDesktopApp");
        _x.desktopApplicationLinkPath = desktopApplicationLinkPath;
        return _x;
    }

    /**
     * <i>“Define the path of a desktop app”</i>
     * 
     * @return property path
     */
    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code path} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Define the path of a desktop app”</i>
     * 
     * @param path
     *            new value of {@code path} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code path} field changed
     */
    public WindowsKioskDesktopApp withPath(String path) {
        WindowsKioskDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskDesktopApp");
        _x.path = path;
        return _x;
    }

    public WindowsKioskDesktopApp withUnmappedField(String name, Object value) {
        WindowsKioskDesktopApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskDesktopApp() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsKioskAppType appType;
        private Boolean autoLaunch;
        private String name;
        private WindowsAppStartLayoutTileSize startLayoutTileSize;
        private String desktopApplicationId;
        private String desktopApplicationLinkPath;
        private String path;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appType(WindowsKioskAppType appType) {
            this.appType = appType;
            this.changedFields = changedFields.add("appType");
            return this;
        }

        public Builder autoLaunch(Boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
            this.changedFields = changedFields.add("autoLaunch");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder startLayoutTileSize(WindowsAppStartLayoutTileSize startLayoutTileSize) {
            this.startLayoutTileSize = startLayoutTileSize;
            this.changedFields = changedFields.add("startLayoutTileSize");
            return this;
        }

        /**
         * <i>“Define the DesktopApplicationID of the app”</i>
         * 
         * @param desktopApplicationId
         *            value of {@code desktopApplicationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder desktopApplicationId(String desktopApplicationId) {
            this.desktopApplicationId = desktopApplicationId;
            this.changedFields = changedFields.add("desktopApplicationId");
            return this;
        }

        /**
         * <i>“Define the DesktopApplicationLinkPath of the app”</i>
         * 
         * @param desktopApplicationLinkPath
         *            value of {@code desktopApplicationLinkPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder desktopApplicationLinkPath(String desktopApplicationLinkPath) {
            this.desktopApplicationLinkPath = desktopApplicationLinkPath;
            this.changedFields = changedFields.add("desktopApplicationLinkPath");
            return this;
        }

        /**
         * <i>“Define the path of a desktop app”</i>
         * 
         * @param path
         *            value of {@code path} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public WindowsKioskDesktopApp build() {
            WindowsKioskDesktopApp _x = new WindowsKioskDesktopApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsKioskDesktopApp";
            _x.appType = appType;
            _x.autoLaunch = autoLaunch;
            _x.name = name;
            _x.startLayoutTileSize = startLayoutTileSize;
            _x.desktopApplicationId = desktopApplicationId;
            _x.desktopApplicationLinkPath = desktopApplicationLinkPath;
            _x.path = path;
            return _x;
        }
    }

    private WindowsKioskDesktopApp _copy() {
        WindowsKioskDesktopApp _x = new WindowsKioskDesktopApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appType = appType;
        _x.autoLaunch = autoLaunch;
        _x.name = name;
        _x.startLayoutTileSize = startLayoutTileSize;
        _x.desktopApplicationId = desktopApplicationId;
        _x.desktopApplicationLinkPath = desktopApplicationLinkPath;
        _x.path = path;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskDesktopApp[");
        b.append("appType=");
        b.append(this.appType);
        b.append(", ");
        b.append("autoLaunch=");
        b.append(this.autoLaunch);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("startLayoutTileSize=");
        b.append(this.startLayoutTileSize);
        b.append(", ");
        b.append("desktopApplicationId=");
        b.append(this.desktopApplicationId);
        b.append(", ");
        b.append("desktopApplicationLinkPath=");
        b.append(this.desktopApplicationLinkPath);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
