package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Windows Information Protection Resource Collection”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "resources"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionResourceCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("resources")
    protected List<String> resources;

    @JsonProperty("resources@nextLink")
    protected String resourcesNextLink;

    protected WindowsInformationProtectionResourceCollection() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionResourceCollection";
    }

    /**
     * <i>“Display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsInformationProtectionResourceCollection withDisplayName(String displayName) {
        WindowsInformationProtectionResourceCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionResourceCollection");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Collection of resources”</i>
     * 
     * @return property resources
     */
    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<String> getResources() {
        return new CollectionPage<String>(contextPath, String.class, this.resources, Optional.ofNullable(resourcesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of resources”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property resources
     */
    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<String> getResources(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.resources, Optional.ofNullable(resourcesNextLink), Collections.emptyList(), options);
    }

    public WindowsInformationProtectionResourceCollection withUnmappedField(String name, Object value) {
        WindowsInformationProtectionResourceCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private List<String> resources;
        private String resourcesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Collection of resources”</i>
         * 
         * @param resources
         *            value of {@code resources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resources(List<String> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        /**
         * <i>“Collection of resources”</i>
         * 
         * @param resources
         *            value of {@code resources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resources(String... resources) {
            return resources(Arrays.asList(resources));
        }

        /**
         * <i>“Collection of resources”</i>
         * 
         * @param resourcesNextLink
         *            value of {@code resources@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourcesNextLink(String resourcesNextLink) {
            this.resourcesNextLink = resourcesNextLink;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public WindowsInformationProtectionResourceCollection build() {
            WindowsInformationProtectionResourceCollection _x = new WindowsInformationProtectionResourceCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsInformationProtectionResourceCollection";
            _x.displayName = displayName;
            _x.resources = resources;
            _x.resourcesNextLink = resourcesNextLink;
            return _x;
        }
    }

    private WindowsInformationProtectionResourceCollection _copy() {
        WindowsInformationProtectionResourceCollection _x = new WindowsInformationProtectionResourceCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.resources = resources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionResourceCollection[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
