package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.StateManagementSetting;


/**
 * <i>“Windows Firewall Profile Policies.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "authorizedApplicationRulesFromGroupPolicyMerged", 
    "authorizedApplicationRulesFromGroupPolicyNotMerged", 
    "connectionSecurityRulesFromGroupPolicyMerged", 
    "connectionSecurityRulesFromGroupPolicyNotMerged", 
    "firewallEnabled", 
    "globalPortRulesFromGroupPolicyMerged", 
    "globalPortRulesFromGroupPolicyNotMerged", 
    "inboundConnectionsBlocked", 
    "inboundConnectionsRequired", 
    "inboundNotificationsBlocked", 
    "inboundNotificationsRequired", 
    "incomingTrafficBlocked", 
    "incomingTrafficRequired", 
    "outboundConnectionsBlocked", 
    "outboundConnectionsRequired", 
    "policyRulesFromGroupPolicyMerged", 
    "policyRulesFromGroupPolicyNotMerged", 
    "securedPacketExemptionAllowed", 
    "securedPacketExemptionBlocked", 
    "stealthModeBlocked", 
    "stealthModeRequired", 
    "unicastResponsesToMulticastBroadcastsBlocked", 
    "unicastResponsesToMulticastBroadcastsRequired"})
@JsonInclude(Include.NON_NULL)
public class WindowsFirewallNetworkProfile implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authorizedApplicationRulesFromGroupPolicyMerged")
    protected Boolean authorizedApplicationRulesFromGroupPolicyMerged;

    @JsonProperty("authorizedApplicationRulesFromGroupPolicyNotMerged")
    protected Boolean authorizedApplicationRulesFromGroupPolicyNotMerged;

    @JsonProperty("connectionSecurityRulesFromGroupPolicyMerged")
    protected Boolean connectionSecurityRulesFromGroupPolicyMerged;

    @JsonProperty("connectionSecurityRulesFromGroupPolicyNotMerged")
    protected Boolean connectionSecurityRulesFromGroupPolicyNotMerged;

    @JsonProperty("firewallEnabled")
    protected StateManagementSetting firewallEnabled;

    @JsonProperty("globalPortRulesFromGroupPolicyMerged")
    protected Boolean globalPortRulesFromGroupPolicyMerged;

    @JsonProperty("globalPortRulesFromGroupPolicyNotMerged")
    protected Boolean globalPortRulesFromGroupPolicyNotMerged;

    @JsonProperty("inboundConnectionsBlocked")
    protected Boolean inboundConnectionsBlocked;

    @JsonProperty("inboundConnectionsRequired")
    protected Boolean inboundConnectionsRequired;

    @JsonProperty("inboundNotificationsBlocked")
    protected Boolean inboundNotificationsBlocked;

    @JsonProperty("inboundNotificationsRequired")
    protected Boolean inboundNotificationsRequired;

    @JsonProperty("incomingTrafficBlocked")
    protected Boolean incomingTrafficBlocked;

    @JsonProperty("incomingTrafficRequired")
    protected Boolean incomingTrafficRequired;

    @JsonProperty("outboundConnectionsBlocked")
    protected Boolean outboundConnectionsBlocked;

    @JsonProperty("outboundConnectionsRequired")
    protected Boolean outboundConnectionsRequired;

    @JsonProperty("policyRulesFromGroupPolicyMerged")
    protected Boolean policyRulesFromGroupPolicyMerged;

    @JsonProperty("policyRulesFromGroupPolicyNotMerged")
    protected Boolean policyRulesFromGroupPolicyNotMerged;

    @JsonProperty("securedPacketExemptionAllowed")
    protected Boolean securedPacketExemptionAllowed;

    @JsonProperty("securedPacketExemptionBlocked")
    protected Boolean securedPacketExemptionBlocked;

    @JsonProperty("stealthModeBlocked")
    protected Boolean stealthModeBlocked;

    @JsonProperty("stealthModeRequired")
    protected Boolean stealthModeRequired;

    @JsonProperty("unicastResponsesToMulticastBroadcastsBlocked")
    protected Boolean unicastResponsesToMulticastBroadcastsBlocked;

    @JsonProperty("unicastResponsesToMulticastBroadcastsRequired")
    protected Boolean unicastResponsesToMulticastBroadcastsRequired;

    protected WindowsFirewallNetworkProfile() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsFirewallNetworkProfile";
    }

    /**
     * <i>“Configures the firewall to merge authorized application rules from group policy
     * with those from local store instead of ignoring the local store rules. When
     * AuthorizedApplicationRulesFromGroupPolicyNotMerged and
     * AuthorizedApplicationRulesFromGroupPolicyMerged are both true,
     * AuthorizedApplicationRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property authorizedApplicationRulesFromGroupPolicyMerged
     */
    @Property(name="authorizedApplicationRulesFromGroupPolicyMerged")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedApplicationRulesFromGroupPolicyMerged() {
        return Optional.ofNullable(authorizedApplicationRulesFromGroupPolicyMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedApplicationRulesFromGroupPolicyMerged} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to merge authorized application rules from group policy
     * with those from local store instead of ignoring the local store rules. When
     * AuthorizedApplicationRulesFromGroupPolicyNotMerged and
     * AuthorizedApplicationRulesFromGroupPolicyMerged are both true,
     * AuthorizedApplicationRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param authorizedApplicationRulesFromGroupPolicyMerged
     *            new value of {@code authorizedApplicationRulesFromGroupPolicyMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedApplicationRulesFromGroupPolicyMerged} field changed
     */
    public WindowsFirewallNetworkProfile withAuthorizedApplicationRulesFromGroupPolicyMerged(Boolean authorizedApplicationRulesFromGroupPolicyMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.authorizedApplicationRulesFromGroupPolicyMerged = authorizedApplicationRulesFromGroupPolicyMerged;
        return _x;
    }

    /**
     * <i>“Configures the firewall to prevent merging authorized application rules from
     * group policy with those from local store instead of ignoring the local store
     * rules. When AuthorizedApplicationRulesFromGroupPolicyNotMerged and
     * AuthorizedApplicationRulesFromGroupPolicyMerged are both true,
     * AuthorizedApplicationRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property authorizedApplicationRulesFromGroupPolicyNotMerged
     */
    @Property(name="authorizedApplicationRulesFromGroupPolicyNotMerged")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedApplicationRulesFromGroupPolicyNotMerged() {
        return Optional.ofNullable(authorizedApplicationRulesFromGroupPolicyNotMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedApplicationRulesFromGroupPolicyNotMerged} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to prevent merging authorized application rules from
     * group policy with those from local store instead of ignoring the local store
     * rules. When AuthorizedApplicationRulesFromGroupPolicyNotMerged and
     * AuthorizedApplicationRulesFromGroupPolicyMerged are both true,
     * AuthorizedApplicationRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param authorizedApplicationRulesFromGroupPolicyNotMerged
     *            new value of {@code authorizedApplicationRulesFromGroupPolicyNotMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedApplicationRulesFromGroupPolicyNotMerged} field changed
     */
    public WindowsFirewallNetworkProfile withAuthorizedApplicationRulesFromGroupPolicyNotMerged(Boolean authorizedApplicationRulesFromGroupPolicyNotMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.authorizedApplicationRulesFromGroupPolicyNotMerged = authorizedApplicationRulesFromGroupPolicyNotMerged;
        return _x;
    }

    /**
     * <i>“Configures the firewall to merge connection security rules from group policy
     * with those from local store instead of ignoring the local store rules. When
     * ConnectionSecurityRulesFromGroupPolicyNotMerged and
     * ConnectionSecurityRulesFromGroupPolicyMerged are both true,
     * ConnectionSecurityRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property connectionSecurityRulesFromGroupPolicyMerged
     */
    @Property(name="connectionSecurityRulesFromGroupPolicyMerged")
    @JsonIgnore
    public Optional<Boolean> getConnectionSecurityRulesFromGroupPolicyMerged() {
        return Optional.ofNullable(connectionSecurityRulesFromGroupPolicyMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectionSecurityRulesFromGroupPolicyMerged} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to merge connection security rules from group policy
     * with those from local store instead of ignoring the local store rules. When
     * ConnectionSecurityRulesFromGroupPolicyNotMerged and
     * ConnectionSecurityRulesFromGroupPolicyMerged are both true,
     * ConnectionSecurityRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param connectionSecurityRulesFromGroupPolicyMerged
     *            new value of {@code connectionSecurityRulesFromGroupPolicyMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionSecurityRulesFromGroupPolicyMerged} field changed
     */
    public WindowsFirewallNetworkProfile withConnectionSecurityRulesFromGroupPolicyMerged(Boolean connectionSecurityRulesFromGroupPolicyMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.connectionSecurityRulesFromGroupPolicyMerged = connectionSecurityRulesFromGroupPolicyMerged;
        return _x;
    }

    /**
     * <i>“Configures the firewall to prevent merging connection security rules from group
     * policy with those from local store instead of ignoring the local store rules.
     * When ConnectionSecurityRulesFromGroupPolicyNotMerged and
     * ConnectionSecurityRulesFromGroupPolicyMerged are both true,
     * ConnectionSecurityRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property connectionSecurityRulesFromGroupPolicyNotMerged
     */
    @Property(name="connectionSecurityRulesFromGroupPolicyNotMerged")
    @JsonIgnore
    public Optional<Boolean> getConnectionSecurityRulesFromGroupPolicyNotMerged() {
        return Optional.ofNullable(connectionSecurityRulesFromGroupPolicyNotMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectionSecurityRulesFromGroupPolicyNotMerged} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to prevent merging connection security rules from group
     * policy with those from local store instead of ignoring the local store rules.
     * When ConnectionSecurityRulesFromGroupPolicyNotMerged and
     * ConnectionSecurityRulesFromGroupPolicyMerged are both true,
     * ConnectionSecurityRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param connectionSecurityRulesFromGroupPolicyNotMerged
     *            new value of {@code connectionSecurityRulesFromGroupPolicyNotMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionSecurityRulesFromGroupPolicyNotMerged} field changed
     */
    public WindowsFirewallNetworkProfile withConnectionSecurityRulesFromGroupPolicyNotMerged(Boolean connectionSecurityRulesFromGroupPolicyNotMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.connectionSecurityRulesFromGroupPolicyNotMerged = connectionSecurityRulesFromGroupPolicyNotMerged;
        return _x;
    }

    /**
     * <i>“Configures the host device to allow or block the firewall and advanced security
     * enforcement for the network profile.”</i>
     * 
     * @return property firewallEnabled
     */
    @Property(name="firewallEnabled")
    @JsonIgnore
    public Optional<StateManagementSetting> getFirewallEnabled() {
        return Optional.ofNullable(firewallEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code firewallEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Configures the host device to allow or block the firewall and advanced security
     * enforcement for the network profile.”</i>
     * 
     * @param firewallEnabled
     *            new value of {@code firewallEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallEnabled} field changed
     */
    public WindowsFirewallNetworkProfile withFirewallEnabled(StateManagementSetting firewallEnabled) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.firewallEnabled = firewallEnabled;
        return _x;
    }

    /**
     * <i>“Configures the firewall to merge global port rules from group policy with those
     * from local store instead of ignoring the local store rules. When
     * GlobalPortRulesFromGroupPolicyNotMerged and GlobalPortRulesFromGroupPolicyMerged
     * are both true, GlobalPortRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property globalPortRulesFromGroupPolicyMerged
     */
    @Property(name="globalPortRulesFromGroupPolicyMerged")
    @JsonIgnore
    public Optional<Boolean> getGlobalPortRulesFromGroupPolicyMerged() {
        return Optional.ofNullable(globalPortRulesFromGroupPolicyMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * globalPortRulesFromGroupPolicyMerged} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to merge global port rules from group policy with those
     * from local store instead of ignoring the local store rules. When
     * GlobalPortRulesFromGroupPolicyNotMerged and GlobalPortRulesFromGroupPolicyMerged
     * are both true, GlobalPortRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param globalPortRulesFromGroupPolicyMerged
     *            new value of {@code globalPortRulesFromGroupPolicyMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code globalPortRulesFromGroupPolicyMerged} field changed
     */
    public WindowsFirewallNetworkProfile withGlobalPortRulesFromGroupPolicyMerged(Boolean globalPortRulesFromGroupPolicyMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.globalPortRulesFromGroupPolicyMerged = globalPortRulesFromGroupPolicyMerged;
        return _x;
    }

    /**
     * <i>“Configures the firewall to prevent merging global port rules from group policy
     * with those from local store instead of ignoring the local store rules. When
     * GlobalPortRulesFromGroupPolicyNotMerged and GlobalPortRulesFromGroupPolicyMerged
     * are both true, GlobalPortRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property globalPortRulesFromGroupPolicyNotMerged
     */
    @Property(name="globalPortRulesFromGroupPolicyNotMerged")
    @JsonIgnore
    public Optional<Boolean> getGlobalPortRulesFromGroupPolicyNotMerged() {
        return Optional.ofNullable(globalPortRulesFromGroupPolicyNotMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * globalPortRulesFromGroupPolicyNotMerged} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to prevent merging global port rules from group policy
     * with those from local store instead of ignoring the local store rules. When
     * GlobalPortRulesFromGroupPolicyNotMerged and GlobalPortRulesFromGroupPolicyMerged
     * are both true, GlobalPortRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param globalPortRulesFromGroupPolicyNotMerged
     *            new value of {@code globalPortRulesFromGroupPolicyNotMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code globalPortRulesFromGroupPolicyNotMerged} field changed
     */
    public WindowsFirewallNetworkProfile withGlobalPortRulesFromGroupPolicyNotMerged(Boolean globalPortRulesFromGroupPolicyNotMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.globalPortRulesFromGroupPolicyNotMerged = globalPortRulesFromGroupPolicyNotMerged;
        return _x;
    }

    /**
     * <i>“Configures the firewall to block all incoming connections by default. When
     * InboundConnectionsRequired and InboundConnectionsBlocked are both true,
     * InboundConnectionsBlocked takes priority.”</i>
     * 
     * @return property inboundConnectionsBlocked
     */
    @Property(name="inboundConnectionsBlocked")
    @JsonIgnore
    public Optional<Boolean> getInboundConnectionsBlocked() {
        return Optional.ofNullable(inboundConnectionsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inboundConnectionsBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to block all incoming connections by default. When
     * InboundConnectionsRequired and InboundConnectionsBlocked are both true,
     * InboundConnectionsBlocked takes priority.”</i>
     * 
     * @param inboundConnectionsBlocked
     *            new value of {@code inboundConnectionsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inboundConnectionsBlocked} field changed
     */
    public WindowsFirewallNetworkProfile withInboundConnectionsBlocked(Boolean inboundConnectionsBlocked) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.inboundConnectionsBlocked = inboundConnectionsBlocked;
        return _x;
    }

    /**
     * <i>“Configures the firewall to allow all incoming connections by default. When
     * InboundConnectionsRequired and InboundConnectionsBlocked are both true,
     * InboundConnectionsBlocked takes priority.”</i>
     * 
     * @return property inboundConnectionsRequired
     */
    @Property(name="inboundConnectionsRequired")
    @JsonIgnore
    public Optional<Boolean> getInboundConnectionsRequired() {
        return Optional.ofNullable(inboundConnectionsRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inboundConnectionsRequired} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to allow all incoming connections by default. When
     * InboundConnectionsRequired and InboundConnectionsBlocked are both true,
     * InboundConnectionsBlocked takes priority.”</i>
     * 
     * @param inboundConnectionsRequired
     *            new value of {@code inboundConnectionsRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inboundConnectionsRequired} field changed
     */
    public WindowsFirewallNetworkProfile withInboundConnectionsRequired(Boolean inboundConnectionsRequired) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.inboundConnectionsRequired = inboundConnectionsRequired;
        return _x;
    }

    /**
     * <i>“Prevents the firewall from displaying notifications when an application is
     * blocked from listening on a port. When InboundNotificationsRequired and
     * InboundNotificationsBlocked are both true, InboundNotificationsBlocked takes
     * priority.”</i>
     * 
     * @return property inboundNotificationsBlocked
     */
    @Property(name="inboundNotificationsBlocked")
    @JsonIgnore
    public Optional<Boolean> getInboundNotificationsBlocked() {
        return Optional.ofNullable(inboundNotificationsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inboundNotificationsBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Prevents the firewall from displaying notifications when an application is
     * blocked from listening on a port. When InboundNotificationsRequired and
     * InboundNotificationsBlocked are both true, InboundNotificationsBlocked takes
     * priority.”</i>
     * 
     * @param inboundNotificationsBlocked
     *            new value of {@code inboundNotificationsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inboundNotificationsBlocked} field changed
     */
    public WindowsFirewallNetworkProfile withInboundNotificationsBlocked(Boolean inboundNotificationsBlocked) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.inboundNotificationsBlocked = inboundNotificationsBlocked;
        return _x;
    }

    /**
     * <i>“Allows the firewall to display notifications when an application is blocked from
     * listening on a port. When InboundNotificationsRequired and
     * InboundNotificationsBlocked are both true, InboundNotificationsBlocked takes
     * priority.”</i>
     * 
     * @return property inboundNotificationsRequired
     */
    @Property(name="inboundNotificationsRequired")
    @JsonIgnore
    public Optional<Boolean> getInboundNotificationsRequired() {
        return Optional.ofNullable(inboundNotificationsRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inboundNotificationsRequired} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows the firewall to display notifications when an application is blocked from
     * listening on a port. When InboundNotificationsRequired and
     * InboundNotificationsBlocked are both true, InboundNotificationsBlocked takes
     * priority.”</i>
     * 
     * @param inboundNotificationsRequired
     *            new value of {@code inboundNotificationsRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inboundNotificationsRequired} field changed
     */
    public WindowsFirewallNetworkProfile withInboundNotificationsRequired(Boolean inboundNotificationsRequired) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.inboundNotificationsRequired = inboundNotificationsRequired;
        return _x;
    }

    /**
     * <i>“Configures the firewall to block all incoming traffic regardless of other policy
     * settings. When IncomingTrafficRequired and IncomingTrafficBlocked are both true,
     * IncomingTrafficBlocked takes priority.”</i>
     * 
     * @return property incomingTrafficBlocked
     */
    @Property(name="incomingTrafficBlocked")
    @JsonIgnore
    public Optional<Boolean> getIncomingTrafficBlocked() {
        return Optional.ofNullable(incomingTrafficBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * incomingTrafficBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to block all incoming traffic regardless of other policy
     * settings. When IncomingTrafficRequired and IncomingTrafficBlocked are both true,
     * IncomingTrafficBlocked takes priority.”</i>
     * 
     * @param incomingTrafficBlocked
     *            new value of {@code incomingTrafficBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code incomingTrafficBlocked} field changed
     */
    public WindowsFirewallNetworkProfile withIncomingTrafficBlocked(Boolean incomingTrafficBlocked) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.incomingTrafficBlocked = incomingTrafficBlocked;
        return _x;
    }

    /**
     * <i>“Configures the firewall to allow incoming traffic pursuant to other policy
     * settings. When IncomingTrafficRequired and IncomingTrafficBlocked are both true,
     * IncomingTrafficBlocked takes priority.”</i>
     * 
     * @return property incomingTrafficRequired
     */
    @Property(name="incomingTrafficRequired")
    @JsonIgnore
    public Optional<Boolean> getIncomingTrafficRequired() {
        return Optional.ofNullable(incomingTrafficRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * incomingTrafficRequired} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to allow incoming traffic pursuant to other policy
     * settings. When IncomingTrafficRequired and IncomingTrafficBlocked are both true,
     * IncomingTrafficBlocked takes priority.”</i>
     * 
     * @param incomingTrafficRequired
     *            new value of {@code incomingTrafficRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code incomingTrafficRequired} field changed
     */
    public WindowsFirewallNetworkProfile withIncomingTrafficRequired(Boolean incomingTrafficRequired) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.incomingTrafficRequired = incomingTrafficRequired;
        return _x;
    }

    /**
     * <i>“Configures the firewall to block all outgoing connections by default. When
     * OutboundConnectionsRequired and OutboundConnectionsBlocked are both true,
     * OutboundConnectionsBlocked takes priority. This setting will get applied to
     * Windows releases version 1809 and above.”</i>
     * 
     * @return property outboundConnectionsBlocked
     */
    @Property(name="outboundConnectionsBlocked")
    @JsonIgnore
    public Optional<Boolean> getOutboundConnectionsBlocked() {
        return Optional.ofNullable(outboundConnectionsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outboundConnectionsBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to block all outgoing connections by default. When
     * OutboundConnectionsRequired and OutboundConnectionsBlocked are both true,
     * OutboundConnectionsBlocked takes priority. This setting will get applied to
     * Windows releases version 1809 and above.”</i>
     * 
     * @param outboundConnectionsBlocked
     *            new value of {@code outboundConnectionsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outboundConnectionsBlocked} field changed
     */
    public WindowsFirewallNetworkProfile withOutboundConnectionsBlocked(Boolean outboundConnectionsBlocked) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.outboundConnectionsBlocked = outboundConnectionsBlocked;
        return _x;
    }

    /**
     * <i>“Configures the firewall to allow all outgoing connections by default. When
     * OutboundConnectionsRequired and OutboundConnectionsBlocked are both true,
     * OutboundConnectionsBlocked takes priority. This setting will get applied to
     * Windows releases version 1809 and above.”</i>
     * 
     * @return property outboundConnectionsRequired
     */
    @Property(name="outboundConnectionsRequired")
    @JsonIgnore
    public Optional<Boolean> getOutboundConnectionsRequired() {
        return Optional.ofNullable(outboundConnectionsRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outboundConnectionsRequired} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to allow all outgoing connections by default. When
     * OutboundConnectionsRequired and OutboundConnectionsBlocked are both true,
     * OutboundConnectionsBlocked takes priority. This setting will get applied to
     * Windows releases version 1809 and above.”</i>
     * 
     * @param outboundConnectionsRequired
     *            new value of {@code outboundConnectionsRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outboundConnectionsRequired} field changed
     */
    public WindowsFirewallNetworkProfile withOutboundConnectionsRequired(Boolean outboundConnectionsRequired) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.outboundConnectionsRequired = outboundConnectionsRequired;
        return _x;
    }

    /**
     * <i>“Configures the firewall to merge Firewall Rule policies from group policy with
     * those from local store instead of ignoring the local store rules. When
     * PolicyRulesFromGroupPolicyNotMerged and PolicyRulesFromGroupPolicyMerged are
     * both true, PolicyRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property policyRulesFromGroupPolicyMerged
     */
    @Property(name="policyRulesFromGroupPolicyMerged")
    @JsonIgnore
    public Optional<Boolean> getPolicyRulesFromGroupPolicyMerged() {
        return Optional.ofNullable(policyRulesFromGroupPolicyMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * policyRulesFromGroupPolicyMerged} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to merge Firewall Rule policies from group policy with
     * those from local store instead of ignoring the local store rules. When
     * PolicyRulesFromGroupPolicyNotMerged and PolicyRulesFromGroupPolicyMerged are
     * both true, PolicyRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param policyRulesFromGroupPolicyMerged
     *            new value of {@code policyRulesFromGroupPolicyMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyRulesFromGroupPolicyMerged} field changed
     */
    public WindowsFirewallNetworkProfile withPolicyRulesFromGroupPolicyMerged(Boolean policyRulesFromGroupPolicyMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.policyRulesFromGroupPolicyMerged = policyRulesFromGroupPolicyMerged;
        return _x;
    }

    /**
     * <i>“Configures the firewall to prevent merging Firewall Rule policies from group
     * policy with those from local store instead of ignoring the local store rules.
     * When PolicyRulesFromGroupPolicyNotMerged and PolicyRulesFromGroupPolicyMerged
     * are both true, PolicyRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @return property policyRulesFromGroupPolicyNotMerged
     */
    @Property(name="policyRulesFromGroupPolicyNotMerged")
    @JsonIgnore
    public Optional<Boolean> getPolicyRulesFromGroupPolicyNotMerged() {
        return Optional.ofNullable(policyRulesFromGroupPolicyNotMerged);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * policyRulesFromGroupPolicyNotMerged} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to prevent merging Firewall Rule policies from group
     * policy with those from local store instead of ignoring the local store rules.
     * When PolicyRulesFromGroupPolicyNotMerged and PolicyRulesFromGroupPolicyMerged
     * are both true, PolicyRulesFromGroupPolicyMerged takes priority.”</i>
     * 
     * @param policyRulesFromGroupPolicyNotMerged
     *            new value of {@code policyRulesFromGroupPolicyNotMerged} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyRulesFromGroupPolicyNotMerged} field changed
     */
    public WindowsFirewallNetworkProfile withPolicyRulesFromGroupPolicyNotMerged(Boolean policyRulesFromGroupPolicyNotMerged) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.policyRulesFromGroupPolicyNotMerged = policyRulesFromGroupPolicyNotMerged;
        return _x;
    }

    /**
     * <i>“Configures the firewall to allow the host computer to respond to unsolicited
     * network traffic of that traffic is secured by IPSec even when stealthModeBlocked
     * is set to true. When SecuredPacketExemptionBlocked and
     * SecuredPacketExemptionAllowed are both true, SecuredPacketExemptionAllowed takes
     * priority.”</i>
     * 
     * @return property securedPacketExemptionAllowed
     */
    @Property(name="securedPacketExemptionAllowed")
    @JsonIgnore
    public Optional<Boolean> getSecuredPacketExemptionAllowed() {
        return Optional.ofNullable(securedPacketExemptionAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securedPacketExemptionAllowed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to allow the host computer to respond to unsolicited
     * network traffic of that traffic is secured by IPSec even when stealthModeBlocked
     * is set to true. When SecuredPacketExemptionBlocked and
     * SecuredPacketExemptionAllowed are both true, SecuredPacketExemptionAllowed takes
     * priority.”</i>
     * 
     * @param securedPacketExemptionAllowed
     *            new value of {@code securedPacketExemptionAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securedPacketExemptionAllowed} field changed
     */
    public WindowsFirewallNetworkProfile withSecuredPacketExemptionAllowed(Boolean securedPacketExemptionAllowed) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.securedPacketExemptionAllowed = securedPacketExemptionAllowed;
        return _x;
    }

    /**
     * <i>“Configures the firewall to block the host computer to respond to unsolicited
     * network traffic of that traffic is secured by IPSec even when stealthModeBlocked
     * is set to true. When SecuredPacketExemptionBlocked and
     * SecuredPacketExemptionAllowed are both true, SecuredPacketExemptionAllowed takes
     * priority.”</i>
     * 
     * @return property securedPacketExemptionBlocked
     */
    @Property(name="securedPacketExemptionBlocked")
    @JsonIgnore
    public Optional<Boolean> getSecuredPacketExemptionBlocked() {
        return Optional.ofNullable(securedPacketExemptionBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securedPacketExemptionBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to block the host computer to respond to unsolicited
     * network traffic of that traffic is secured by IPSec even when stealthModeBlocked
     * is set to true. When SecuredPacketExemptionBlocked and
     * SecuredPacketExemptionAllowed are both true, SecuredPacketExemptionAllowed takes
     * priority.”</i>
     * 
     * @param securedPacketExemptionBlocked
     *            new value of {@code securedPacketExemptionBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securedPacketExemptionBlocked} field changed
     */
    public WindowsFirewallNetworkProfile withSecuredPacketExemptionBlocked(Boolean securedPacketExemptionBlocked) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.securedPacketExemptionBlocked = securedPacketExemptionBlocked;
        return _x;
    }

    /**
     * <i>“Prevent the server from operating in stealth mode. When StealthModeRequired and
     * StealthModeBlocked are both true, StealthModeBlocked takes priority.”</i>
     * 
     * @return property stealthModeBlocked
     */
    @Property(name="stealthModeBlocked")
    @JsonIgnore
    public Optional<Boolean> getStealthModeBlocked() {
        return Optional.ofNullable(stealthModeBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * stealthModeBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Prevent the server from operating in stealth mode. When StealthModeRequired and
     * StealthModeBlocked are both true, StealthModeBlocked takes priority.”</i>
     * 
     * @param stealthModeBlocked
     *            new value of {@code stealthModeBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code stealthModeBlocked} field changed
     */
    public WindowsFirewallNetworkProfile withStealthModeBlocked(Boolean stealthModeBlocked) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.stealthModeBlocked = stealthModeBlocked;
        return _x;
    }

    /**
     * <i>“Allow the server to operate in stealth mode. When StealthModeRequired and
     * StealthModeBlocked are both true, StealthModeBlocked takes priority.”</i>
     * 
     * @return property stealthModeRequired
     */
    @Property(name="stealthModeRequired")
    @JsonIgnore
    public Optional<Boolean> getStealthModeRequired() {
        return Optional.ofNullable(stealthModeRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * stealthModeRequired} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allow the server to operate in stealth mode. When StealthModeRequired and
     * StealthModeBlocked are both true, StealthModeBlocked takes priority.”</i>
     * 
     * @param stealthModeRequired
     *            new value of {@code stealthModeRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code stealthModeRequired} field changed
     */
    public WindowsFirewallNetworkProfile withStealthModeRequired(Boolean stealthModeRequired) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.stealthModeRequired = stealthModeRequired;
        return _x;
    }

    /**
     * <i>“Configures the firewall to block unicast responses to multicast broadcast
     * traffic. When UnicastResponsesToMulticastBroadcastsRequired and
     * UnicastResponsesToMulticastBroadcastsBlocked are both true,
     * UnicastResponsesToMulticastBroadcastsBlocked takes priority.”</i>
     * 
     * @return property unicastResponsesToMulticastBroadcastsBlocked
     */
    @Property(name="unicastResponsesToMulticastBroadcastsBlocked")
    @JsonIgnore
    public Optional<Boolean> getUnicastResponsesToMulticastBroadcastsBlocked() {
        return Optional.ofNullable(unicastResponsesToMulticastBroadcastsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unicastResponsesToMulticastBroadcastsBlocked} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to block unicast responses to multicast broadcast
     * traffic. When UnicastResponsesToMulticastBroadcastsRequired and
     * UnicastResponsesToMulticastBroadcastsBlocked are both true,
     * UnicastResponsesToMulticastBroadcastsBlocked takes priority.”</i>
     * 
     * @param unicastResponsesToMulticastBroadcastsBlocked
     *            new value of {@code unicastResponsesToMulticastBroadcastsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unicastResponsesToMulticastBroadcastsBlocked} field changed
     */
    public WindowsFirewallNetworkProfile withUnicastResponsesToMulticastBroadcastsBlocked(Boolean unicastResponsesToMulticastBroadcastsBlocked) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.unicastResponsesToMulticastBroadcastsBlocked = unicastResponsesToMulticastBroadcastsBlocked;
        return _x;
    }

    /**
     * <i>“Configures the firewall to allow unicast responses to multicast broadcast
     * traffic. When UnicastResponsesToMulticastBroadcastsRequired and
     * UnicastResponsesToMulticastBroadcastsBlocked are both true,
     * UnicastResponsesToMulticastBroadcastsBlocked takes priority.”</i>
     * 
     * @return property unicastResponsesToMulticastBroadcastsRequired
     */
    @Property(name="unicastResponsesToMulticastBroadcastsRequired")
    @JsonIgnore
    public Optional<Boolean> getUnicastResponsesToMulticastBroadcastsRequired() {
        return Optional.ofNullable(unicastResponsesToMulticastBroadcastsRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unicastResponsesToMulticastBroadcastsRequired} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall to allow unicast responses to multicast broadcast
     * traffic. When UnicastResponsesToMulticastBroadcastsRequired and
     * UnicastResponsesToMulticastBroadcastsBlocked are both true,
     * UnicastResponsesToMulticastBroadcastsBlocked takes priority.”</i>
     * 
     * @param unicastResponsesToMulticastBroadcastsRequired
     *            new value of {@code unicastResponsesToMulticastBroadcastsRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unicastResponsesToMulticastBroadcastsRequired} field changed
     */
    public WindowsFirewallNetworkProfile withUnicastResponsesToMulticastBroadcastsRequired(Boolean unicastResponsesToMulticastBroadcastsRequired) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFirewallNetworkProfile");
        _x.unicastResponsesToMulticastBroadcastsRequired = unicastResponsesToMulticastBroadcastsRequired;
        return _x;
    }

    public WindowsFirewallNetworkProfile withUnmappedField(String name, Object value) {
        WindowsFirewallNetworkProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean authorizedApplicationRulesFromGroupPolicyMerged;
        private Boolean authorizedApplicationRulesFromGroupPolicyNotMerged;
        private Boolean connectionSecurityRulesFromGroupPolicyMerged;
        private Boolean connectionSecurityRulesFromGroupPolicyNotMerged;
        private StateManagementSetting firewallEnabled;
        private Boolean globalPortRulesFromGroupPolicyMerged;
        private Boolean globalPortRulesFromGroupPolicyNotMerged;
        private Boolean inboundConnectionsBlocked;
        private Boolean inboundConnectionsRequired;
        private Boolean inboundNotificationsBlocked;
        private Boolean inboundNotificationsRequired;
        private Boolean incomingTrafficBlocked;
        private Boolean incomingTrafficRequired;
        private Boolean outboundConnectionsBlocked;
        private Boolean outboundConnectionsRequired;
        private Boolean policyRulesFromGroupPolicyMerged;
        private Boolean policyRulesFromGroupPolicyNotMerged;
        private Boolean securedPacketExemptionAllowed;
        private Boolean securedPacketExemptionBlocked;
        private Boolean stealthModeBlocked;
        private Boolean stealthModeRequired;
        private Boolean unicastResponsesToMulticastBroadcastsBlocked;
        private Boolean unicastResponsesToMulticastBroadcastsRequired;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Configures the firewall to merge authorized application rules from group policy
         * with those from local store instead of ignoring the local store rules. When
         * AuthorizedApplicationRulesFromGroupPolicyNotMerged and
         * AuthorizedApplicationRulesFromGroupPolicyMerged are both true,
         * AuthorizedApplicationRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param authorizedApplicationRulesFromGroupPolicyMerged
         *            value of {@code authorizedApplicationRulesFromGroupPolicyMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedApplicationRulesFromGroupPolicyMerged(Boolean authorizedApplicationRulesFromGroupPolicyMerged) {
            this.authorizedApplicationRulesFromGroupPolicyMerged = authorizedApplicationRulesFromGroupPolicyMerged;
            this.changedFields = changedFields.add("authorizedApplicationRulesFromGroupPolicyMerged");
            return this;
        }

        /**
         * <i>“Configures the firewall to prevent merging authorized application rules from
         * group policy with those from local store instead of ignoring the local store
         * rules. When AuthorizedApplicationRulesFromGroupPolicyNotMerged and
         * AuthorizedApplicationRulesFromGroupPolicyMerged are both true,
         * AuthorizedApplicationRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param authorizedApplicationRulesFromGroupPolicyNotMerged
         *            value of {@code authorizedApplicationRulesFromGroupPolicyNotMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedApplicationRulesFromGroupPolicyNotMerged(Boolean authorizedApplicationRulesFromGroupPolicyNotMerged) {
            this.authorizedApplicationRulesFromGroupPolicyNotMerged = authorizedApplicationRulesFromGroupPolicyNotMerged;
            this.changedFields = changedFields.add("authorizedApplicationRulesFromGroupPolicyNotMerged");
            return this;
        }

        /**
         * <i>“Configures the firewall to merge connection security rules from group policy
         * with those from local store instead of ignoring the local store rules. When
         * ConnectionSecurityRulesFromGroupPolicyNotMerged and
         * ConnectionSecurityRulesFromGroupPolicyMerged are both true,
         * ConnectionSecurityRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param connectionSecurityRulesFromGroupPolicyMerged
         *            value of {@code connectionSecurityRulesFromGroupPolicyMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionSecurityRulesFromGroupPolicyMerged(Boolean connectionSecurityRulesFromGroupPolicyMerged) {
            this.connectionSecurityRulesFromGroupPolicyMerged = connectionSecurityRulesFromGroupPolicyMerged;
            this.changedFields = changedFields.add("connectionSecurityRulesFromGroupPolicyMerged");
            return this;
        }

        /**
         * <i>“Configures the firewall to prevent merging connection security rules from group
         * policy with those from local store instead of ignoring the local store rules.
         * When ConnectionSecurityRulesFromGroupPolicyNotMerged and
         * ConnectionSecurityRulesFromGroupPolicyMerged are both true,
         * ConnectionSecurityRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param connectionSecurityRulesFromGroupPolicyNotMerged
         *            value of {@code connectionSecurityRulesFromGroupPolicyNotMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionSecurityRulesFromGroupPolicyNotMerged(Boolean connectionSecurityRulesFromGroupPolicyNotMerged) {
            this.connectionSecurityRulesFromGroupPolicyNotMerged = connectionSecurityRulesFromGroupPolicyNotMerged;
            this.changedFields = changedFields.add("connectionSecurityRulesFromGroupPolicyNotMerged");
            return this;
        }

        /**
         * <i>“Configures the host device to allow or block the firewall and advanced security
         * enforcement for the network profile.”</i>
         * 
         * @param firewallEnabled
         *            value of {@code firewallEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallEnabled(StateManagementSetting firewallEnabled) {
            this.firewallEnabled = firewallEnabled;
            this.changedFields = changedFields.add("firewallEnabled");
            return this;
        }

        /**
         * <i>“Configures the firewall to merge global port rules from group policy with those
         * from local store instead of ignoring the local store rules. When
         * GlobalPortRulesFromGroupPolicyNotMerged and GlobalPortRulesFromGroupPolicyMerged
         * are both true, GlobalPortRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param globalPortRulesFromGroupPolicyMerged
         *            value of {@code globalPortRulesFromGroupPolicyMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder globalPortRulesFromGroupPolicyMerged(Boolean globalPortRulesFromGroupPolicyMerged) {
            this.globalPortRulesFromGroupPolicyMerged = globalPortRulesFromGroupPolicyMerged;
            this.changedFields = changedFields.add("globalPortRulesFromGroupPolicyMerged");
            return this;
        }

        /**
         * <i>“Configures the firewall to prevent merging global port rules from group policy
         * with those from local store instead of ignoring the local store rules. When
         * GlobalPortRulesFromGroupPolicyNotMerged and GlobalPortRulesFromGroupPolicyMerged
         * are both true, GlobalPortRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param globalPortRulesFromGroupPolicyNotMerged
         *            value of {@code globalPortRulesFromGroupPolicyNotMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder globalPortRulesFromGroupPolicyNotMerged(Boolean globalPortRulesFromGroupPolicyNotMerged) {
            this.globalPortRulesFromGroupPolicyNotMerged = globalPortRulesFromGroupPolicyNotMerged;
            this.changedFields = changedFields.add("globalPortRulesFromGroupPolicyNotMerged");
            return this;
        }

        /**
         * <i>“Configures the firewall to block all incoming connections by default. When
         * InboundConnectionsRequired and InboundConnectionsBlocked are both true,
         * InboundConnectionsBlocked takes priority.”</i>
         * 
         * @param inboundConnectionsBlocked
         *            value of {@code inboundConnectionsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inboundConnectionsBlocked(Boolean inboundConnectionsBlocked) {
            this.inboundConnectionsBlocked = inboundConnectionsBlocked;
            this.changedFields = changedFields.add("inboundConnectionsBlocked");
            return this;
        }

        /**
         * <i>“Configures the firewall to allow all incoming connections by default. When
         * InboundConnectionsRequired and InboundConnectionsBlocked are both true,
         * InboundConnectionsBlocked takes priority.”</i>
         * 
         * @param inboundConnectionsRequired
         *            value of {@code inboundConnectionsRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inboundConnectionsRequired(Boolean inboundConnectionsRequired) {
            this.inboundConnectionsRequired = inboundConnectionsRequired;
            this.changedFields = changedFields.add("inboundConnectionsRequired");
            return this;
        }

        /**
         * <i>“Prevents the firewall from displaying notifications when an application is
         * blocked from listening on a port. When InboundNotificationsRequired and
         * InboundNotificationsBlocked are both true, InboundNotificationsBlocked takes
         * priority.”</i>
         * 
         * @param inboundNotificationsBlocked
         *            value of {@code inboundNotificationsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inboundNotificationsBlocked(Boolean inboundNotificationsBlocked) {
            this.inboundNotificationsBlocked = inboundNotificationsBlocked;
            this.changedFields = changedFields.add("inboundNotificationsBlocked");
            return this;
        }

        /**
         * <i>“Allows the firewall to display notifications when an application is blocked from
         * listening on a port. When InboundNotificationsRequired and
         * InboundNotificationsBlocked are both true, InboundNotificationsBlocked takes
         * priority.”</i>
         * 
         * @param inboundNotificationsRequired
         *            value of {@code inboundNotificationsRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inboundNotificationsRequired(Boolean inboundNotificationsRequired) {
            this.inboundNotificationsRequired = inboundNotificationsRequired;
            this.changedFields = changedFields.add("inboundNotificationsRequired");
            return this;
        }

        /**
         * <i>“Configures the firewall to block all incoming traffic regardless of other policy
         * settings. When IncomingTrafficRequired and IncomingTrafficBlocked are both true,
         * IncomingTrafficBlocked takes priority.”</i>
         * 
         * @param incomingTrafficBlocked
         *            value of {@code incomingTrafficBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder incomingTrafficBlocked(Boolean incomingTrafficBlocked) {
            this.incomingTrafficBlocked = incomingTrafficBlocked;
            this.changedFields = changedFields.add("incomingTrafficBlocked");
            return this;
        }

        /**
         * <i>“Configures the firewall to allow incoming traffic pursuant to other policy
         * settings. When IncomingTrafficRequired and IncomingTrafficBlocked are both true,
         * IncomingTrafficBlocked takes priority.”</i>
         * 
         * @param incomingTrafficRequired
         *            value of {@code incomingTrafficRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder incomingTrafficRequired(Boolean incomingTrafficRequired) {
            this.incomingTrafficRequired = incomingTrafficRequired;
            this.changedFields = changedFields.add("incomingTrafficRequired");
            return this;
        }

        /**
         * <i>“Configures the firewall to block all outgoing connections by default. When
         * OutboundConnectionsRequired and OutboundConnectionsBlocked are both true,
         * OutboundConnectionsBlocked takes priority. This setting will get applied to
         * Windows releases version 1809 and above.”</i>
         * 
         * @param outboundConnectionsBlocked
         *            value of {@code outboundConnectionsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outboundConnectionsBlocked(Boolean outboundConnectionsBlocked) {
            this.outboundConnectionsBlocked = outboundConnectionsBlocked;
            this.changedFields = changedFields.add("outboundConnectionsBlocked");
            return this;
        }

        /**
         * <i>“Configures the firewall to allow all outgoing connections by default. When
         * OutboundConnectionsRequired and OutboundConnectionsBlocked are both true,
         * OutboundConnectionsBlocked takes priority. This setting will get applied to
         * Windows releases version 1809 and above.”</i>
         * 
         * @param outboundConnectionsRequired
         *            value of {@code outboundConnectionsRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outboundConnectionsRequired(Boolean outboundConnectionsRequired) {
            this.outboundConnectionsRequired = outboundConnectionsRequired;
            this.changedFields = changedFields.add("outboundConnectionsRequired");
            return this;
        }

        /**
         * <i>“Configures the firewall to merge Firewall Rule policies from group policy with
         * those from local store instead of ignoring the local store rules. When
         * PolicyRulesFromGroupPolicyNotMerged and PolicyRulesFromGroupPolicyMerged are
         * both true, PolicyRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param policyRulesFromGroupPolicyMerged
         *            value of {@code policyRulesFromGroupPolicyMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyRulesFromGroupPolicyMerged(Boolean policyRulesFromGroupPolicyMerged) {
            this.policyRulesFromGroupPolicyMerged = policyRulesFromGroupPolicyMerged;
            this.changedFields = changedFields.add("policyRulesFromGroupPolicyMerged");
            return this;
        }

        /**
         * <i>“Configures the firewall to prevent merging Firewall Rule policies from group
         * policy with those from local store instead of ignoring the local store rules.
         * When PolicyRulesFromGroupPolicyNotMerged and PolicyRulesFromGroupPolicyMerged
         * are both true, PolicyRulesFromGroupPolicyMerged takes priority.”</i>
         * 
         * @param policyRulesFromGroupPolicyNotMerged
         *            value of {@code policyRulesFromGroupPolicyNotMerged} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyRulesFromGroupPolicyNotMerged(Boolean policyRulesFromGroupPolicyNotMerged) {
            this.policyRulesFromGroupPolicyNotMerged = policyRulesFromGroupPolicyNotMerged;
            this.changedFields = changedFields.add("policyRulesFromGroupPolicyNotMerged");
            return this;
        }

        /**
         * <i>“Configures the firewall to allow the host computer to respond to unsolicited
         * network traffic of that traffic is secured by IPSec even when stealthModeBlocked
         * is set to true. When SecuredPacketExemptionBlocked and
         * SecuredPacketExemptionAllowed are both true, SecuredPacketExemptionAllowed takes
         * priority.”</i>
         * 
         * @param securedPacketExemptionAllowed
         *            value of {@code securedPacketExemptionAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securedPacketExemptionAllowed(Boolean securedPacketExemptionAllowed) {
            this.securedPacketExemptionAllowed = securedPacketExemptionAllowed;
            this.changedFields = changedFields.add("securedPacketExemptionAllowed");
            return this;
        }

        /**
         * <i>“Configures the firewall to block the host computer to respond to unsolicited
         * network traffic of that traffic is secured by IPSec even when stealthModeBlocked
         * is set to true. When SecuredPacketExemptionBlocked and
         * SecuredPacketExemptionAllowed are both true, SecuredPacketExemptionAllowed takes
         * priority.”</i>
         * 
         * @param securedPacketExemptionBlocked
         *            value of {@code securedPacketExemptionBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securedPacketExemptionBlocked(Boolean securedPacketExemptionBlocked) {
            this.securedPacketExemptionBlocked = securedPacketExemptionBlocked;
            this.changedFields = changedFields.add("securedPacketExemptionBlocked");
            return this;
        }

        /**
         * <i>“Prevent the server from operating in stealth mode. When StealthModeRequired and
         * StealthModeBlocked are both true, StealthModeBlocked takes priority.”</i>
         * 
         * @param stealthModeBlocked
         *            value of {@code stealthModeBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stealthModeBlocked(Boolean stealthModeBlocked) {
            this.stealthModeBlocked = stealthModeBlocked;
            this.changedFields = changedFields.add("stealthModeBlocked");
            return this;
        }

        /**
         * <i>“Allow the server to operate in stealth mode. When StealthModeRequired and
         * StealthModeBlocked are both true, StealthModeBlocked takes priority.”</i>
         * 
         * @param stealthModeRequired
         *            value of {@code stealthModeRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stealthModeRequired(Boolean stealthModeRequired) {
            this.stealthModeRequired = stealthModeRequired;
            this.changedFields = changedFields.add("stealthModeRequired");
            return this;
        }

        /**
         * <i>“Configures the firewall to block unicast responses to multicast broadcast
         * traffic. When UnicastResponsesToMulticastBroadcastsRequired and
         * UnicastResponsesToMulticastBroadcastsBlocked are both true,
         * UnicastResponsesToMulticastBroadcastsBlocked takes priority.”</i>
         * 
         * @param unicastResponsesToMulticastBroadcastsBlocked
         *            value of {@code unicastResponsesToMulticastBroadcastsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unicastResponsesToMulticastBroadcastsBlocked(Boolean unicastResponsesToMulticastBroadcastsBlocked) {
            this.unicastResponsesToMulticastBroadcastsBlocked = unicastResponsesToMulticastBroadcastsBlocked;
            this.changedFields = changedFields.add("unicastResponsesToMulticastBroadcastsBlocked");
            return this;
        }

        /**
         * <i>“Configures the firewall to allow unicast responses to multicast broadcast
         * traffic. When UnicastResponsesToMulticastBroadcastsRequired and
         * UnicastResponsesToMulticastBroadcastsBlocked are both true,
         * UnicastResponsesToMulticastBroadcastsBlocked takes priority.”</i>
         * 
         * @param unicastResponsesToMulticastBroadcastsRequired
         *            value of {@code unicastResponsesToMulticastBroadcastsRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unicastResponsesToMulticastBroadcastsRequired(Boolean unicastResponsesToMulticastBroadcastsRequired) {
            this.unicastResponsesToMulticastBroadcastsRequired = unicastResponsesToMulticastBroadcastsRequired;
            this.changedFields = changedFields.add("unicastResponsesToMulticastBroadcastsRequired");
            return this;
        }

        public WindowsFirewallNetworkProfile build() {
            WindowsFirewallNetworkProfile _x = new WindowsFirewallNetworkProfile();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsFirewallNetworkProfile";
            _x.authorizedApplicationRulesFromGroupPolicyMerged = authorizedApplicationRulesFromGroupPolicyMerged;
            _x.authorizedApplicationRulesFromGroupPolicyNotMerged = authorizedApplicationRulesFromGroupPolicyNotMerged;
            _x.connectionSecurityRulesFromGroupPolicyMerged = connectionSecurityRulesFromGroupPolicyMerged;
            _x.connectionSecurityRulesFromGroupPolicyNotMerged = connectionSecurityRulesFromGroupPolicyNotMerged;
            _x.firewallEnabled = firewallEnabled;
            _x.globalPortRulesFromGroupPolicyMerged = globalPortRulesFromGroupPolicyMerged;
            _x.globalPortRulesFromGroupPolicyNotMerged = globalPortRulesFromGroupPolicyNotMerged;
            _x.inboundConnectionsBlocked = inboundConnectionsBlocked;
            _x.inboundConnectionsRequired = inboundConnectionsRequired;
            _x.inboundNotificationsBlocked = inboundNotificationsBlocked;
            _x.inboundNotificationsRequired = inboundNotificationsRequired;
            _x.incomingTrafficBlocked = incomingTrafficBlocked;
            _x.incomingTrafficRequired = incomingTrafficRequired;
            _x.outboundConnectionsBlocked = outboundConnectionsBlocked;
            _x.outboundConnectionsRequired = outboundConnectionsRequired;
            _x.policyRulesFromGroupPolicyMerged = policyRulesFromGroupPolicyMerged;
            _x.policyRulesFromGroupPolicyNotMerged = policyRulesFromGroupPolicyNotMerged;
            _x.securedPacketExemptionAllowed = securedPacketExemptionAllowed;
            _x.securedPacketExemptionBlocked = securedPacketExemptionBlocked;
            _x.stealthModeBlocked = stealthModeBlocked;
            _x.stealthModeRequired = stealthModeRequired;
            _x.unicastResponsesToMulticastBroadcastsBlocked = unicastResponsesToMulticastBroadcastsBlocked;
            _x.unicastResponsesToMulticastBroadcastsRequired = unicastResponsesToMulticastBroadcastsRequired;
            return _x;
        }
    }

    private WindowsFirewallNetworkProfile _copy() {
        WindowsFirewallNetworkProfile _x = new WindowsFirewallNetworkProfile();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.authorizedApplicationRulesFromGroupPolicyMerged = authorizedApplicationRulesFromGroupPolicyMerged;
        _x.authorizedApplicationRulesFromGroupPolicyNotMerged = authorizedApplicationRulesFromGroupPolicyNotMerged;
        _x.connectionSecurityRulesFromGroupPolicyMerged = connectionSecurityRulesFromGroupPolicyMerged;
        _x.connectionSecurityRulesFromGroupPolicyNotMerged = connectionSecurityRulesFromGroupPolicyNotMerged;
        _x.firewallEnabled = firewallEnabled;
        _x.globalPortRulesFromGroupPolicyMerged = globalPortRulesFromGroupPolicyMerged;
        _x.globalPortRulesFromGroupPolicyNotMerged = globalPortRulesFromGroupPolicyNotMerged;
        _x.inboundConnectionsBlocked = inboundConnectionsBlocked;
        _x.inboundConnectionsRequired = inboundConnectionsRequired;
        _x.inboundNotificationsBlocked = inboundNotificationsBlocked;
        _x.inboundNotificationsRequired = inboundNotificationsRequired;
        _x.incomingTrafficBlocked = incomingTrafficBlocked;
        _x.incomingTrafficRequired = incomingTrafficRequired;
        _x.outboundConnectionsBlocked = outboundConnectionsBlocked;
        _x.outboundConnectionsRequired = outboundConnectionsRequired;
        _x.policyRulesFromGroupPolicyMerged = policyRulesFromGroupPolicyMerged;
        _x.policyRulesFromGroupPolicyNotMerged = policyRulesFromGroupPolicyNotMerged;
        _x.securedPacketExemptionAllowed = securedPacketExemptionAllowed;
        _x.securedPacketExemptionBlocked = securedPacketExemptionBlocked;
        _x.stealthModeBlocked = stealthModeBlocked;
        _x.stealthModeRequired = stealthModeRequired;
        _x.unicastResponsesToMulticastBroadcastsBlocked = unicastResponsesToMulticastBroadcastsBlocked;
        _x.unicastResponsesToMulticastBroadcastsRequired = unicastResponsesToMulticastBroadcastsRequired;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsFirewallNetworkProfile[");
        b.append("authorizedApplicationRulesFromGroupPolicyMerged=");
        b.append(this.authorizedApplicationRulesFromGroupPolicyMerged);
        b.append(", ");
        b.append("authorizedApplicationRulesFromGroupPolicyNotMerged=");
        b.append(this.authorizedApplicationRulesFromGroupPolicyNotMerged);
        b.append(", ");
        b.append("connectionSecurityRulesFromGroupPolicyMerged=");
        b.append(this.connectionSecurityRulesFromGroupPolicyMerged);
        b.append(", ");
        b.append("connectionSecurityRulesFromGroupPolicyNotMerged=");
        b.append(this.connectionSecurityRulesFromGroupPolicyNotMerged);
        b.append(", ");
        b.append("firewallEnabled=");
        b.append(this.firewallEnabled);
        b.append(", ");
        b.append("globalPortRulesFromGroupPolicyMerged=");
        b.append(this.globalPortRulesFromGroupPolicyMerged);
        b.append(", ");
        b.append("globalPortRulesFromGroupPolicyNotMerged=");
        b.append(this.globalPortRulesFromGroupPolicyNotMerged);
        b.append(", ");
        b.append("inboundConnectionsBlocked=");
        b.append(this.inboundConnectionsBlocked);
        b.append(", ");
        b.append("inboundConnectionsRequired=");
        b.append(this.inboundConnectionsRequired);
        b.append(", ");
        b.append("inboundNotificationsBlocked=");
        b.append(this.inboundNotificationsBlocked);
        b.append(", ");
        b.append("inboundNotificationsRequired=");
        b.append(this.inboundNotificationsRequired);
        b.append(", ");
        b.append("incomingTrafficBlocked=");
        b.append(this.incomingTrafficBlocked);
        b.append(", ");
        b.append("incomingTrafficRequired=");
        b.append(this.incomingTrafficRequired);
        b.append(", ");
        b.append("outboundConnectionsBlocked=");
        b.append(this.outboundConnectionsBlocked);
        b.append(", ");
        b.append("outboundConnectionsRequired=");
        b.append(this.outboundConnectionsRequired);
        b.append(", ");
        b.append("policyRulesFromGroupPolicyMerged=");
        b.append(this.policyRulesFromGroupPolicyMerged);
        b.append(", ");
        b.append("policyRulesFromGroupPolicyNotMerged=");
        b.append(this.policyRulesFromGroupPolicyNotMerged);
        b.append(", ");
        b.append("securedPacketExemptionAllowed=");
        b.append(this.securedPacketExemptionAllowed);
        b.append(", ");
        b.append("securedPacketExemptionBlocked=");
        b.append(this.securedPacketExemptionBlocked);
        b.append(", ");
        b.append("stealthModeBlocked=");
        b.append(this.stealthModeBlocked);
        b.append(", ");
        b.append("stealthModeRequired=");
        b.append(this.stealthModeRequired);
        b.append(", ");
        b.append("unicastResponsesToMulticastBroadcastsBlocked=");
        b.append(this.unicastResponsesToMulticastBroadcastsBlocked);
        b.append(", ");
        b.append("unicastResponsesToMulticastBroadcastsRequired=");
        b.append(this.unicastResponsesToMulticastBroadcastsRequired);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
