package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Enrollment status screen setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowDeviceUseBeforeProfileAndAppInstallComplete", 
    "allowDeviceUseOnInstallFailure", 
    "allowLogCollectionOnInstallFailure", 
    "blockDeviceSetupRetryByUser", 
    "customErrorMessage", 
    "hideInstallationProgress", 
    "installProgressTimeoutInMinutes"})
@JsonInclude(Include.NON_NULL)
public class WindowsEnrollmentStatusScreenSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowDeviceUseBeforeProfileAndAppInstallComplete")
    protected Boolean allowDeviceUseBeforeProfileAndAppInstallComplete;

    @JsonProperty("allowDeviceUseOnInstallFailure")
    protected Boolean allowDeviceUseOnInstallFailure;

    @JsonProperty("allowLogCollectionOnInstallFailure")
    protected Boolean allowLogCollectionOnInstallFailure;

    @JsonProperty("blockDeviceSetupRetryByUser")
    protected Boolean blockDeviceSetupRetryByUser;

    @JsonProperty("customErrorMessage")
    protected String customErrorMessage;

    @JsonProperty("hideInstallationProgress")
    protected Boolean hideInstallationProgress;

    @JsonProperty("installProgressTimeoutInMinutes")
    protected Integer installProgressTimeoutInMinutes;

    protected WindowsEnrollmentStatusScreenSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsEnrollmentStatusScreenSettings";
    }

    /**
     * <i>“Allow or block user to use device before profile and app installation complete”</i>
     * 
     * @return property allowDeviceUseBeforeProfileAndAppInstallComplete
     */
    @Property(name="allowDeviceUseBeforeProfileAndAppInstallComplete")
    @JsonIgnore
    public Optional<Boolean> getAllowDeviceUseBeforeProfileAndAppInstallComplete() {
        return Optional.ofNullable(allowDeviceUseBeforeProfileAndAppInstallComplete);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowDeviceUseBeforeProfileAndAppInstallComplete} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Allow or block user to use device before profile and app installation complete”</i>
     * 
     * @param allowDeviceUseBeforeProfileAndAppInstallComplete
     *            new value of {@code allowDeviceUseBeforeProfileAndAppInstallComplete} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowDeviceUseBeforeProfileAndAppInstallComplete} field changed
     */
    public WindowsEnrollmentStatusScreenSettings withAllowDeviceUseBeforeProfileAndAppInstallComplete(Boolean allowDeviceUseBeforeProfileAndAppInstallComplete) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsEnrollmentStatusScreenSettings");
        _x.allowDeviceUseBeforeProfileAndAppInstallComplete = allowDeviceUseBeforeProfileAndAppInstallComplete;
        return _x;
    }

    /**
     * <i>“Allow the user to continue using the device on installation failure”</i>
     * 
     * @return property allowDeviceUseOnInstallFailure
     */
    @Property(name="allowDeviceUseOnInstallFailure")
    @JsonIgnore
    public Optional<Boolean> getAllowDeviceUseOnInstallFailure() {
        return Optional.ofNullable(allowDeviceUseOnInstallFailure);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowDeviceUseOnInstallFailure} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow the user to continue using the device on installation failure”</i>
     * 
     * @param allowDeviceUseOnInstallFailure
     *            new value of {@code allowDeviceUseOnInstallFailure} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowDeviceUseOnInstallFailure} field changed
     */
    public WindowsEnrollmentStatusScreenSettings withAllowDeviceUseOnInstallFailure(Boolean allowDeviceUseOnInstallFailure) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsEnrollmentStatusScreenSettings");
        _x.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
        return _x;
    }

    /**
     * <i>“Allow or block log collection on installation failure”</i>
     * 
     * @return property allowLogCollectionOnInstallFailure
     */
    @Property(name="allowLogCollectionOnInstallFailure")
    @JsonIgnore
    public Optional<Boolean> getAllowLogCollectionOnInstallFailure() {
        return Optional.ofNullable(allowLogCollectionOnInstallFailure);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowLogCollectionOnInstallFailure} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow or block log collection on installation failure”</i>
     * 
     * @param allowLogCollectionOnInstallFailure
     *            new value of {@code allowLogCollectionOnInstallFailure} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowLogCollectionOnInstallFailure} field changed
     */
    public WindowsEnrollmentStatusScreenSettings withAllowLogCollectionOnInstallFailure(Boolean allowLogCollectionOnInstallFailure) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsEnrollmentStatusScreenSettings");
        _x.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
        return _x;
    }

    /**
     * <i>“Allow the user to retry the setup on installation failure”</i>
     * 
     * @return property blockDeviceSetupRetryByUser
     */
    @Property(name="blockDeviceSetupRetryByUser")
    @JsonIgnore
    public Optional<Boolean> getBlockDeviceSetupRetryByUser() {
        return Optional.ofNullable(blockDeviceSetupRetryByUser);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockDeviceSetupRetryByUser} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow the user to retry the setup on installation failure”</i>
     * 
     * @param blockDeviceSetupRetryByUser
     *            new value of {@code blockDeviceSetupRetryByUser} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockDeviceSetupRetryByUser} field changed
     */
    public WindowsEnrollmentStatusScreenSettings withBlockDeviceSetupRetryByUser(Boolean blockDeviceSetupRetryByUser) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsEnrollmentStatusScreenSettings");
        _x.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
        return _x;
    }

    /**
     * <i>“Set custom error message to show upon installation failure”</i>
     * 
     * @return property customErrorMessage
     */
    @Property(name="customErrorMessage")
    @JsonIgnore
    public Optional<String> getCustomErrorMessage() {
        return Optional.ofNullable(customErrorMessage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customErrorMessage} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Set custom error message to show upon installation failure”</i>
     * 
     * @param customErrorMessage
     *            new value of {@code customErrorMessage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customErrorMessage} field changed
     */
    public WindowsEnrollmentStatusScreenSettings withCustomErrorMessage(String customErrorMessage) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsEnrollmentStatusScreenSettings");
        _x.customErrorMessage = customErrorMessage;
        return _x;
    }

    /**
     * <i>“Show or hide installation progress to user”</i>
     * 
     * @return property hideInstallationProgress
     */
    @Property(name="hideInstallationProgress")
    @JsonIgnore
    public Optional<Boolean> getHideInstallationProgress() {
        return Optional.ofNullable(hideInstallationProgress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hideInstallationProgress} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Show or hide installation progress to user”</i>
     * 
     * @param hideInstallationProgress
     *            new value of {@code hideInstallationProgress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hideInstallationProgress} field changed
     */
    public WindowsEnrollmentStatusScreenSettings withHideInstallationProgress(Boolean hideInstallationProgress) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsEnrollmentStatusScreenSettings");
        _x.hideInstallationProgress = hideInstallationProgress;
        return _x;
    }

    /**
     * <i>“Set installation progress timeout in minutes”</i>
     * 
     * @return property installProgressTimeoutInMinutes
     */
    @Property(name="installProgressTimeoutInMinutes")
    @JsonIgnore
    public Optional<Integer> getInstallProgressTimeoutInMinutes() {
        return Optional.ofNullable(installProgressTimeoutInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installProgressTimeoutInMinutes} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Set installation progress timeout in minutes”</i>
     * 
     * @param installProgressTimeoutInMinutes
     *            new value of {@code installProgressTimeoutInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installProgressTimeoutInMinutes} field changed
     */
    public WindowsEnrollmentStatusScreenSettings withInstallProgressTimeoutInMinutes(Integer installProgressTimeoutInMinutes) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsEnrollmentStatusScreenSettings");
        _x.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
        return _x;
    }

    public WindowsEnrollmentStatusScreenSettings withUnmappedField(String name, Object value) {
        WindowsEnrollmentStatusScreenSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowDeviceUseBeforeProfileAndAppInstallComplete;
        private Boolean allowDeviceUseOnInstallFailure;
        private Boolean allowLogCollectionOnInstallFailure;
        private Boolean blockDeviceSetupRetryByUser;
        private String customErrorMessage;
        private Boolean hideInstallationProgress;
        private Integer installProgressTimeoutInMinutes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Allow or block user to use device before profile and app installation complete”</i>
         * 
         * @param allowDeviceUseBeforeProfileAndAppInstallComplete
         *            value of {@code allowDeviceUseBeforeProfileAndAppInstallComplete} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowDeviceUseBeforeProfileAndAppInstallComplete(Boolean allowDeviceUseBeforeProfileAndAppInstallComplete) {
            this.allowDeviceUseBeforeProfileAndAppInstallComplete = allowDeviceUseBeforeProfileAndAppInstallComplete;
            this.changedFields = changedFields.add("allowDeviceUseBeforeProfileAndAppInstallComplete");
            return this;
        }

        /**
         * <i>“Allow the user to continue using the device on installation failure”</i>
         * 
         * @param allowDeviceUseOnInstallFailure
         *            value of {@code allowDeviceUseOnInstallFailure} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowDeviceUseOnInstallFailure(Boolean allowDeviceUseOnInstallFailure) {
            this.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
            this.changedFields = changedFields.add("allowDeviceUseOnInstallFailure");
            return this;
        }

        /**
         * <i>“Allow or block log collection on installation failure”</i>
         * 
         * @param allowLogCollectionOnInstallFailure
         *            value of {@code allowLogCollectionOnInstallFailure} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowLogCollectionOnInstallFailure(Boolean allowLogCollectionOnInstallFailure) {
            this.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
            this.changedFields = changedFields.add("allowLogCollectionOnInstallFailure");
            return this;
        }

        /**
         * <i>“Allow the user to retry the setup on installation failure”</i>
         * 
         * @param blockDeviceSetupRetryByUser
         *            value of {@code blockDeviceSetupRetryByUser} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockDeviceSetupRetryByUser(Boolean blockDeviceSetupRetryByUser) {
            this.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
            this.changedFields = changedFields.add("blockDeviceSetupRetryByUser");
            return this;
        }

        /**
         * <i>“Set custom error message to show upon installation failure”</i>
         * 
         * @param customErrorMessage
         *            value of {@code customErrorMessage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customErrorMessage(String customErrorMessage) {
            this.customErrorMessage = customErrorMessage;
            this.changedFields = changedFields.add("customErrorMessage");
            return this;
        }

        /**
         * <i>“Show or hide installation progress to user”</i>
         * 
         * @param hideInstallationProgress
         *            value of {@code hideInstallationProgress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hideInstallationProgress(Boolean hideInstallationProgress) {
            this.hideInstallationProgress = hideInstallationProgress;
            this.changedFields = changedFields.add("hideInstallationProgress");
            return this;
        }

        /**
         * <i>“Set installation progress timeout in minutes”</i>
         * 
         * @param installProgressTimeoutInMinutes
         *            value of {@code installProgressTimeoutInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installProgressTimeoutInMinutes(Integer installProgressTimeoutInMinutes) {
            this.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
            this.changedFields = changedFields.add("installProgressTimeoutInMinutes");
            return this;
        }

        public WindowsEnrollmentStatusScreenSettings build() {
            WindowsEnrollmentStatusScreenSettings _x = new WindowsEnrollmentStatusScreenSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsEnrollmentStatusScreenSettings";
            _x.allowDeviceUseBeforeProfileAndAppInstallComplete = allowDeviceUseBeforeProfileAndAppInstallComplete;
            _x.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
            _x.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
            _x.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
            _x.customErrorMessage = customErrorMessage;
            _x.hideInstallationProgress = hideInstallationProgress;
            _x.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
            return _x;
        }
    }

    private WindowsEnrollmentStatusScreenSettings _copy() {
        WindowsEnrollmentStatusScreenSettings _x = new WindowsEnrollmentStatusScreenSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowDeviceUseBeforeProfileAndAppInstallComplete = allowDeviceUseBeforeProfileAndAppInstallComplete;
        _x.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
        _x.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
        _x.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
        _x.customErrorMessage = customErrorMessage;
        _x.hideInstallationProgress = hideInstallationProgress;
        _x.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsEnrollmentStatusScreenSettings[");
        b.append("allowDeviceUseBeforeProfileAndAppInstallComplete=");
        b.append(this.allowDeviceUseBeforeProfileAndAppInstallComplete);
        b.append(", ");
        b.append("allowDeviceUseOnInstallFailure=");
        b.append(this.allowDeviceUseOnInstallFailure);
        b.append(", ");
        b.append("allowLogCollectionOnInstallFailure=");
        b.append(this.allowLogCollectionOnInstallFailure);
        b.append(", ");
        b.append("blockDeviceSetupRetryByUser=");
        b.append(this.blockDeviceSetupRetryByUser);
        b.append(", ");
        b.append("customErrorMessage=");
        b.append(this.customErrorMessage);
        b.append(", ");
        b.append("hideInstallationProgress=");
        b.append(this.hideInstallationProgress);
        b.append(", ");
        b.append("installProgressTimeoutInMinutes=");
        b.append(this.installProgressTimeoutInMinutes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
