package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "packageSid", 
    "redirectUris"})
@JsonInclude(Include.NON_NULL)
public class WindowsApplication implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("packageSid")
    protected String packageSid;

    @JsonProperty("redirectUris")
    protected List<String> redirectUris;

    @JsonProperty("redirectUris@nextLink")
    protected String redirectUrisNextLink;

    protected WindowsApplication() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsApplication";
    }

    @Property(name="packageSid")
    @JsonIgnore
    public Optional<String> getPackageSid() {
        return Optional.ofNullable(packageSid);
    }

    public WindowsApplication withPackageSid(String packageSid) {
        WindowsApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsApplication");
        _x.packageSid = packageSid;
        return _x;
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris() {
        return new CollectionPage<String>(contextPath, String.class, this.redirectUris, Optional.ofNullable(redirectUrisNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.redirectUris, Optional.ofNullable(redirectUrisNextLink), Collections.emptyList(), options);
    }

    public WindowsApplication withUnmappedField(String name, Object value) {
        WindowsApplication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String packageSid;
        private List<String> redirectUris;
        private String redirectUrisNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder packageSid(String packageSid) {
            this.packageSid = packageSid;
            this.changedFields = changedFields.add("packageSid");
            return this;
        }

        public Builder redirectUris(List<String> redirectUris) {
            this.redirectUris = redirectUris;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public Builder redirectUris(String... redirectUris) {
            return redirectUris(Arrays.asList(redirectUris));
        }

        public Builder redirectUrisNextLink(String redirectUrisNextLink) {
            this.redirectUrisNextLink = redirectUrisNextLink;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public WindowsApplication build() {
            WindowsApplication _x = new WindowsApplication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsApplication";
            _x.packageSid = packageSid;
            _x.redirectUris = redirectUris;
            _x.redirectUrisNextLink = redirectUrisNextLink;
            return _x;
        }
    }

    private WindowsApplication _copy() {
        WindowsApplication _x = new WindowsApplication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.packageSid = packageSid;
        _x.redirectUris = redirectUris;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsApplication[");
        b.append("packageSid=");
        b.append(this.packageSid);
        b.append(", ");
        b.append("redirectUris=");
        b.append(this.redirectUris);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
