package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“VPN Proxy Server.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "automaticallyDetectProxySettings", 
    "bypassProxyServerForLocalAddress"})
@JsonInclude(Include.NON_NULL)
public class Windows81VpnProxyServer extends VpnProxyServer implements ODataType {

    @JsonProperty("automaticallyDetectProxySettings")
    protected Boolean automaticallyDetectProxySettings;

    @JsonProperty("bypassProxyServerForLocalAddress")
    protected Boolean bypassProxyServerForLocalAddress;

    protected Windows81VpnProxyServer() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows81VpnProxyServer";
    }

    /**
     * <i>“Automatically detect proxy settings.”</i>
     * 
     * @return property automaticallyDetectProxySettings
     */
    @Property(name="automaticallyDetectProxySettings")
    @JsonIgnore
    public Optional<Boolean> getAutomaticallyDetectProxySettings() {
        return Optional.ofNullable(automaticallyDetectProxySettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * automaticallyDetectProxySettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Automatically detect proxy settings.”</i>
     * 
     * @param automaticallyDetectProxySettings
     *            new value of {@code automaticallyDetectProxySettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code automaticallyDetectProxySettings} field changed
     */
    public Windows81VpnProxyServer withAutomaticallyDetectProxySettings(Boolean automaticallyDetectProxySettings) {
        Windows81VpnProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81VpnProxyServer");
        _x.automaticallyDetectProxySettings = automaticallyDetectProxySettings;
        return _x;
    }

    /**
     * <i>“Bypass proxy server for local address.”</i>
     * 
     * @return property bypassProxyServerForLocalAddress
     */
    @Property(name="bypassProxyServerForLocalAddress")
    @JsonIgnore
    public Optional<Boolean> getBypassProxyServerForLocalAddress() {
        return Optional.ofNullable(bypassProxyServerForLocalAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bypassProxyServerForLocalAddress} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Bypass proxy server for local address.”</i>
     * 
     * @param bypassProxyServerForLocalAddress
     *            new value of {@code bypassProxyServerForLocalAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bypassProxyServerForLocalAddress} field changed
     */
    public Windows81VpnProxyServer withBypassProxyServerForLocalAddress(Boolean bypassProxyServerForLocalAddress) {
        Windows81VpnProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81VpnProxyServer");
        _x.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
        return _x;
    }

    public Windows81VpnProxyServer withUnmappedField(String name, Object value) {
        Windows81VpnProxyServer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows81VpnProxyServer() {
        return new Builder();
    }

    public static final class Builder {
        private String address;
        private String automaticConfigurationScriptUrl;
        private Integer port;
        private Boolean automaticallyDetectProxySettings;
        private Boolean bypassProxyServerForLocalAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder automaticConfigurationScriptUrl(String automaticConfigurationScriptUrl) {
            this.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
            this.changedFields = changedFields.add("automaticConfigurationScriptUrl");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.changedFields = changedFields.add("port");
            return this;
        }

        /**
         * <i>“Automatically detect proxy settings.”</i>
         * 
         * @param automaticallyDetectProxySettings
         *            value of {@code automaticallyDetectProxySettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder automaticallyDetectProxySettings(Boolean automaticallyDetectProxySettings) {
            this.automaticallyDetectProxySettings = automaticallyDetectProxySettings;
            this.changedFields = changedFields.add("automaticallyDetectProxySettings");
            return this;
        }

        /**
         * <i>“Bypass proxy server for local address.”</i>
         * 
         * @param bypassProxyServerForLocalAddress
         *            value of {@code bypassProxyServerForLocalAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bypassProxyServerForLocalAddress(Boolean bypassProxyServerForLocalAddress) {
            this.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
            this.changedFields = changedFields.add("bypassProxyServerForLocalAddress");
            return this;
        }

        public Windows81VpnProxyServer build() {
            Windows81VpnProxyServer _x = new Windows81VpnProxyServer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows81VpnProxyServer";
            _x.address = address;
            _x.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
            _x.port = port;
            _x.automaticallyDetectProxySettings = automaticallyDetectProxySettings;
            _x.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
            return _x;
        }
    }

    private Windows81VpnProxyServer _copy() {
        Windows81VpnProxyServer _x = new Windows81VpnProxyServer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.address = address;
        _x.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
        _x.port = port;
        _x.automaticallyDetectProxySettings = automaticallyDetectProxySettings;
        _x.bypassProxyServerForLocalAddress = bypassProxyServerForLocalAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows81VpnProxyServer[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("automaticConfigurationScriptUrl=");
        b.append(this.automaticConfigurationScriptUrl);
        b.append(", ");
        b.append("port=");
        b.append(this.port);
        b.append(", ");
        b.append("automaticallyDetectProxySettings=");
        b.append(this.automaticallyDetectProxySettings);
        b.append(", ");
        b.append("bypassProxyServerForLocalAddress=");
        b.append(this.bypassProxyServerForLocalAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
