package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppRuleOperator;
import odata.msgraph.client.beta.enums.Win32LobAppRuleType;


/**
 * <i>“A complex type to store the product code and version rule data for a Win32 LOB
 * app. This rule is not supported as a requirement rule.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "productCode", 
    "productVersion", 
    "productVersionOperator"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppProductCodeRule extends Win32LobAppRule implements ODataType {

    @JsonProperty("productCode")
    protected String productCode;

    @JsonProperty("productVersion")
    protected String productVersion;

    @JsonProperty("productVersionOperator")
    protected Win32LobAppRuleOperator productVersionOperator;

    protected Win32LobAppProductCodeRule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppProductCodeRule";
    }

    /**
     * <i>“The product code of the app.”</i>
     * 
     * @return property productCode
     */
    @Property(name="productCode")
    @JsonIgnore
    public Optional<String> getProductCode() {
        return Optional.ofNullable(productCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productCode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The product code of the app.”</i>
     * 
     * @param productCode
     *            new value of {@code productCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productCode} field changed
     */
    public Win32LobAppProductCodeRule withProductCode(String productCode) {
        Win32LobAppProductCodeRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppProductCodeRule");
        _x.productCode = productCode;
        return _x;
    }

    /**
     * <i>“The product version comparison value.”</i>
     * 
     * @return property productVersion
     */
    @Property(name="productVersion")
    @JsonIgnore
    public Optional<String> getProductVersion() {
        return Optional.ofNullable(productVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The product version comparison value.”</i>
     * 
     * @param productVersion
     *            new value of {@code productVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productVersion} field changed
     */
    public Win32LobAppProductCodeRule withProductVersion(String productVersion) {
        Win32LobAppProductCodeRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppProductCodeRule");
        _x.productVersion = productVersion;
        return _x;
    }

    /**
     * <i>“The product version comparison operator.”</i>
     * 
     * @return property productVersionOperator
     */
    @Property(name="productVersionOperator")
    @JsonIgnore
    public Optional<Win32LobAppRuleOperator> getProductVersionOperator() {
        return Optional.ofNullable(productVersionOperator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * productVersionOperator} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The product version comparison operator.”</i>
     * 
     * @param productVersionOperator
     *            new value of {@code productVersionOperator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productVersionOperator} field changed
     */
    public Win32LobAppProductCodeRule withProductVersionOperator(Win32LobAppRuleOperator productVersionOperator) {
        Win32LobAppProductCodeRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppProductCodeRule");
        _x.productVersionOperator = productVersionOperator;
        return _x;
    }

    public Win32LobAppProductCodeRule withUnmappedField(String name, Object value) {
        Win32LobAppProductCodeRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppProductCodeRule() {
        return new Builder();
    }

    public static final class Builder {
        private Win32LobAppRuleType ruleType;
        private String productCode;
        private String productVersion;
        private Win32LobAppRuleOperator productVersionOperator;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ruleType(Win32LobAppRuleType ruleType) {
            this.ruleType = ruleType;
            this.changedFields = changedFields.add("ruleType");
            return this;
        }

        /**
         * <i>“The product code of the app.”</i>
         * 
         * @param productCode
         *            value of {@code productCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productCode(String productCode) {
            this.productCode = productCode;
            this.changedFields = changedFields.add("productCode");
            return this;
        }

        /**
         * <i>“The product version comparison value.”</i>
         * 
         * @param productVersion
         *            value of {@code productVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productVersion(String productVersion) {
            this.productVersion = productVersion;
            this.changedFields = changedFields.add("productVersion");
            return this;
        }

        /**
         * <i>“The product version comparison operator.”</i>
         * 
         * @param productVersionOperator
         *            value of {@code productVersionOperator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productVersionOperator(Win32LobAppRuleOperator productVersionOperator) {
            this.productVersionOperator = productVersionOperator;
            this.changedFields = changedFields.add("productVersionOperator");
            return this;
        }

        public Win32LobAppProductCodeRule build() {
            Win32LobAppProductCodeRule _x = new Win32LobAppProductCodeRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.win32LobAppProductCodeRule";
            _x.ruleType = ruleType;
            _x.productCode = productCode;
            _x.productVersion = productVersion;
            _x.productVersionOperator = productVersionOperator;
            return _x;
        }
    }

    private Win32LobAppProductCodeRule _copy() {
        Win32LobAppProductCodeRule _x = new Win32LobAppProductCodeRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ruleType = ruleType;
        _x.productCode = productCode;
        _x.productVersion = productVersion;
        _x.productVersionOperator = productVersionOperator;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppProductCodeRule[");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append(", ");
        b.append("productCode=");
        b.append(this.productCode);
        b.append(", ");
        b.append("productVersion=");
        b.append(this.productVersion);
        b.append(", ");
        b.append("productVersionOperator=");
        b.append(this.productVersionOperator);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
