package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppMsiPackageType;


/**
 * <i>“Contains MSI app properties for a Win32 App.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "packageType", 
    "productCode", 
    "productName", 
    "productVersion", 
    "publisher", 
    "requiresReboot", 
    "upgradeCode"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppMsiInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("packageType")
    protected Win32LobAppMsiPackageType packageType;

    @JsonProperty("productCode")
    protected String productCode;

    @JsonProperty("productName")
    protected String productName;

    @JsonProperty("productVersion")
    protected String productVersion;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("requiresReboot")
    protected Boolean requiresReboot;

    @JsonProperty("upgradeCode")
    protected String upgradeCode;

    protected Win32LobAppMsiInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppMsiInformation";
    }

    /**
     * <i>“The MSI package type.”</i>
     * 
     * @return property packageType
     */
    @Property(name="packageType")
    @JsonIgnore
    public Optional<Win32LobAppMsiPackageType> getPackageType() {
        return Optional.ofNullable(packageType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code packageType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MSI package type.”</i>
     * 
     * @param packageType
     *            new value of {@code packageType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code packageType} field changed
     */
    public Win32LobAppMsiInformation withPackageType(Win32LobAppMsiPackageType packageType) {
        Win32LobAppMsiInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppMsiInformation");
        _x.packageType = packageType;
        return _x;
    }

    /**
     * <i>“The MSI product code.”</i>
     * 
     * @return property productCode
     */
    @Property(name="productCode")
    @JsonIgnore
    public Optional<String> getProductCode() {
        return Optional.ofNullable(productCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productCode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MSI product code.”</i>
     * 
     * @param productCode
     *            new value of {@code productCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productCode} field changed
     */
    public Win32LobAppMsiInformation withProductCode(String productCode) {
        Win32LobAppMsiInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppMsiInformation");
        _x.productCode = productCode;
        return _x;
    }

    /**
     * <i>“The MSI product name.”</i>
     * 
     * @return property productName
     */
    @Property(name="productName")
    @JsonIgnore
    public Optional<String> getProductName() {
        return Optional.ofNullable(productName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MSI product name.”</i>
     * 
     * @param productName
     *            new value of {@code productName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productName} field changed
     */
    public Win32LobAppMsiInformation withProductName(String productName) {
        Win32LobAppMsiInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppMsiInformation");
        _x.productName = productName;
        return _x;
    }

    /**
     * <i>“The MSI product version.”</i>
     * 
     * @return property productVersion
     */
    @Property(name="productVersion")
    @JsonIgnore
    public Optional<String> getProductVersion() {
        return Optional.ofNullable(productVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MSI product version.”</i>
     * 
     * @param productVersion
     *            new value of {@code productVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productVersion} field changed
     */
    public Win32LobAppMsiInformation withProductVersion(String productVersion) {
        Win32LobAppMsiInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppMsiInformation");
        _x.productVersion = productVersion;
        return _x;
    }

    /**
     * <i>“The MSI publisher.”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The MSI publisher.”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public Win32LobAppMsiInformation withPublisher(String publisher) {
        Win32LobAppMsiInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppMsiInformation");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“Whether the MSI app requires the machine to reboot to complete installation.”</i>
     * 
     * @return property requiresReboot
     */
    @Property(name="requiresReboot")
    @JsonIgnore
    public Optional<Boolean> getRequiresReboot() {
        return Optional.ofNullable(requiresReboot);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requiresReboot}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the MSI app requires the machine to reboot to complete installation.”</i>
     * 
     * @param requiresReboot
     *            new value of {@code requiresReboot} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiresReboot} field changed
     */
    public Win32LobAppMsiInformation withRequiresReboot(Boolean requiresReboot) {
        Win32LobAppMsiInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppMsiInformation");
        _x.requiresReboot = requiresReboot;
        return _x;
    }

    /**
     * <i>“The MSI upgrade code.”</i>
     * 
     * @return property upgradeCode
     */
    @Property(name="upgradeCode")
    @JsonIgnore
    public Optional<String> getUpgradeCode() {
        return Optional.ofNullable(upgradeCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code upgradeCode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MSI upgrade code.”</i>
     * 
     * @param upgradeCode
     *            new value of {@code upgradeCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeCode} field changed
     */
    public Win32LobAppMsiInformation withUpgradeCode(String upgradeCode) {
        Win32LobAppMsiInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppMsiInformation");
        _x.upgradeCode = upgradeCode;
        return _x;
    }

    public Win32LobAppMsiInformation withUnmappedField(String name, Object value) {
        Win32LobAppMsiInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Win32LobAppMsiPackageType packageType;
        private String productCode;
        private String productName;
        private String productVersion;
        private String publisher;
        private Boolean requiresReboot;
        private String upgradeCode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The MSI package type.”</i>
         * 
         * @param packageType
         *            value of {@code packageType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder packageType(Win32LobAppMsiPackageType packageType) {
            this.packageType = packageType;
            this.changedFields = changedFields.add("packageType");
            return this;
        }

        /**
         * <i>“The MSI product code.”</i>
         * 
         * @param productCode
         *            value of {@code productCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productCode(String productCode) {
            this.productCode = productCode;
            this.changedFields = changedFields.add("productCode");
            return this;
        }

        /**
         * <i>“The MSI product name.”</i>
         * 
         * @param productName
         *            value of {@code productName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productName(String productName) {
            this.productName = productName;
            this.changedFields = changedFields.add("productName");
            return this;
        }

        /**
         * <i>“The MSI product version.”</i>
         * 
         * @param productVersion
         *            value of {@code productVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productVersion(String productVersion) {
            this.productVersion = productVersion;
            this.changedFields = changedFields.add("productVersion");
            return this;
        }

        /**
         * <i>“The MSI publisher.”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“Whether the MSI app requires the machine to reboot to complete installation.”</i>
         * 
         * @param requiresReboot
         *            value of {@code requiresReboot} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiresReboot(Boolean requiresReboot) {
            this.requiresReboot = requiresReboot;
            this.changedFields = changedFields.add("requiresReboot");
            return this;
        }

        /**
         * <i>“The MSI upgrade code.”</i>
         * 
         * @param upgradeCode
         *            value of {@code upgradeCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeCode(String upgradeCode) {
            this.upgradeCode = upgradeCode;
            this.changedFields = changedFields.add("upgradeCode");
            return this;
        }

        public Win32LobAppMsiInformation build() {
            Win32LobAppMsiInformation _x = new Win32LobAppMsiInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.win32LobAppMsiInformation";
            _x.packageType = packageType;
            _x.productCode = productCode;
            _x.productName = productName;
            _x.productVersion = productVersion;
            _x.publisher = publisher;
            _x.requiresReboot = requiresReboot;
            _x.upgradeCode = upgradeCode;
            return _x;
        }
    }

    private Win32LobAppMsiInformation _copy() {
        Win32LobAppMsiInformation _x = new Win32LobAppMsiInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.packageType = packageType;
        _x.productCode = productCode;
        _x.productName = productName;
        _x.productVersion = productVersion;
        _x.publisher = publisher;
        _x.requiresReboot = requiresReboot;
        _x.upgradeCode = upgradeCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppMsiInformation[");
        b.append("packageType=");
        b.append(this.packageType);
        b.append(", ");
        b.append("productCode=");
        b.append(this.productCode);
        b.append(", ");
        b.append("productName=");
        b.append(this.productName);
        b.append(", ");
        b.append("productVersion=");
        b.append(this.productVersion);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("requiresReboot=");
        b.append(this.requiresReboot);
        b.append(", ");
        b.append("upgradeCode=");
        b.append(this.upgradeCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
