package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppDetectionOperator;
import odata.msgraph.client.beta.enums.Win32LobAppFileSystemDetectionType;


/**
 * <i>“Contains file or folder path to detect a Win32 App”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "check32BitOn64System", 
    "detectionType", 
    "detectionValue", 
    "fileOrFolderName", 
    "operator", 
    "path"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppFileSystemDetection extends Win32LobAppDetection implements ODataType {

    @JsonProperty("check32BitOn64System")
    protected Boolean check32BitOn64System;

    @JsonProperty("detectionType")
    protected Win32LobAppFileSystemDetectionType detectionType;

    @JsonProperty("detectionValue")
    protected String detectionValue;

    @JsonProperty("fileOrFolderName")
    protected String fileOrFolderName;

    @JsonProperty("operator")
    protected Win32LobAppDetectionOperator operator;

    @JsonProperty("path")
    protected String path;

    protected Win32LobAppFileSystemDetection() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppFileSystemDetection";
    }

    /**
     * <i>“A value indicating whether this file or folder is for checking 32-bit app on 64-
     * bit system”</i>
     * 
     * @return property check32BitOn64System
     */
    @Property(name="check32BitOn64System")
    @JsonIgnore
    public Optional<Boolean> getCheck32BitOn64System() {
        return Optional.ofNullable(check32BitOn64System);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * check32BitOn64System} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A value indicating whether this file or folder is for checking 32-bit app on 64-
     * bit system”</i>
     * 
     * @param check32BitOn64System
     *            new value of {@code check32BitOn64System} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code check32BitOn64System} field changed
     */
    public Win32LobAppFileSystemDetection withCheck32BitOn64System(Boolean check32BitOn64System) {
        Win32LobAppFileSystemDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemDetection");
        _x.check32BitOn64System = check32BitOn64System;
        return _x;
    }

    /**
     * <i>“The file system detection type”</i>
     * 
     * @return property detectionType
     */
    @Property(name="detectionType")
    @JsonIgnore
    public Optional<Win32LobAppFileSystemDetectionType> getDetectionType() {
        return Optional.ofNullable(detectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The file system detection type”</i>
     * 
     * @param detectionType
     *            new value of {@code detectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionType} field changed
     */
    public Win32LobAppFileSystemDetection withDetectionType(Win32LobAppFileSystemDetectionType detectionType) {
        Win32LobAppFileSystemDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemDetection");
        _x.detectionType = detectionType;
        return _x;
    }

    /**
     * <i>“The file or folder detection value”</i>
     * 
     * @return property detectionValue
     */
    @Property(name="detectionValue")
    @JsonIgnore
    public Optional<String> getDetectionValue() {
        return Optional.ofNullable(detectionValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The file or folder detection value”</i>
     * 
     * @param detectionValue
     *            new value of {@code detectionValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionValue} field changed
     */
    public Win32LobAppFileSystemDetection withDetectionValue(String detectionValue) {
        Win32LobAppFileSystemDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemDetection");
        _x.detectionValue = detectionValue;
        return _x;
    }

    /**
     * <i>“The file or folder name to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @return property fileOrFolderName
     */
    @Property(name="fileOrFolderName")
    @JsonIgnore
    public Optional<String> getFileOrFolderName() {
        return Optional.ofNullable(fileOrFolderName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileOrFolderName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The file or folder name to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @param fileOrFolderName
     *            new value of {@code fileOrFolderName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileOrFolderName} field changed
     */
    public Win32LobAppFileSystemDetection withFileOrFolderName(String fileOrFolderName) {
        Win32LobAppFileSystemDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemDetection");
        _x.fileOrFolderName = fileOrFolderName;
        return _x;
    }

    /**
     * <i>“The operator for file or folder detection”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<Win32LobAppDetectionOperator> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operator for file or folder detection”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public Win32LobAppFileSystemDetection withOperator(Win32LobAppDetectionOperator operator) {
        Win32LobAppFileSystemDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemDetection");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The file or folder path to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @return property path
     */
    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code path} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The file or folder path to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @param path
     *            new value of {@code path} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code path} field changed
     */
    public Win32LobAppFileSystemDetection withPath(String path) {
        Win32LobAppFileSystemDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemDetection");
        _x.path = path;
        return _x;
    }

    public Win32LobAppFileSystemDetection withUnmappedField(String name, Object value) {
        Win32LobAppFileSystemDetection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppFileSystemDetection() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean check32BitOn64System;
        private Win32LobAppFileSystemDetectionType detectionType;
        private String detectionValue;
        private String fileOrFolderName;
        private Win32LobAppDetectionOperator operator;
        private String path;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“A value indicating whether this file or folder is for checking 32-bit app on 64-
         * bit system”</i>
         * 
         * @param check32BitOn64System
         *            value of {@code check32BitOn64System} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder check32BitOn64System(Boolean check32BitOn64System) {
            this.check32BitOn64System = check32BitOn64System;
            this.changedFields = changedFields.add("check32BitOn64System");
            return this;
        }

        /**
         * <i>“The file system detection type”</i>
         * 
         * @param detectionType
         *            value of {@code detectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionType(Win32LobAppFileSystemDetectionType detectionType) {
            this.detectionType = detectionType;
            this.changedFields = changedFields.add("detectionType");
            return this;
        }

        /**
         * <i>“The file or folder detection value”</i>
         * 
         * @param detectionValue
         *            value of {@code detectionValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionValue(String detectionValue) {
            this.detectionValue = detectionValue;
            this.changedFields = changedFields.add("detectionValue");
            return this;
        }

        /**
         * <i>“The file or folder name to detect Win32 Line of Business (LoB) app”</i>
         * 
         * @param fileOrFolderName
         *            value of {@code fileOrFolderName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileOrFolderName(String fileOrFolderName) {
            this.fileOrFolderName = fileOrFolderName;
            this.changedFields = changedFields.add("fileOrFolderName");
            return this;
        }

        /**
         * <i>“The operator for file or folder detection”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(Win32LobAppDetectionOperator operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“The file or folder path to detect Win32 Line of Business (LoB) app”</i>
         * 
         * @param path
         *            value of {@code path} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public Win32LobAppFileSystemDetection build() {
            Win32LobAppFileSystemDetection _x = new Win32LobAppFileSystemDetection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.win32LobAppFileSystemDetection";
            _x.check32BitOn64System = check32BitOn64System;
            _x.detectionType = detectionType;
            _x.detectionValue = detectionValue;
            _x.fileOrFolderName = fileOrFolderName;
            _x.operator = operator;
            _x.path = path;
            return _x;
        }
    }

    private Win32LobAppFileSystemDetection _copy() {
        Win32LobAppFileSystemDetection _x = new Win32LobAppFileSystemDetection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.check32BitOn64System = check32BitOn64System;
        _x.detectionType = detectionType;
        _x.detectionValue = detectionValue;
        _x.fileOrFolderName = fileOrFolderName;
        _x.operator = operator;
        _x.path = path;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppFileSystemDetection[");
        b.append("check32BitOn64System=");
        b.append(this.check32BitOn64System);
        b.append(", ");
        b.append("detectionType=");
        b.append(this.detectionType);
        b.append(", ");
        b.append("detectionValue=");
        b.append(this.detectionValue);
        b.append(", ");
        b.append("fileOrFolderName=");
        b.append(this.fileOrFolderName);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
