package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WebsiteType;

@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "displayName", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class Website implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("address")
    protected String address;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("type")
    protected WebsiteType type;

    protected Website() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.website";
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    public Website withAddress(String address) {
        Website _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.website");
        _x.address = address;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Website withDisplayName(String displayName) {
        Website _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.website");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<WebsiteType> getType() {
        return Optional.ofNullable(type);
    }

    public Website withType(WebsiteType type) {
        Website _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.website");
        _x.type = type;
        return _x;
    }

    public Website withUnmappedField(String name, Object value) {
        Website _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String address;
        private String displayName;
        private WebsiteType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder type(WebsiteType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Website build() {
            Website _x = new Website();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.website";
            _x.address = address;
            _x.displayName = displayName;
            _x.type = type;
            return _x;
        }
    }

    private Website _copy() {
        Website _x = new Website();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.address = address;
        _x.displayName = displayName;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Website[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
