package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WarrantyType;


/**
 * <i>“Models and Manufactures meatadata for managed devices in the account”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "endDateTime", 
    "startDateTime", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class WarrantyOffer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("type")
    protected WarrantyType type;

    protected WarrantyOffer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.warrantyOffer";
    }

    /**
     * <i>“Warranty offer description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Warranty offer description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WarrantyOffer withDescription(String description) {
        WarrantyOffer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.warrantyOffer");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Warranty offer end date”</i>
     * 
     * @return property endDateTime
     */
    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Warranty offer end date”</i>
     * 
     * @param endDateTime
     *            new value of {@code endDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endDateTime} field changed
     */
    public WarrantyOffer withEndDateTime(OffsetDateTime endDateTime) {
        WarrantyOffer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.warrantyOffer");
        _x.endDateTime = endDateTime;
        return _x;
    }

    /**
     * <i>“Warranty offer start date”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Warranty offer start date”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public WarrantyOffer withStartDateTime(OffsetDateTime startDateTime) {
        WarrantyOffer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.warrantyOffer");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“Warranty offer type”</i>
     * 
     * @return property type
     */
    @Property(name="type")
    @JsonIgnore
    public Optional<WarrantyType> getType() {
        return Optional.ofNullable(type);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code type} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Warranty offer type”</i>
     * 
     * @param type
     *            new value of {@code type} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code type} field changed
     */
    public WarrantyOffer withType(WarrantyType type) {
        WarrantyOffer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.warrantyOffer");
        _x.type = type;
        return _x;
    }

    public WarrantyOffer withUnmappedField(String name, Object value) {
        WarrantyOffer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private OffsetDateTime endDateTime;
        private OffsetDateTime startDateTime;
        private WarrantyType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Warranty offer description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Warranty offer end date”</i>
         * 
         * @param endDateTime
         *            value of {@code endDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        /**
         * <i>“Warranty offer start date”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Warranty offer type”</i>
         * 
         * @param type
         *            value of {@code type} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder type(WarrantyType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public WarrantyOffer build() {
            WarrantyOffer _x = new WarrantyOffer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.warrantyOffer";
            _x.description = description;
            _x.endDateTime = endDateTime;
            _x.startDateTime = startDateTime;
            _x.type = type;
            return _x;
        }
    }

    private WarrantyOffer _copy() {
        WarrantyOffer _x = new WarrantyOffer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.endDateTime = endDateTime;
        _x.startDateTime = startDateTime;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WarrantyOffer[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
